<?php
/**
 * Speaker
 * Create an audio version of your posts, with a selection of more than 340 voices across more than 52 languages and variants.
 * Exclusively on https://1.envato.market/speaker
 *
 * @encoding        UTF-8
 * @version         4.1.10
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Alexander Khmelnitskiy (info@alexander.khmelnitskiy.ua), Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

namespace Merkulove\Speaker;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
    header( 'Status: 403 Forbidden' );
    header( 'HTTP/1.1 403 Forbidden' );
    exit;
}

use Exception;

class wpbSpeaker {

	/**
	 * Get things started.
	 *
	 * @throws Exception
	 * @access public
	 **/
	public function __construct() {

		/** Speaker addon map. */
        $this->params_map();

		/** Shortcode for Speaker addon. */
		add_shortcode( 'vce_speaker', [ $this, 'render' ] );

	}

    /**
     * Shortcode [mdp_wpb_speaker] output.
     *
     * @param $atts - Shortcode parameters.
     *
     * @return false|string
     * @access public
     **/
    public function render( $atts ) {

	    /** Check, just in case. */
	    if ( ! function_exists( 'vc_map' ) ) { return ''; }

	    /** Prepare element parameters. */
	    $css = '';

	    extract( shortcode_atts( [
		    'css' => ''
	    ], $atts ) );

	    /** Prepare custom css from css_editor. */
	    $css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css ), 'vce_speaker', $atts );

	    ob_start();

        ?><div class="mdp-vce-speaker-box <?php echo esc_attr( $css_class ); ?>" ><?php echo Player::the_player( get_the_ID(), false ); ?></div><?php

	    return ob_get_clean();

    }

    /**
     * Speaker addon map.
     *
     * @throws Exception
     **/
    public function params_map() {

        /** Check, just in case. */
        if ( ! function_exists( 'vc_map' ) ) { return; }

        /** Add [mdp_wpb_speaker] shortcode to the WPBakery Page Builder */
	    vc_map( [
		    'name'                      => 'Speaker',
		    'description'               => esc_html__( 'Create an audio version of your posts, with a selection of more than 275 voices across 45+ languages and variants.', 'speaker' ),
		    'base'                      => 'vce_speaker',
		    'icon'                      => 'icon-mdp-speaker',
		    'category'                  => esc_html__( 'Social', 'speaker' ),
		    'show_settings_on_create'   => false,
		    'params'                    => [
			    [
				    'param_name'    => 'css',
				    'type'          => 'css_editor',
				    'heading'       => esc_html__( 'CSS', 'speaker' ),
				    'group'         => esc_html__( 'Design options', 'speaker' ),
			    ]
		    ],
	    ] );

    }

}
/** Run Speaker addon. */
new wpbSpeaker();
