<?php

namespace Merkulove\Speaker\Unity;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

class UnityFilters
{
    private static ?UnityFilters $instance = null;

    private function __construct()
    {
        // Add a custom cron schedule
	    add_filter('cron_schedules', [$this, 'cron_schedules']);
    }

    /**
     * Add a custom cron schedule
     * @param $schedules
     * @return mixed
     */
    public function cron_schedules($schedules)
    {
        $schedules['every_minute'] = [
            'interval' => 60,
            'display' => esc_html__('Every Minute', 'speaker'),
        ];

	    // Every 3 minutes schedule
	    $schedules['every_three_minutes'] = [
		    'interval' => 180,
		    'display' => esc_html__('Every 3 Minutes', 'speaker'),
	    ];

	    // Every 5 minutes schedule
	    $schedules['every_five_minutes'] = [
		    'interval' => 300,
		    'display' => esc_html__('Every 5 Minutes', 'speaker'),
	    ];

        return $schedules;
    }

    public static function get_instance(): UnityFilters
    {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __clone()
    {
    }

    public function __wakeup()
    {
    }
}

