<?php

// autoload_real.php @generated by Composer

class ComposerAutoloaderInitd7fc08b6ee43be5a9307db64fspeaker
{
    private static $loader;

    public static function loadClassLoader($class)
    {
        if ('Composer\Autoload\ClassLoader' === $class) {
            require __DIR__ . '/ClassLoader.php';
        }
    }

    /**
     * @return \Composer\Autoload\ClassLoader
     */
    public static function getLoader()
    {
        if (null !== self::$loader) {
            return self::$loader;
        }

        require __DIR__ . '/platform_check.php';

        spl_autoload_register(array('ComposerAutoloaderInitd7fc08b6ee43be5a9307db64fspeaker', 'loadClassLoader'), true, true);
        self::$loader = $loader = new \Composer\Autoload\ClassLoader(\dirname(\dirname(__FILE__)));
        spl_autoload_unregister(array('ComposerAutoloaderInitd7fc08b6ee43be5a9307db64fspeaker', 'loadClassLoader'));

        $useStaticLoader = PHP_VERSION_ID >= 50600 && !defined('HHVM_VERSION') && (!function_exists('zend_loader_file_encoded') || !zend_loader_file_encoded());
        if ($useStaticLoader) {
            require __DIR__ . '/autoload_static.php';

            call_user_func(\Composer\Autoload\ComposerStaticInitd7fc08b6ee43be5a9307db64fspeaker::getInitializer($loader));
        } else {
            $map = require __DIR__ . '/autoload_namespaces.php';
            foreach ($map as $namespace => $path) {
                $loader->set($namespace, $path);
            }

            $map = require __DIR__ . '/autoload_psr4.php';
            foreach ($map as $namespace => $path) {
                $loader->setPsr4($namespace, $path);
            }

            $classMap = require __DIR__ . '/autoload_classmap.php';
            if ($classMap) {
                $loader->addClassMap($classMap);
            }
        }

        $loader->register(true);

        if ($useStaticLoader) {

            // .\\ Load classes without Guzzle if Guzzle/Utils aready loaded by other plugin
            if ( class_exists( 'GuzzleHttp\Utils' ) ) {

                $includeFiles = Composer\Autoload\ComposerStaticInitd7fc08b6ee43be5a9307db64fspeaker::$filesGuzzles;

            } else {

                $includeFiles = Composer\Autoload\ComposerStaticInitd7fc08b6ee43be5a9307db64fspeaker::$files;

            }

        } else {
            $includeFiles = require __DIR__ . '/autoload_files.php';
        }
        foreach ($includeFiles as $fileIdentifier => $file) {
            composerRequired7fc08b6ee43be5a9307db64fspeaker($fileIdentifier, $file);
        }

        return $loader;
    }
}

function composerRequired7fc08b6ee43be5a9307db64fspeaker($fileIdentifier, $file)
{
    if (empty($GLOBALS['__composer_autoload_files'][$fileIdentifier])) {
        require $file;

        $GLOBALS['__composer_autoload_files'][$fileIdentifier] = true;
    }
}
