/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./wp-content/plugins/speaker/source/js/includes/_utils.js"
/*!*****************************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/includes/_utils.js ***!
  \*****************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStorageSettings: () => (/* binding */ getStorageSettings),
/* harmony export */   setWPMediaElementSpeed: () => (/* binding */ setWPMediaElementSpeed),
/* harmony export */   updateStorage: () => (/* binding */ updateStorage)
/* harmony export */ });
// noinspection JSUnresolvedReference

/**
 * Get settings from storage by key
 * @param key
 * @returns {boolean|*}
 */
function getStorageSettings( key ) {

    let storedSettings = window.localStorage.getItem( 'mdpSpeaker' );

    if ( storedSettings ) {

        let localStorage = JSON.parse( storedSettings );
        return localStorage[ key ] ? localStorage[ key ] : false;

    } else {

        return false;

    }

}

/**
 * Update local storage
 * @param key
 * @param value
 */
function updateStorage( key, value ) {

    const storage = window.localStorage.getItem( 'mdpSpeaker' );

    if ( storage ) {

        let localStorage = JSON.parse( storage );
        localStorage[ key ] = value;

        window.localStorage.setItem( 'mdpSpeaker', JSON.stringify( localStorage ) );

    } else {

        let localStorage = {};
        localStorage[ key ] = value;

        window.localStorage.setItem( 'mdpSpeaker', JSON.stringify( localStorage ) );

    }

}

/**
 * Set initial speed for mediaelement player by wrapper element
 * @param $playerWrapper
 * @param speed
 */
function setWPMediaElementSpeed( $playerWrapper, speed = false ) {

    // Set initial speed
    if ( ! speed ) {
        let storageSpeed = getStorageSettings( 'speed' ) ?? false;
        speed = ! storageSpeed ? 1 : storageSpeed;
    }

    // Get audio tag
    const $singleAudioTag = $playerWrapper.querySelector( 'audio' );
    if ( ! $singleAudioTag ) { return; }

    // WP Media Element Player
    if ( typeof window.MediaElementPlayer === 'function' ) {

        new MediaElementPlayer( $singleAudioTag.id ?? '' );

    }

    $singleAudioTag.playbackRate = speed;

}


/***/ },

/***/ "./wp-content/plugins/speaker/source/js/includes/analytics/_frontend.js"
/*!******************************************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/includes/analytics/_frontend.js ***!
  \******************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   audioTagAnalytics: () => (/* binding */ audioTagAnalytics),
/* harmony export */   initAnalytics: () => (/* binding */ initAnalytics)
/* harmony export */ });
const { analytics } = window.mdpSpeaker;

/**
 * Init analytics
 */
function initAnalytics() {

    if ( ! JSON.parse( analytics.enable ) ) { return; }

    const wrappers = document.querySelectorAll( '.mdp-speaker-wrapper' );

    wrappers.forEach( $wrapper => {

        const $dataWrapper = $wrapper.querySelector( '.mdp-speaker-player' );

        $dataWrapper.addEventListener(
            'speaker-analytics-init',
            (e) => analyticsSend( 'init', e.detail ),
            false
        );

        $dataWrapper.addEventListener(
            'speaker-analytics-play',
            (e) => analyticsSend( 'play', e.detail ),
            false
        );

        $dataWrapper.addEventListener(
            'speaker-analytics-pause',
            (e) => analyticsSend( 'pause', e.detail ),
            false
        );

        $dataWrapper.addEventListener(
            'speaker-analytics-time',
            (e) => analyticsSend( 'time', e.detail ),
            false
        );

        $dataWrapper.addEventListener(
            'speaker-analytics-end',
            (e) => analyticsSend( 'end', e.detail ),
            false
        );


    } );

}

/**
 * Init analytics for audio tag based on vanilla JS events
 * @param $audio
 */
function audioTagAnalytics( $audio ) {

    if ( ! $audio ) { return; }
    if ( ! JSON.parse( analytics.enable ) ) { return; }

    const $dataHolder = $audio.closest( '.mdp-speaker-player' );
    if ( ! $dataHolder ) { return; }

    // Skip if wavesurfer and mediaelement player because it has its own analytics
    let playerType = $dataHolder.getAttribute( 'data-type' );
    if ( playerType === 'speaker-wavesurfer' ) {
        return;
    }

    const id = $dataHolder.getAttribute( 'data-id' );

    // Init for browser default player because init event is not fired for it
    if ( playerType === 'speaker-browser-default' ) {

        // Init for browser default player
        const analyticsInit = new CustomEvent( 'speaker-analytics-init', { detail: { id: id } } );
        $dataHolder.dispatchEvent( analyticsInit );

    }

    // Init for other player types
    $audio.addEventListener( 'loadstart', function() {

        const analyticsInit = new CustomEvent( 'speaker-analytics-init', { detail: { id: id } } );
        $dataHolder.dispatchEvent( analyticsInit );

    } );

    // Play
    $audio.addEventListener( 'play', function() {

        const analyticsPlay = new CustomEvent( 'speaker-analytics-play', { detail: { id: id } } );
        $dataHolder.dispatchEvent( analyticsPlay );

    } );

    // Pause
    $audio.addEventListener( 'pause', function() {

        const analyticsPause = new CustomEvent( 'speaker-analytics-pause', { detail: { id: id } } );
        $dataHolder.dispatchEvent( analyticsPause );

    }  );

    // End
    $audio.addEventListener( 'ended', function() {

        const analyticsEnd = new CustomEvent( 'speaker-analytics-end', { detail: { id: id } } );
        $dataHolder.dispatchEvent( analyticsEnd );

    } );

    // Time changed
    let prevTime = 0;
    $audio.addEventListener( 'timeupdate', function() {

        let nowTime = Math.floor( $audio.currentTime );

        if ( nowTime - prevTime >= parseInt( analytics.precision ) ) {

            const analyticsTime = new CustomEvent( 'speaker-analytics-time', {
                detail: {
                    id: id,
                    time: nowTime
                }
            } );

            $dataHolder.dispatchEvent( analyticsTime );

            prevTime = nowTime;

        }

    } );

}

/**
 * Send analytics
 * @param event
 * @param data
 */
function analyticsSend( event, data ) {

    const { ajaxUrl, nonce } = window.mdpSpeaker.analytics;

    const request = new XMLHttpRequest();
    request.open( 'POST', ajaxUrl, true );
    request.setRequestHeader( 'Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8' );

    let request_data = `action=speaker_analytics&nonce=${ nonce }&event=${ event }&id=${ data.id }`;
    if ( event === 'time' ) {
        request_data += `&time=${ analytics.precision }`;
    }

    request.send( request_data );

}


/***/ },

/***/ "./wp-content/plugins/speaker/source/js/includes/libs/iOSunmute.js"
/*!*************************************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/includes/libs/iOSunmute.js ***!
  \*************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   unmute: () => (/* binding */ unmute)
/* harmony export */ });

/**
 * @file unmute.ts
 * @author Spencer Evans evans.spencer@gmail.com
 *
 * unmute is a disgusting hack that helps..
 * 	1) automatically resume web audio contexts on user interaction
 * 	2) automatically pause and resume web audio when the page is hidden.
 * 	3) ios only: web audio play on the media channel rather than the ringer channel
 * 	4) ios only: disable the media playback widget and airplay when:
 *
 * WebAudio is automatically resumed by checking context state and resuming whenever possible.
 *
 * WebAudio pausing is accomplished by watching the page visilibility API. When on iOS, page focus
 * is also used to determine if the page is in the foreground because Apple's page vis api implementation is buggy.
 *
 * iOS Only: Forcing WebAudio onto the media channel (instead of the ringer channel) works by playing
 * a short, high-quality, silent html audio track continuously when web audio is playing.
 *
 * iOS Only: Hiding the media playback widgets on iOS is accomplished by completely nuking the silent
 * html audio track whenever the app isn't in the foreground.
 *
 * iOS detection is done by looking at the user agent for iPhone, iPod, iPad. This detects the phones fine, but
 * apple likes to pretend their new iPads are computers (lol right..). Newer iPads are detected by finding
 * mac osx in the user agent and then checking for touch support by testing navigator.maxTouchPoints > 0.
 *
 * This is all really gross and apple should really fix their janky browser.
 * This code isn't optimized in any fashion, it is just whipped up to help someone out on stack overflow, its just meant as an example.
 */
/**
 * Enables unmute.
 * @param context A reference to the web audio context to "unmute".
 * @param allowBackgroundPlayback Optional. Default false. Allows audio to continue to play in the background. This is not recommended because it will burn battery and display playback controls on the iOS lockscreen.
 * @param forceIOSBehavior Optional. Default false. Forces behavior to that which is on iOS. This *could* be used in the event the iOS detection fails (which it shouldn't). It is strongly recommended NOT to use this.
 * @returns An object containing a dispose function which can be used to dispose of the unmute controller.
 */
function unmute(context, allowBackgroundPlayback, forceIOSBehavior) {
    if (allowBackgroundPlayback === void 0) { allowBackgroundPlayback = false; }
    if (forceIOSBehavior === void 0) { forceIOSBehavior = false; }
    //#region Helpers
    // Determine the page visibility api
    var pageVisibilityAPI;
    if (document.hidden !== undefined)
        pageVisibilityAPI = { hidden: "hidden", visibilitychange: "visibilitychange" };
    else if (document.webkitHidden !== undefined)
        pageVisibilityAPI = { hidden: "webkitHidden", visibilitychange: "webkitvisibilitychange" };
    else if (document.mozHidden !== undefined)
        pageVisibilityAPI = { hidden: "mozHidden", visibilitychange: "mozvisibilitychange" };
    else if (document.msHidden !== undefined)
        pageVisibilityAPI = { hidden: "msHidden", visibilitychange: "msvisibilitychange" };
    // Helpers to add/remove a bunch of event listeners
    function addEventListeners(target, events, handler, capture, passive) { for (var i = 0; i < events.length; ++i)
        target.addEventListener(events[i], handler, { capture: capture, passive: passive }); }
    function removeEventListeners(target, events, handler, capture, passive) { for (var i = 0; i < events.length; ++i)
        target.removeEventListener(events[i], handler, { capture: capture, passive: passive }); }
    /**
     * Helper no-operation function to ignore promises safely
     */
    function noop() { }
    //#endregion
    //#region iOS Detection
    var ua = navigator.userAgent.toLowerCase();
    var isIOS = (forceIOSBehavior ||
        (ua.indexOf("iphone") >= 0 && ua.indexOf("like iphone") < 0) ||
        (ua.indexOf("ipad") >= 0 && ua.indexOf("like ipad") < 0) ||
        (ua.indexOf("ipod") >= 0 && ua.indexOf("like ipod") < 0) ||
        (ua.indexOf("mac os x") >= 0 && navigator.maxTouchPoints > 0) // New ipads show up as macs in user agent, but they have a touch screen
    );
    //#endregion
    //#region Playback Allowed State
    /** Indicates if audio should be allowed to play. */
    var allowPlayback = true; // Assume page is visible and focused by default
    /**
     * Updates playback state.
     */
    function updatePlaybackState() {
        // Check if should be active
        var shouldAllowPlayback = (allowBackgroundPlayback || ( // always be active if noPause is indicated
            (!pageVisibilityAPI || !document[pageVisibilityAPI.hidden]) && // can be active if no page vis api, or page not hidden
            (!isIOS || document.hasFocus()) // if ios, then document must also be focused because their page vis api is buggy
        ) ? true : false);
        // Change state
        if (shouldAllowPlayback !== allowPlayback) {
            allowPlayback = shouldAllowPlayback;
            // Update the channel state
            updateChannelState(false);
            // The playback allowed state has changed, update the context state to suspend / resume accordingly
            updateContextState();
        }
    }
    /**
     * Handle visibility api events.
     */
    function doc_visChange() {
        updatePlaybackState();
    }
    if (pageVisibilityAPI)
        addEventListeners(document, [pageVisibilityAPI.visibilitychange], doc_visChange, true, true);
    /**
     * Handles blur events (only used on iOS because it doesn't dispatch vis change events properly).
     */
    function win_focusChange(evt) {
        if (evt && evt.target !== window)
            return; // ignore bubbles
        updatePlaybackState();
    }
    if (isIOS)
        addEventListeners(window, ["focus", "blur"], win_focusChange, true, true);
    //#endregion
    //#region WebAudio Context State
    /**
     * Updates the context state.
     * NOTE: apple supports (and poorly at that) the proposed "interrupted" state spec, just ignore that for now.
     */
    function updateContextState() {
        if (allowPlayback) {
            // Want to be running, so try resuming if necessary
            if (context.state !== "running" && context.state !== "closed") // do nothing if the context was closed to avoid errors... can't check for the suspended state because of apple's crappy interrupted implementation
            {
                // Can only resume after a media playback (input) event has occurred
                if (hasMediaPlaybackEventOccurred) {
                    var p = context.resume();
                    if (p)
                        p.then(noop, noop).catch(noop);
                }
            }
        }
        else {
            // Want to be suspended, so try suspending
            if (context.state === "running") {
                var p = context.suspend();
                if (p)
                    p.then(noop, noop).catch(noop);
            }
        }
    }
    /**
     * Handles context statechange events.
     * @param evt The event.
     */
    function context_statechange(evt) {
        // Check if the event was already handled since we're listening for it both ways
        if (!evt || !evt.unmute_handled) {
            // Mark handled
            evt.unmute_handled = true;
            // The context may have auto changed to some undesired state, so immediately check again if we want to change it
            updateContextState();
        }
    }
    addEventListeners(context, ["statechange"], context_statechange, true, true); // NOTE: IIRC some devices don't support the onstatechange event callback, so handle it both ways
    if (!context.onstatechange)
        context.onstatechange = context_statechange; // NOTE: IIRC older androids don't support the statechange event via addeventlistener, so handle it both ways
    //#endregion
    //#region HTML Audio Channel State
    /** The html audio element that forces web audio playback onto the media channel instead of the ringer channel. */
    var channelTag = null;
    /**
     * A utility function for decompressing the base64 silence string. A poor-mans implementation of huffman decoding.
     * @param count The number of times the string is repeated in the string segment.
     * @param repeatStr The string to repeat.
     * @returns The
     */
    function huffman(count, repeatStr) { var e = repeatStr; for (; count > 1; count--)
        e += repeatStr; return e; }
    /**
     * A very short bit of silence to be played with <audio>, which forces AudioContext onto the ringer channel.
     * NOTE: The silence MP3 must be high quality, when web audio sounds are played in parallel the web audio sound is mixed to match the bitrate of the html sound.
     * This file is 0.01 seconds of silence VBR220-260 Joint Stereo 859B
     * The str below is a "compressed" version using poor mans huffman encoding, saves about 0.5kb
     */
    var silence = "data:audio/mpeg;base64,//uQx" + huffman(23, "A") + "WGluZwAAAA8AAAACAAACcQCA" + huffman(16, "gICA") + huffman(66, "/") + "8AAABhTEFNRTMuMTAwA8MAAAAAAAAAABQgJAUHQQAB9AAAAnGMHkkI" + huffman(320, "A") + "//sQxAADgnABGiAAQBCqgCRMAAgEAH" + huffman(15, "/") + "7+n/9FTuQsQH//////2NG0jWUGlio5gLQTOtIoeR2WX////X4s9Atb/JRVCbBUpeRUq" + huffman(18, "/") + "9RUi0f2jn/+xDECgPCjAEQAABN4AAANIAAAAQVTEFNRTMuMTAw" + huffman(97, "V") + "Q==";
    /**
     * Updates the html audio channel control.
     * @param isMediaPlaybackEvent Indicates if being called from within a media playback event handler.
     */
    function updateChannelState(isMediaPlaybackEvent) {
        // Totally unnecessary outside of iOS
        if (isIOS) {
            if (allowPlayback) {
                // We want to be playing back on the media channel, but can only do so from an allowed input event
                if (isMediaPlaybackEvent) {
                    // Create a new channel tag if necessary
                    if (!channelTag) {
                        var tmp = document.createElement("div");
                        tmp.innerHTML = "<audio x-webkit-airplay='deny'></audio>"; // Airplay like controls on other devices, prevents casting of the tag, doesn't work on modern iOS
                        channelTag = tmp.children.item(0);
                        channelTag.controls = false;
                        channelTag.disableRemotePlayback = true; // Airplay like controls on other devices, prevents casting of the tag, doesn't work on modern iOS
                        channelTag.preload = "auto";
                        channelTag.src = silence;
                        channelTag.loop = true;
                        channelTag.load();
                    }
                    // Play the channel tag
                    if (channelTag.paused) {
                        var p = channelTag.play();
                        if (p)
                            p.then(noop, destroyChannelTag).catch(destroyChannelTag); // If playback fails the tag is pretty much trash and needs to be recreated on next media playback event
                    }
                }
            }
            else {
                // We don't want to be allowing playback at all at the moment, so destroy the channel tag to halt playback and hide those silly iOS media controls
                destroyChannelTag();
            }
        }
    }
    /**
     * Complete unloads / destroys the channel tag.
     */
    function destroyChannelTag() {
        if (channelTag) {
            // Change src to nothing and trigger a load, this is required to actually hide / clear the iOS playback controls
            channelTag.src = "about:blank";
            channelTag.load();
            channelTag = null;
        }
    }
    //#endregion
    //#region Input
    /** The event types that can trigger media playback. */
    var mediaPlaybackEvents = ["click", "contextmenu", "auxclick", "dblclick", "mousedown", "mouseup", "touchend", "keydown", "keyup"];
    /** Tracks if a media playback event has occurred */
    var hasMediaPlaybackEventOccurred = false;
    /**
     * Handles events that can begin media playback.
     */
    function win_mediaPlaybackEvent() {
        hasMediaPlaybackEventOccurred = true;
        // This is an opportunity to resume the html audio channel control
        updateChannelState(true);
        // This is an opportunity to resume the context if paused
        updateContextState();
    }
    addEventListeners(window, mediaPlaybackEvents, win_mediaPlaybackEvent, true, true);
    //#endregion
    return {
        /**
         * Disposes unmute, relinquishing all control of media playback.
         */
        dispose: function () {
            // Stop / clean up the channel tag
            destroyChannelTag();
            // Remove all listeners
            if (pageVisibilityAPI)
                removeEventListeners(document, [pageVisibilityAPI.visibilitychange], doc_visChange, true, true);
            if (isIOS)
                removeEventListeners(window, ["focus", "blur"], win_focusChange, true, true);
            removeEventListeners(window, mediaPlaybackEvents, win_mediaPlaybackEvent, true, true);
            removeEventListeners(context, ["statechange"], context_statechange, true, true);
            if (context.onstatechange === context_statechange)
                context.onstatechange = null;
        }
    };
}


/***/ },

/***/ "./wp-content/plugins/speaker/source/js/includes/modules/_share.js"
/*!*************************************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/includes/modules/_share.js ***!
  \*************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   openShareWindow: () => (/* binding */ openShareWindow)
/* harmony export */ });
/**
 * Get content for share window
 * @param id
 * @returns {{image: (*|string), width: number, text: string, title: string, url: string, height: number}|{image: string, width: number, text: string, title: *, url: string, height: number}}
 */
function getContent( id ) {

    const postID = id.replace( 'speaker-player-', '' );
    const speakerPlayer = document.querySelector( `.mdp-speaker-player[data-id="${ postID }"]` )
    if ( ! speakerPlayer ) {

        return {
            title: document.title,
            text: '',
            image: '',
            url: location.href,
            width: 640,
            height: 480,
        };

    }

    let title = window.mdpSpeaker.share.shareTitle ?? '%s';

    return {
        title: title.replace( '%s', speakerPlayer.getAttribute( 'data-title' ) ?? document.title ),
        text: '',
        image: speakerPlayer.getAttribute( 'data-thumbnail' ) ?? '',
        url: `${ location.href }#speaker-player-${ id }`,
        width: 640,
        height: 480,
    };

}

/**
 * Get network link
 * @param networkName
 * @param id
 * @returns {*|string}
 */
function getNetworkLink( networkName, id ) {

    const content = getContent( id );

    const linkTemplates = {
        twitter: `https://twitter.com/intent/tweet?text=${content.title}\x20${content.url}`,
        facebook: `https://www.facebook.com/sharer.php?u=${content.url}`,
        pinterest: `https://www.pinterest.com/pin/create/button/?url=${content.url}&media=${content.image}`,
        linkedin: `https://www.linkedin.com/shareArticle?mini=true&url=${content.url}&title=${content.title}&summary=${content.text}&source=${content.url}`,
        tumblr: `https://tumblr.com/share/link?url=${content.url}`,
        google: `https://plus.google.com/share?url=${content.url}`,
        digg: `https://digg.com/submit?url=${content.url}`,
        reddit: `https://reddit.com/submit?url=${content.url}&title=${content.title}`,
        stumbleupon: `https://www.stumbleupon.com/submit?url=${content.url}`,
        pocket: `https://getpocket.com/edit?url=${content.url}`,
        whatsapp: `https://api.whatsapp.com/send?text=*${content.title}*%0A${content.text}%0A${content.url}`,
        xing: `https://www.xing.com/app/user?op=share&url=${content.url}`,
        print: `javascript:print()`,
        email: `mailto:?subject=${content.title}&body=${content.text}\n${content.url}`,
        telegram: `https://telegram.me/share/url?url=${content.url}&text=${content.text}`,
    }

    return linkTemplates[ networkName ] ?? '';

}

/**
 * Open share window
 * @param networkName
 * @param id
 */
function openShareWindow( networkName, id ) {

    const content = getContent( id );
    const shareWindowLeft = ( screen.width / 2 ) - ( content.width / 2 );
    const shareWindowTop = ( screen.height / 2 ) - ( content.height / 2 );
    const link = getNetworkLink( networkName, id );
    const isPlainLink = /^https?:\/\//.test( link );
    const windowName = isPlainLink ? '' : '_self';
    let shareWindowParams = 'toolbar=0,status=0,width=' + content.width + ',height=' + content.height + ',top=' + shareWindowTop + ',left=' + shareWindowLeft;

    open( link, windowName, shareWindowParams );

}


/***/ },

/***/ "./wp-content/plugins/speaker/source/js/includes/players/mediaelement/_init.js"
/*!*************************************************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/includes/players/mediaelement/_init.js ***!
  \*************************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   initPlayers: () => (/* binding */ initPlayers)
/* harmony export */ });
/* harmony import */ var _ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_ui */ "./wp-content/plugins/speaker/source/js/includes/players/mediaelement/_ui.js");
/* harmony import */ var _analytics_frontend__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../analytics/_frontend */ "./wp-content/plugins/speaker/source/js/includes/analytics/_frontend.js");
/* harmony import */ var _tools_unmuteContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../tools/unmuteContext */ "./wp-content/plugins/speaker/source/js/tools/unmuteContext.js");
// noinspection JSUnresolvedReference,DuplicatedCode





const { controls } = window.mdpSpeaker;

/**
 * Init MediaElement players
 */
function initPlayers() {

    const wrappers = document.querySelectorAll( '.speaker-mediaelement' );

    /**
     * UnMutes the audio context on iOS devices if it was muted by the physical mute switch
     */
    const playerSettings = window.mdpSpeaker.settings;
    const { iOSUnmute } = playerSettings;
    if ( iOSUnmute && iOSUnmute === 'true' ) {
        (0,_tools_unmuteContext__WEBPACK_IMPORTED_MODULE_2__.unmuteContext)();
    }

    wrappers.forEach( ( $wrap ) => {

        const player = $wrap.querySelector( '.mdp-speaker-player' );
        if ( player ) {
            initSinglePlayer( player );
        }

    } );
}

/**
 * Init single MediaElement player
 * @param player
 */
function initSinglePlayer( player ) {

    const src = player.getAttribute( 'data-src' ) ?? '';
    if ( ! src ) { return; }

    // Remove existing player for re-init
    player.innerHTML = '';

    // Creat new audio tag
    const audioTag = document.createElement( 'audio' );
    audioTag.setAttribute( 'src', src );
    player.appendChild( audioTag );

    // Init MediaElement player
    const mePlayer = new MediaElementPlayer(
        audioTag,
        {
            features: playerFeatures(),
            defaultAudioHeight: 54,
            defaultAudioWidth: '100%',
            enableAutosize: true,
            timeFormat: 'ss',
            isVideo: false,
            success: successCallback,
            error: errorCallback
        }
    );

}

/**
 * Player features
 * @returns {string[]}
 */
function playerFeatures() {

    let features = [ 'playpause' ];

    if ( JSON.parse( controls.elapsed ) ) {
        features.push( 'current' );
    }

    features.push( 'progress' );

    if ( JSON.parse( controls.duration ) ) {
        features.push( 'duration' );
    }

    if ( JSON.parse( controls.mute ) || JSON.parse( controls.volume ) ) {
        features.push( 'volume' );
    }

    return features;

}

/**
 * Success callback for mediaelement player
 * @param mediaElement
 * @param domObject
 * @param player
 */
function successCallback( mediaElement, domObject, player ) {

    const $playerContainer = player.container[ 0 ];

    // Init analytics
    (0,_analytics_frontend__WEBPACK_IMPORTED_MODULE_1__.audioTagAnalytics)( domObject );

    // Replace play/pause icons
    (0,_ui__WEBPACK_IMPORTED_MODULE_0__.setPlayPauseIcon)( $playerContainer );

    mediaElement.addEventListener( 'play', function () {
        (0,_ui__WEBPACK_IMPORTED_MODULE_0__.setPlayPauseIcon)( $playerContainer );
    } );

    mediaElement.addEventListener( 'pause', function () {
        (0,_ui__WEBPACK_IMPORTED_MODULE_0__.setPlayPauseIcon)( $playerContainer );
    } );

    mediaElement.addEventListener( 'ended', function () {
        (0,_ui__WEBPACK_IMPORTED_MODULE_0__.setPlayPauseIcon)( $playerContainer );
    } );

    // Replace mute icons
    (0,_ui__WEBPACK_IMPORTED_MODULE_0__.setMuteIcon)( $playerContainer, mediaElement.muted );

    mediaElement.addEventListener( 'volumechange', function () {
        (0,_ui__WEBPACK_IMPORTED_MODULE_0__.setMuteIcon)( $playerContainer, mediaElement.muted );
    } );

    // Set speed control
    (0,_ui__WEBPACK_IMPORTED_MODULE_0__.setSpeedControl)( $playerContainer, mediaElement );

    // Set repeat button
    (0,_ui__WEBPACK_IMPORTED_MODULE_0__.setRepeatIcon)( $playerContainer, mediaElement );

    // Set download button
    (0,_ui__WEBPACK_IMPORTED_MODULE_0__.setDownloadIcon)( $playerContainer );

    // Set volume control
    (0,_ui__WEBPACK_IMPORTED_MODULE_0__.setVolumeControl)( $playerContainer, mediaElement );

    // Set share controls
    (0,_ui__WEBPACK_IMPORTED_MODULE_0__.setShareControls)( $playerContainer );

}

/**
 * Error callback for mediaelement player
 * @param mediaElement
 */
function errorCallback( mediaElement ) {

    console.error( 'Impossible to create the media element player' );
    console.error( mediaElement );

}


/***/ },

/***/ "./wp-content/plugins/speaker/source/js/includes/players/mediaelement/_ui.js"
/*!***********************************************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/includes/players/mediaelement/_ui.js ***!
  \***********************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   setDownloadIcon: () => (/* binding */ setDownloadIcon),
/* harmony export */   setMuteIcon: () => (/* binding */ setMuteIcon),
/* harmony export */   setPlayPauseIcon: () => (/* binding */ setPlayPauseIcon),
/* harmony export */   setRepeatIcon: () => (/* binding */ setRepeatIcon),
/* harmony export */   setShareControls: () => (/* binding */ setShareControls),
/* harmony export */   setSpeedControl: () => (/* binding */ setSpeedControl),
/* harmony export */   setVolumeControl: () => (/* binding */ setVolumeControl)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_utils */ "./wp-content/plugins/speaker/source/js/includes/_utils.js");
/* harmony import */ var _modules_share__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../modules/_share */ "./wp-content/plugins/speaker/source/js/includes/modules/_share.js");
// noinspection JSUnresolvedReference,DuplicatedCode




const { controls, icons, settings, share, translations } = window.mdpSpeaker;

/**
 * Replace volume control
 * @param $playerContainer
 * @param mediaElement
 */
function setVolumeControl( $playerContainer, mediaElement ) {

    // Get volume from storage
    let currentVolume = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.getStorageSettings)( 'volume' );
    if ( currentVolume ) {
        mediaElement.volume = currentVolume / 100;
    }

    // Update volume in storage on change
    mediaElement.addEventListener( 'volumechange', function () {
        (0,_utils__WEBPACK_IMPORTED_MODULE_0__.updateStorage)( 'volume', mediaElement.volume * 100 );
    } );

    // Get volume control
    const $volume = $playerContainer.querySelector( '.mejs-horizontal-volume-slider' );
    if ( ! $volume ) { return; }

    // Remove volume control if disabled
    if ( ! JSON.parse( controls.volume ) ) {
        $volume.remove();
    }

}

/**
 * Set repeat button
 * @param $playerContainer
 * @param mediaElement
 */
function setRepeatIcon( $playerContainer, mediaElement ) {

    // Set loop attribute
    mediaElement.setLoop( JSON.parse( settings.loop ) );

    if ( ! JSON.parse( controls.repeat ) ) { return; }

    const parentContainer = $playerContainer.querySelector( '.mejs-controls' );

    const icon = JSON.parse( settings.loop ) ? icons.repeatOn : icons.repeatOff;
    const title = JSON.parse( settings.loop ) ? translations.repeatOn : translations.repeatOff;
    const className = JSON.parse( settings.loop ) ? 'mejs-repeat-on' : 'mejs-repeat-off';

    const $repeat = document.createElement( 'div' );
    $repeat.classList.add( 'mejs-button' );
    $repeat.classList.add( 'mejs-repeat-button' );
    $repeat.classList.add( className );
    $repeat.innerHTML = `<button type="button" title="${ title }" aria-label="${ title }" aria-pressed="false" class="mejs-repeat-button mejs-repeat">${ icon }</button>`;

    parentContainer.appendChild( $repeat );

    $repeat.addEventListener( 'click', function () {

        const $repeatButton = $repeat.querySelector( 'button' );
        if ( ! $repeatButton ) { return; }

        if ( $repeat.classList.contains( 'mejs-repeat-on' ) ) {

            $repeatButton.innerHTML = icons.repeatOff;
            $repeatButton.setAttribute( 'title', translations.repeatOff );
            $repeatButton.setAttribute( 'aria-label', translations.repeatOff );
            $repeatButton.setAttribute( 'aria-pressed', 'false' );
            $repeat.classList.remove( 'mejs-repeat-on' );
            $repeat.classList.add( 'mejs-repeat-off' );

            mediaElement.setLoop( false );

        } else {

            $repeatButton.innerHTML = icons.repeatOn;
            $repeatButton.setAttribute( 'title', translations.repeatOn );
            $repeatButton.setAttribute( 'aria-label', translations.repeatOn );
            $repeatButton.setAttribute( 'aria-pressed', 'true' );
            $repeat.classList.remove( 'mejs-repeat-off' );
            $repeat.classList.add( 'mejs-repeat-on' );

            mediaElement.setLoop( true );

        }

    } );

}

/**
 * Set download button
 * @param $playerContainer
 */
function setDownloadIcon( $playerContainer ) {

    if ( ! JSON.parse( controls.download ) ) { return; }

    // Get parent container and data container
    const $parentContainer = $playerContainer.querySelector( '.mejs-controls' );
    const $dataContainer = $playerContainer.closest( '.mdp-speaker-player' );
    if ( ! $dataContainer ) { return; }

    // Get src and title of the post
    const src = $dataContainer.getAttribute( 'data-src' ) ?? '';
    const postTitle = $dataContainer.getAttribute( 'data-title' ) ?? '';

    const $repeat = document.createElement( 'div' );
    $repeat.classList.add( 'mejs-button' );
    $repeat.classList.add( 'mejs-download-button' );
    $repeat.innerHTML = `<a href="${ src }" download title="${ translations.download }: ${ postTitle }" aria-label="${ translations.download }: ${ postTitle }">${ icons.download }</a>`;

    $parentContainer.appendChild( $repeat );

}

function setSpeedControl( $playerContainer, mediaElement ) {

    if ( ! JSON.parse( controls.speed ) ) { return; }

    // Set initial speed
    let currentSpeed = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.getStorageSettings)( 'speed' );
    if ( ! currentSpeed ) {
        currentSpeed = 1;
    }
    mediaElement.playbackRate = currentSpeed;

    // Get parent container and data container
    const $parentContainer = $playerContainer.querySelector( '.mejs-controls' );
    const $dataContainer = $playerContainer.closest( '.mdp-speaker-player' );
    if ( ! $dataContainer ) { return; }

    const speeds = $dataContainer.getAttribute( 'data-speeds' ).split( ',' );
    if ( ! speeds ) { return; }

    let speedOptions = '';
    speeds.forEach( speed => {
        let isSelected = speed === currentSpeed ? 'selected' : '';
        speedOptions += `<option value="${ speed }" ${isSelected}>${ speed }</option>`;
    } );

    const speedFieldset = document.createElement( 'fieldset' );
    speedFieldset.classList.add( 'mdp-speaker-mediaelement-speeds' );
    speedFieldset.innerHTML = `<span class="mdp-speaker-mediaelement-speed-icon">${ icons.speed }</span>
        <span class="mdp-speaker-mediaelement-speed-value">x${ currentSpeed }</span>
        <select class="mdp-speaker-mediaelement-speed">
            ${ speedOptions }
        </select>`;

    $parentContainer.appendChild( speedFieldset );

    const $speedSelect = $parentContainer.querySelector( '.mdp-speaker-mediaelement-speed' );
    const $speedValue = $parentContainer.querySelector( '.mdp-speaker-mediaelement-speed-value' );
    if ( ! $speedSelect || ! $speedValue ) { return; }

    $speedSelect.addEventListener( 'change', function () {
        const speed = this.value;
        mediaElement.playbackRate = speed;
        $speedValue.innerHTML = `x${ speed }`;
        (0,_utils__WEBPACK_IMPORTED_MODULE_0__.updateStorage)( 'speed', speed );
    } );

}

function setShareControls( $playerContainer ) {

    if ( ! JSON.parse( controls.share ) ) { return; }

    switch ( share.type ) {

        case 'list':
            toolBarShareList( $playerContainer );
            break;

        case 'icons':
            toolBarShareIcons( $playerContainer );
            break;

        default:
            break;

    }

}

function toolBarShareList( $playerContainer ) {

    const $dataContainer = $playerContainer.closest( '.mdp-speaker-player' );
    if ( ! $dataContainer ) { return; }

    const socials = $dataContainer.getAttribute( 'data-share' ).split( ',' );

    let speedOptions = `<option value=""></option>`;
    socials.forEach( speed => {
        speedOptions += `<option value="${ speed }">${ speed }</option>`;
    } );

    const shareSelect = document.createElement( 'fieldset' );
    shareSelect.classList.add( 'mdp-speaker-mediaelement-share' );
    shareSelect.innerHTML = `<span class="mdp-speaker-mediaelement-share-icon">${ icons.share }</span>
        <select class="mdp-speaker-mediaelement-share-socials">
            ${ speedOptions }
        </select>`;

    const $parentContainer = $playerContainer.querySelector( '.mejs-controls' );
    if ( ! $parentContainer ) { return; }
    $parentContainer.appendChild( shareSelect );

    const $shareSelect = $parentContainer.querySelector( '.mdp-speaker-mediaelement-share-socials' );
    if ( ! $shareSelect ) { return; }
    $shareSelect.addEventListener( 'change', function () {

        const social = this.value;
        if ( ! social ) { return; }

        (0,_modules_share__WEBPACK_IMPORTED_MODULE_1__.openShareWindow)( social, `speaker-player-${ $dataContainer.getAttribute( 'data-id' )  }` );

    } );

}

/**
 * Open share window
 * @param $playerContainer
 * @returns {string}
 */
function toolBarShareIcons( $playerContainer ) {

    const $dataContainer = $playerContainer.closest( '.mdp-speaker-player' );
    if ( ! $dataContainer ) { return ''; }

    const $parentContainer = $playerContainer.querySelector( '.mejs-controls' );
    const socials = $dataContainer.getAttribute( 'data-share' ).split( ',' );

    socials.forEach( social => {

        // Get SVG from async request
        const x = new XMLHttpRequest();
        x.open( 'GET', `${ share.iconsUrl }speaker/${social}.svg`, true );
        x.onload = () => {

            const socialButton = document.createElement( `button` );
            socialButton.classList.add( 'mejs-button' );
            socialButton.classList.add( 'mdp-speaker-mediaelement-social' );
            socialButton.setAttribute( 'title', social );
            socialButton.innerHTML = x.responseText;
            $parentContainer.appendChild( socialButton );

            // Listen for click
            socialButton.addEventListener( 'click', () => {

                (0,_modules_share__WEBPACK_IMPORTED_MODULE_1__.openShareWindow)( social, `speaker-player-${ $dataContainer.getAttribute( 'data-id' ) }` );

            }, false );

        }
        x.send();

    } );

    return '';

}

/**
 * Replace mute icons
 * @param $playerContainer
 * @param muted
 */
function setMuteIcon( $playerContainer, muted ) {

    const $mute = $playerContainer.querySelector( '.mejs-volume-button' );
    if( ! $mute ) { return; }

    if ( ! JSON.parse( controls.mute ) ) {
        $mute.remove();
        return;
    }

    const $button = $mute.querySelector( 'button' );
    if ( ! $button ) { return; }

    $button.innerHTML = muted ? icons.muteOn : icons.muteOff;

}

/**
 * Replace play/pause icons
 * @param $playerContainer
 */
function setPlayPauseIcon( $playerContainer ) {

    const $playPause = $playerContainer.querySelector( '.mejs-playpause-button' );
    const $button = $playPause.querySelector( 'button' );
    if ( ! $button ) { return; }

    // Set play icon
    if ( $playPause.classList.contains( 'mejs-play' ) ) {
        $button.innerHTML = icons.play;
    }

    // Set pause icon
    if ( $playPause.classList.contains( 'mejs-pause' ) ) {
        $button.innerHTML = icons.pause;
    }

}


/***/ },

/***/ "./wp-content/plugins/speaker/source/js/tools/unmuteContext.js"
/*!*********************************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/tools/unmuteContext.js ***!
  \*********************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   unmuteContext: () => (/* binding */ unmuteContext)
/* harmony export */ });
/* harmony import */ var _includes_libs_iOSunmute__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../includes/libs/iOSunmute */ "./wp-content/plugins/speaker/source/js/includes/libs/iOSunmute.js");


/**
 * UnMutes the audio context on iOS devices if it was muted by the physical mute switch
 *
 * @returns {void}
 */
function unmuteContext() {

    // Create an audio context instance if WebAudio is supported
    let context = (window.AudioContext || window.webkitAudioContext) ?
        new (window.AudioContext || window.webkitAudioContext)() : null;

    if ( context ) {

        try {
            (0,_includes_libs_iOSunmute__WEBPACK_IMPORTED_MODULE_0__.unmute)(context);
        } catch (e) {
            console.log( 'Unmute error', e );
        }

    }

}


/***/ }

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Check if module exists (development only)
/******/ 		if (__webpack_modules__[moduleId] === undefined) {
/******/ 			var e = new Error("Cannot find module '" + moduleId + "'");
/******/ 			e.code = 'MODULE_NOT_FOUND';
/******/ 			throw e;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!*****************************************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/speaker-player-mediaelement.js ***!
  \*****************************************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _includes_players_mediaelement_init__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./includes/players/mediaelement/_init */ "./wp-content/plugins/speaker/source/js/includes/players/mediaelement/_init.js");
/**
 * Speaker
 * Create an audio version of your posts, with a selection of more than 340 voices across more than 52 languages and variants.
 * Exclusively on https://1.envato.market/speaker
 *
 * @encoding        UTF-8
 * @version         4.0.0
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/



( function () {

    document.readyState === 'loading' ?
        document.addEventListener( 'DOMContentLoaded', _includes_players_mediaelement_init__WEBPACK_IMPORTED_MODULE_0__.initPlayers ) :
        (0,_includes_players_mediaelement_init__WEBPACK_IMPORTED_MODULE_0__.initPlayers)();

} )();

})();

/******/ })()
;