/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./wp-content/plugins/speaker/source/js/includes/_utils.js"
/*!*****************************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/includes/_utils.js ***!
  \*****************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStorageSettings: () => (/* binding */ getStorageSettings),
/* harmony export */   setWPMediaElementSpeed: () => (/* binding */ setWPMediaElementSpeed),
/* harmony export */   updateStorage: () => (/* binding */ updateStorage)
/* harmony export */ });
// noinspection JSUnresolvedReference

/**
 * Get settings from storage by key
 * @param key
 * @returns {boolean|*}
 */
function getStorageSettings( key ) {

    let storedSettings = window.localStorage.getItem( 'mdpSpeaker' );

    if ( storedSettings ) {

        let localStorage = JSON.parse( storedSettings );
        return localStorage[ key ] ? localStorage[ key ] : false;

    } else {

        return false;

    }

}

/**
 * Update local storage
 * @param key
 * @param value
 */
function updateStorage( key, value ) {

    const storage = window.localStorage.getItem( 'mdpSpeaker' );

    if ( storage ) {

        let localStorage = JSON.parse( storage );
        localStorage[ key ] = value;

        window.localStorage.setItem( 'mdpSpeaker', JSON.stringify( localStorage ) );

    } else {

        let localStorage = {};
        localStorage[ key ] = value;

        window.localStorage.setItem( 'mdpSpeaker', JSON.stringify( localStorage ) );

    }

}

/**
 * Set initial speed for mediaelement player by wrapper element
 * @param $playerWrapper
 * @param speed
 */
function setWPMediaElementSpeed( $playerWrapper, speed = false ) {

    // Set initial speed
    if ( ! speed ) {
        let storageSpeed = getStorageSettings( 'speed' ) ?? false;
        speed = ! storageSpeed ? 1 : storageSpeed;
    }

    // Get audio tag
    const $singleAudioTag = $playerWrapper.querySelector( 'audio' );
    if ( ! $singleAudioTag ) { return; }

    // WP Media Element Player
    if ( typeof window.MediaElementPlayer === 'function' ) {

        new MediaElementPlayer( $singleAudioTag.id ?? '' );

    }

    $singleAudioTag.playbackRate = speed;

}


/***/ },

/***/ "./wp-content/plugins/speaker/source/js/includes/analytics/_frontend.js"
/*!******************************************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/includes/analytics/_frontend.js ***!
  \******************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   audioTagAnalytics: () => (/* binding */ audioTagAnalytics),
/* harmony export */   initAnalytics: () => (/* binding */ initAnalytics)
/* harmony export */ });
const { analytics } = window.mdpSpeaker;

/**
 * Init analytics
 */
function initAnalytics() {

    if ( ! JSON.parse( analytics.enable ) ) { return; }

    const wrappers = document.querySelectorAll( '.mdp-speaker-wrapper' );

    wrappers.forEach( $wrapper => {

        const $dataWrapper = $wrapper.querySelector( '.mdp-speaker-player' );

        $dataWrapper.addEventListener(
            'speaker-analytics-init',
            (e) => analyticsSend( 'init', e.detail ),
            false
        );

        $dataWrapper.addEventListener(
            'speaker-analytics-play',
            (e) => analyticsSend( 'play', e.detail ),
            false
        );

        $dataWrapper.addEventListener(
            'speaker-analytics-pause',
            (e) => analyticsSend( 'pause', e.detail ),
            false
        );

        $dataWrapper.addEventListener(
            'speaker-analytics-time',
            (e) => analyticsSend( 'time', e.detail ),
            false
        );

        $dataWrapper.addEventListener(
            'speaker-analytics-end',
            (e) => analyticsSend( 'end', e.detail ),
            false
        );


    } );

}

/**
 * Init analytics for audio tag based on vanilla JS events
 * @param $audio
 */
function audioTagAnalytics( $audio ) {

    if ( ! $audio ) { return; }
    if ( ! JSON.parse( analytics.enable ) ) { return; }

    const $dataHolder = $audio.closest( '.mdp-speaker-player' );
    if ( ! $dataHolder ) { return; }

    // Skip if wavesurfer and mediaelement player because it has its own analytics
    let playerType = $dataHolder.getAttribute( 'data-type' );
    if ( playerType === 'speaker-wavesurfer' ) {
        return;
    }

    const id = $dataHolder.getAttribute( 'data-id' );

    // Init for browser default player because init event is not fired for it
    if ( playerType === 'speaker-browser-default' ) {

        // Init for browser default player
        const analyticsInit = new CustomEvent( 'speaker-analytics-init', { detail: { id: id } } );
        $dataHolder.dispatchEvent( analyticsInit );

    }

    // Init for other player types
    $audio.addEventListener( 'loadstart', function() {

        const analyticsInit = new CustomEvent( 'speaker-analytics-init', { detail: { id: id } } );
        $dataHolder.dispatchEvent( analyticsInit );

    } );

    // Play
    $audio.addEventListener( 'play', function() {

        const analyticsPlay = new CustomEvent( 'speaker-analytics-play', { detail: { id: id } } );
        $dataHolder.dispatchEvent( analyticsPlay );

    } );

    // Pause
    $audio.addEventListener( 'pause', function() {

        const analyticsPause = new CustomEvent( 'speaker-analytics-pause', { detail: { id: id } } );
        $dataHolder.dispatchEvent( analyticsPause );

    }  );

    // End
    $audio.addEventListener( 'ended', function() {

        const analyticsEnd = new CustomEvent( 'speaker-analytics-end', { detail: { id: id } } );
        $dataHolder.dispatchEvent( analyticsEnd );

    } );

    // Time changed
    let prevTime = 0;
    $audio.addEventListener( 'timeupdate', function() {

        let nowTime = Math.floor( $audio.currentTime );

        if ( nowTime - prevTime >= parseInt( analytics.precision ) ) {

            const analyticsTime = new CustomEvent( 'speaker-analytics-time', {
                detail: {
                    id: id,
                    time: nowTime
                }
            } );

            $dataHolder.dispatchEvent( analyticsTime );

            prevTime = nowTime;

        }

    } );

}

/**
 * Send analytics
 * @param event
 * @param data
 */
function analyticsSend( event, data ) {

    const { ajaxUrl, nonce } = window.mdpSpeaker.analytics;

    const request = new XMLHttpRequest();
    request.open( 'POST', ajaxUrl, true );
    request.setRequestHeader( 'Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8' );

    let request_data = `action=speaker_analytics&nonce=${ nonce }&event=${ event }&id=${ data.id }`;
    if ( event === 'time' ) {
        request_data += `&time=${ analytics.precision }`;
    }

    request.send( request_data );

}


/***/ },

/***/ "./wp-content/plugins/speaker/source/js/includes/modules/_share.js"
/*!*************************************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/includes/modules/_share.js ***!
  \*************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   openShareWindow: () => (/* binding */ openShareWindow)
/* harmony export */ });
/**
 * Get content for share window
 * @param id
 * @returns {{image: (*|string), width: number, text: string, title: string, url: string, height: number}|{image: string, width: number, text: string, title: *, url: string, height: number}}
 */
function getContent( id ) {

    const postID = id.replace( 'speaker-player-', '' );
    const speakerPlayer = document.querySelector( `.mdp-speaker-player[data-id="${ postID }"]` )
    if ( ! speakerPlayer ) {

        return {
            title: document.title,
            text: '',
            image: '',
            url: location.href,
            width: 640,
            height: 480,
        };

    }

    let title = window.mdpSpeaker.share.shareTitle ?? '%s';

    return {
        title: title.replace( '%s', speakerPlayer.getAttribute( 'data-title' ) ?? document.title ),
        text: '',
        image: speakerPlayer.getAttribute( 'data-thumbnail' ) ?? '',
        url: `${ location.href }#speaker-player-${ id }`,
        width: 640,
        height: 480,
    };

}

/**
 * Get network link
 * @param networkName
 * @param id
 * @returns {*|string}
 */
function getNetworkLink( networkName, id ) {

    const content = getContent( id );

    const linkTemplates = {
        twitter: `https://twitter.com/intent/tweet?text=${content.title}\x20${content.url}`,
        facebook: `https://www.facebook.com/sharer.php?u=${content.url}`,
        pinterest: `https://www.pinterest.com/pin/create/button/?url=${content.url}&media=${content.image}`,
        linkedin: `https://www.linkedin.com/shareArticle?mini=true&url=${content.url}&title=${content.title}&summary=${content.text}&source=${content.url}`,
        tumblr: `https://tumblr.com/share/link?url=${content.url}`,
        google: `https://plus.google.com/share?url=${content.url}`,
        digg: `https://digg.com/submit?url=${content.url}`,
        reddit: `https://reddit.com/submit?url=${content.url}&title=${content.title}`,
        stumbleupon: `https://www.stumbleupon.com/submit?url=${content.url}`,
        pocket: `https://getpocket.com/edit?url=${content.url}`,
        whatsapp: `https://api.whatsapp.com/send?text=*${content.title}*%0A${content.text}%0A${content.url}`,
        xing: `https://www.xing.com/app/user?op=share&url=${content.url}`,
        print: `javascript:print()`,
        email: `mailto:?subject=${content.title}&body=${content.text}\n${content.url}`,
        telegram: `https://telegram.me/share/url?url=${content.url}&text=${content.text}`,
    }

    return linkTemplates[ networkName ] ?? '';

}

/**
 * Open share window
 * @param networkName
 * @param id
 */
function openShareWindow( networkName, id ) {

    const content = getContent( id );
    const shareWindowLeft = ( screen.width / 2 ) - ( content.width / 2 );
    const shareWindowTop = ( screen.height / 2 ) - ( content.height / 2 );
    const link = getNetworkLink( networkName, id );
    const isPlainLink = /^https?:\/\//.test( link );
    const windowName = isPlainLink ? '' : '_self';
    let shareWindowParams = 'toolbar=0,status=0,width=' + content.width + ',height=' + content.height + ',top=' + shareWindowTop + ',left=' + shareWindowLeft;

    open( link, windowName, shareWindowParams );

}


/***/ },

/***/ "./wp-content/plugins/speaker/source/js/includes/modules/_speed.js"
/*!*************************************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/includes/modules/_speed.js ***!
  \*************************************************************************/
(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   speedBar: () => (/* binding */ speedBar)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../_utils */ "./wp-content/plugins/speaker/source/js/includes/_utils.js");


function speedBar( $speakerWrapper ) {

    const $speedBar = $speakerWrapper.querySelector( '.mdp-speaker--speed' );
    if ( ! $speedBar ){ return; }

    // Apply saved speed
    const savedSpeed = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.getStorageSettings)( 'speed' );
    if ( savedSpeed ) {

        const $speedButtonSaved = document.querySelector( `button.mdp-speaker--speed-button[data-speed='${ savedSpeed }']` );
        if ( $speedButtonSaved ) {
            speedClick( { target: $speedButtonSaved } );
        }

    }

    /** Listen for clicks */
    $speedBar.addEventListener( 'click', speedClick );

}


/**
 * Speed button click handler
 * @param e
 */
function speedClick( e ) {

    const $speedButton = e.target;
    const $speakerWrapper = $speedButton.closest( '.mdp-speaker-wrapper' );

    const newSpeed = $speedButton.getAttribute( 'data-speed' );
    setSpeed( newSpeed, $speakerWrapper );
    setSpeedButtonActive( newSpeed );

}

/**
 * Set speed for Speaker player
 * @param speed
 * @param $speakerWrapper
 */
function setSpeed( speed, $speakerWrapper ) {

    const singleAudioTag = $speakerWrapper.querySelector( 'audio' );

    // WP Player
    if ( singleAudioTag && typeof window.MediaElementPlayer === 'function' ) { new MediaElementPlayer( singleAudioTag.id ); }

    // Dispatch event
    document.querySelectorAll( '.mdp-speaker-player' ).forEach( $dataContainer => {

        // Speed Change Event
        const event = new CustomEvent( 'speakerSpeedChange', { detail: { speed: speed } } );
        $dataContainer.dispatchEvent( event );

    } );

    // Audio Tag
    if ( singleAudioTag ) {
        singleAudioTag.playbackRate = speed;
    }

    (0,_utils__WEBPACK_IMPORTED_MODULE_0__.updateStorage)( 'speed', speed );

}

/**
 * Set active-speed class for active button
 */
function setSpeedButtonActive( newSpeed ) {

    // Set active speed for all speed bars
    document.querySelectorAll( '.mdp-speaker--speed' ).forEach( $speedBar => {

        // Remove active speed status
        $speedBar.querySelectorAll( '.active-speed' ).forEach( element => element.classList.remove( 'active-speed' ) );

        // Set active speed status
        $speedBar.querySelectorAll( `button.mdp-speaker--speed-button[data-speed='${ newSpeed }']` ).forEach( $speedButton => {
            $speedButton.classList.add( 'active-speed' );
        } );

    } );

}


/***/ }

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Check if module exists (development only)
/******/ 		if (__webpack_modules__[moduleId] === undefined) {
/******/ 			var e = new Error("Cannot find module '" + moduleId + "'");
/******/ 			e.code = 'MODULE_NOT_FOUND';
/******/ 			throw e;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	(() => {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = (exports) => {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};
// This entry needs to be wrapped in an IIFE because it needs to be isolated against other modules in the chunk.
(() => {
/*!*********************************************************!*\
  !*** ./wp-content/plugins/speaker/source/js/speaker.js ***!
  \*********************************************************/
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _includes_modules_share__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./includes/modules/_share */ "./wp-content/plugins/speaker/source/js/includes/modules/_share.js");
/* harmony import */ var _includes_analytics_frontend__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./includes/analytics/_frontend */ "./wp-content/plugins/speaker/source/js/includes/analytics/_frontend.js");
/* harmony import */ var _includes_modules_speed__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./includes/modules/_speed */ "./wp-content/plugins/speaker/source/js/includes/modules/_speed.js");
/**
 * Speaker
 * Create an audio version of your posts, with a selection of more than 340 voices across more than 52 languages and variants.
 * Exclusively on https://1.envato.market/speaker
 *
 * @encoding        UTF-8
 * @version         4.0.0
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/





( function () {

    document.readyState === 'loading' ?
        document.addEventListener( 'DOMContentLoaded', initSpeaker ) :
        initSpeaker();

} )();

/**
 * Init Speaker functions for all player types
 */
function initSpeaker() {

    (0,_includes_analytics_frontend__WEBPACK_IMPORTED_MODULE_1__.initAnalytics)();

    document.querySelectorAll( '.mdp-speaker-wrapper' ).forEach( ( $speakerWrapper ) => {

        // Single audio tag
        const singleAudioTag = $speakerWrapper.querySelector( 'audio' );
        if ( singleAudioTag ) {

            // Disallow downloading interface
            if ( singleAudioTag.parentElement.getAttribute( 'data-download' ) !== '1' ) {
                singleAudioTag.controlsList = 'nodownload';
            }

            // Backend duration
            backendDuration( singleAudioTag );

        }

        // Speed bar
        (0,_includes_modules_speed__WEBPACK_IMPORTED_MODULE_2__.speedBar)( $speakerWrapper );

        // Share bar
        shareBar( $speakerWrapper );

        // Analytics
        (0,_includes_analytics_frontend__WEBPACK_IMPORTED_MODULE_1__.audioTagAnalytics)( $speakerWrapper.querySelector( 'audio' ) );

    } );

}

/**
 * Backend duration
 * @param singleAudioTag
 */
function backendDuration( singleAudioTag ) {

    const $dataHolder = singleAudioTag.closest( '.mdp-speaker-box > div' );
    if ( $dataHolder.getAttribute( 'data-length-formatted' ) ) {

        const lengthFormatted = $dataHolder.getAttribute( 'data-length-formatted' );

        setTimeout( () => {

            if ( $dataHolder.querySelector( '.mejs-duration' ) ) {
                $dataHolder.querySelector( '.mejs-duration' ).innerHTML = lengthFormatted;
            }

        }, 1 );

    }

}

/**
 * Share bar
 * @param $speakerWrapper
 */
function shareBar( $speakerWrapper ) {

    const shareBoxes = $speakerWrapper.querySelectorAll( '.mdp-speaker-share-box' );
    const $dataContainer = $speakerWrapper.querySelector( '.mdp-speaker-player' );
    if ( shareBoxes === null ) { return; }

    shareBoxes.forEach( $shareBox => {

        $shareBox.addEventListener( 'click', function( e ) {

            let social = e.target.getAttribute( 'data-social' );
            if ( social === null ) {
                social = e.target.closest( '[data-social]' ).getAttribute( 'data-social' );
            }

            if ( social === null ) { return; }
            (0,_includes_modules_share__WEBPACK_IMPORTED_MODULE_0__.openShareWindow)( social, `speaker-player-${ $dataContainer.getAttribute( 'data-id' ) }` );

        } );

    } );

}

})();

/******/ })()
;