<?php
/**
 * Speaker
 * Create an audio version of your posts, with a selection of more than 340 voices across more than 52 languages and variants.
 * Exclusively on https://1.envato.market/speaker
 *
 * @encoding        UTF-8
 * @version         4.1.10
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Alexander Khmelnitskiy (info@alexander.khmelnitskiy.ua), Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

namespace Merkulove\Speaker;

use Merkulove\Speaker\Unity\Plugin as Plugin;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * @package Merkulove\Speaker
 */
final class AdminStyles {

	/**
	 * The one true AdminStyles.
	 * @var AdminStyles
	 **/
	private static $instance;

	/**
	 * Sets up a new AdminStyles instance.
	 * @access public
	 **/
	private function __construct() {

		/** Add admin styles. */
		add_action( 'admin_enqueue_scripts', [ $this, 'admin_styles' ] );

	}

	/**
	 * Add CSS for admin area.
	 * @return void
	 **/
	public function admin_styles() {

		/** Plugin Settings Page. */
		$this->settings_styles();

	}

	/**
	 * Styles for plugin setting page.
	 * @return void
	 */
	private function settings_styles() {

		// Add styles only on plugin setting page.
		$screen = get_current_screen();

		// All admin pages.
		wp_enqueue_style( 'mdp-speaker-wordpress-admin', Plugin::get_url() . 'css/wordpress-admin' . Plugin::get_suffix() . '.css', [], Plugin::get_version() );

		// WordPress dashboard.
		if ( $screen->base === 'dashboard' ) {
			wp_enqueue_style( 'mdp-speaker-dashboard', Plugin::get_url() . 'css/dashboard' . Plugin::get_suffix() . '.css', [], Plugin::get_version() );
		}

	}

	/**
	 * Main AdminStyles Instance.
	 * @return AdminStyles
	 */
	public static function get_instance(): AdminStyles {

        /** @noinspection SelfClassReferencingInspection */
        if ( ! isset( self::$instance ) && ! ( self::$instance instanceof AdminStyles ) ) {

			self::$instance = new AdminStyles;

		}

		return self::$instance;

	}

}
