<?php /** @noinspection PhpUndefinedClassInspection */
/**
 * Speaker
 * Create an audio version of your posts, with a selection of more than 340 voices across more than 52 languages and variants.
 * Exclusively on https://1.envato.market/speaker
 *
 * @encoding        UTF-8
 * @version         4.1.10
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Alexander Khmelnitskiy (info@alexander.khmelnitskiy.ua), Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

namespace Merkulove\Speaker;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
    header( 'Status: 403 Forbidden' );
    header( 'HTTP/1.1 403 Forbidden' );
    exit;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

/** @noinspection PhpUnused */
/**
 * Speaker - Custom Elementor Widget.
 **/
class speaker_elementor extends Widget_Base {

	/**
     * Return a widget name.
     *
     * @return string
     **/
    public function get_name(): string {

        return 'mdp-e-speaker';

    }

    /**
     * Return the widget title that will be displayed as the widget label.
     *
     * @return string
     **/
    public function get_title(): string {

        return 'Speaker';

    }

    /**
     * Set the widget icon.
     *
     * @return string
     */
    public function get_icon(): string {

        return 'mdp-speaker-widget-icon';

    }

    /**
     * Set the category of the widget.
     *
     * @return array with category names
     **/
    public function get_categories(): array {

        return [ 'general' ];

    }

    /**
     * Get widget keywords. Retrieve the list of keywords the widget belongs to.
     *
     * @access public
     *
     * @return array Widget keywords.
     **/
    public function get_keywords(): array {

        return [
            'Merkulove',
            'Speaker',
            esc_html__( 'Voice', 'speaker' ),
            esc_html__( 'Audio', 'speaker' ),
            esc_html__( 'Text to Speech', 'speaker' ),
            esc_html__( 'TTS', 'speaker' ),
            esc_html__( 'Audio player', 'speaker' )
        ];

    }

    /**
     * Add the widget controls.
     *
     * @since 3.0.0
     * @access protected
     *
     * @return void with category names
     **/
    protected function _register_controls() {

        $this->start_controls_section( 'section_image', ['label' => esc_html__( 'Content', 'speaker' )] );

        $note = wp_sprintf(
            /* translators: %s - link to the plugin settings */
	        esc_html__( 'To configure plugin appearance go to %s page', 'speaker' ),
	        '<a href="' . admin_url( 'admin.php?page=mdp_speaker_settings&tab=player' ) . '" target="_blank">Speaker ' . esc_html__( 'settings', 'speaker' ) . '</a>'
        );

        $this->add_control(
            'important_note',
            [
                'type'  => Controls_Manager::RAW_HTML,
                'raw'   => '<div class="elementor-panel-alert elementor-panel-alert-info">' . $note . '</div>',
            ]
        );

        $this->end_controls_section();

    }

    /**
     * Render Frontend Output. Generate the final HTML on the frontend.
     *
     * @since 3.0.0
     * @access protected
     **/
    protected function render() {

        ?><div class="mdp-e-speaker-widget"><?php echo Player::the_player( get_the_ID(), false ); ?></div><?php

    }

    /**
     * Return link for documentation
     * Used to add stuff after widget
     *
     * @access public
     *
     * @return string
     **/
    public function get_custom_help_url(): string {

        return 'https://docs.merkulov.design/tag/speaker';

    }

}
