<?php
/**
 * Speaker
 * Create an audio version of your posts, with a selection of more than 340 voices across more than 52 languages and variants.
 * Exclusively on https://1.envato.market/speaker
 *
 * @encoding        UTF-8
 * @version         4.1.10
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

namespace Merkulove\Speaker;

use Merkulove\Speaker\Unity\CheckCompatibility;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * @package Merkulove/Speaker
 */
final class Filters {

	/**
	 * @access private
	 * @var Filters
	 **/
	private static $instance;

	/**
	 * Register hooks.
	 * @return void
	 */
	private function __construct() {

		// Disable SSL verification for requests.
		add_filter( 'https_ssl_verify', '__return_false' );

		// Set status tab as default id server requirements not met.
		add_filter( 'speaker_current_tab', [ $this, 'current_tab' ] );

	}

	/**
	 * Modify default active tab slug if min requirements are not met.
	 *
	 * @param string $tab - slug of current tab
	 *
	 * @return string
	 */
	public function current_tab( string $tab ): string {

		// Don't change tab if we are tab sets by user.
		if ( isset( $_GET[ 'tab' ] ) ) { return $tab; }

		// Don't change tab if we are not on general tab.
		if ( $tab !== 'general' ) { return $tab; }

		// If the min requirements are met, show the voice tab.
		if ( ! CheckCompatibility::get_instance()->do_settings_checks( false ) ) {
			return 'status';
		}

		return $tab;

	}

	/**
	 * Main Instance.
	 *
	 * @return Filters
	 **/
	public static function get_instance(): Filters {

		if ( ! isset( self::$instance ) && ! ( self::$instance instanceof self ) ) {

			self::$instance = new self;

		}

		return self::$instance;

	}

}
