<?php
/**
 * Speaker
 * Create an audio version of your posts, with a selection of more than 340 voices across more than 52 languages and variants.
 * Exclusively on https://1.envato.market/speaker
 *
 * @encoding        UTF-8
 * @version         4.0.0
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

namespace Merkulove\Speaker;

use Merkulove\Speaker\Unity\Plugin;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * @package Merkulove\Speaker
 **/
final class TabContent {

	/**
	 * Controls for Schema tab.
	 * @return void
	 */
	public static function controls( $options ) {

		$tabs = Plugin::get_tabs();
		$fields = array();

		$fields[ 'before_audio' ] = [ // TODO: SpeechUtilities
			'type'              => 'text',
			'label'             => esc_html__( 'Before Audio', 'speaker'),
			'description'       => esc_html__( 'Add text before audio(intro).', 'speaker' ),
			'default'           => '',
			'attr'              => [
				'maxlength' => '4500'
			]
		];

		$fields[ 'after_audio' ] = [ // TODO: SpeechUtilities
			'type'              => 'text',
			'label'             => esc_html__( 'After Audio', 'speaker'),
			'description'       => esc_html__( 'Add a text after audio(outro).', 'speaker' ),
			'default'           => '',
			'attr'              => [
				'maxlength' => '4500'
			]
		];

		$fields[ 'read_title' ] = [ // TODO: SpeechUtilities
			'type'              => 'switcher',
			'label'             => esc_html__( 'Read the Title', 'speaker' ),
			'description'       => esc_html__( 'Include title in audio version.', 'speaker' ),
			'default'           => 'off',
		];

		$fields[ 'read_quotes' ] = [
			'type'              => 'switcher',
			'label'             => esc_html__( 'Read quotes', 'speaker' ),
			'description'       => esc_html__( 'Controls the reading of the blockquote tag', 'speaker' ),
			'default'           => 'on',
		];

		$fields[ 'read_figcaption' ] = [ // TODO: SpeechUtilities
			'type'              => 'switcher',
			'label'             => esc_html__( 'Read image caption', 'speaker' ),
			'description'       => esc_html__( 'Controls the reading of the image caption, inside figcaption tag', 'speaker' ),
			'default'           => 'on',
		];

		$fields[ 'read_image_alt' ] = [
			'type'              => 'switcher',
			'label'             => esc_html__( 'Read image alt', 'speaker' ),
			'description'       => esc_html__( 'Controls the reading of the image alt attribute', 'speaker' ),
			'default'           => 'off',
		];

		$fields[ 'punctuation_pause' ] = [
			'type'              => 'switcher',
			'label'             => esc_html__( 'Punctuation', 'speaker' ),
			'description'       => esc_html__( 'Controls the reading of punctuation marks', 'speaker' ),
			'default'           => 'off',
		];

		$punctuation_pause_dot = $options[ 'punctuation_pause_dot' ] ?? 500;
		$fields[ 'punctuation_pause_dot' ] = [
			'type' 			    => 'slider',
			'label' 		    => esc_html__( 'Pause after dot', 'speaker' ),
			'description' 	    => wp_sprintf(
				/* translators: %s: milliseconds */
				esc_html__( 'Pause after dot: %s milliseconds.', 'speaker' ),
				'<strong>' . esc_attr( $punctuation_pause_dot ) . '</strong>'
			),
			'default' 		    => $punctuation_pause_dot,
			'min' 			    => 0,
			'max' 			    => 3000,
			'step' 			    => 100,
		];

		$punctuation_pause_comma = $options[ 'punctuation_pause_comma' ] ?? 0;
		$fields[ 'punctuation_pause_comma' ] = [
			'type' 			    => 'slider',
			'label' 		    => esc_html__( 'Pause after comma', 'speaker' ),
			'description' 	    => wp_sprintf(
				/* translators: %s: milliseconds */
				esc_html__( 'Pause after comma: %s milliseconds.', 'speaker' ),
				'<strong>' . esc_attr( $punctuation_pause_comma ) . '</strong>'
			),
			'default' 		    => $punctuation_pause_comma,
			'min' 			    => 0,
			'max' 			    => 3000,
			'step' 			    => 100,
		];

        $markup_pause_tr = $options[ 'markup_pause_tr' ] ?? 500;
        $fields[ 'markup_pause_tr' ] = [
            'type'              => 'slider',
            'label'             => esc_html__( 'Pause after table row', 'speaker' ),
            'description'       => wp_sprintf(
                /* translators: %s: milliseconds */
                esc_html__( 'Pause after table row: %s milliseconds.', 'speaker' ),
                '<strong>' . esc_attr( $markup_pause_tr ) . '</strong>'
            ),
            'default'           => $markup_pause_tr,
            'min'               => 0,
            'max'               => 1500,
            'step'              => 100,
        ];

        $markup_pause_td = $options[ 'markup_pause_td' ] ?? 200;
        $fields[ 'markup_pause_td' ] = [
            'type'              => 'slider',
            'label'             => esc_html__( 'Pause after table cell', 'speaker' ),
            'description'       => wp_sprintf(
                /* translators: %s: milliseconds */
                esc_html__( 'Pause after table cell: %s milliseconds.', 'speaker' ),
                '<strong>' . esc_attr( $markup_pause_td ) . '</strong>'
            ),
            'default'           => $markup_pause_td,
            'min'               => 0,
            'max'               => 1500,
            'step'              => 100,
        ];

		$fields[ 'regex' ] = [
			'type'              => 'switcher',
			'label'             => esc_html__( 'Regular expression replacements', 'speaker' ),
			'description'       => esc_html__( 'With this option you can replace any group of characters when voicing by using', 'speaker' ) .
			' <a href="https://regexr.com/" target="_blank">' . esc_html__( 'Regular Expressions', 'speaker' ) .'</a>',
			'default'           => 'off',
		];

		$fields[ 'regex_pattern' ] = [
			'type'              => 'textarea',
			'label'             => esc_html__( 'Replacement pattern', 'speaker' ),
			'description'       => esc_html__( 'Enter the regular expression to be replaced and on a new line write the term or SSML tag to be replaced. You can also use the WordPress filter', 'speaker' ) . ' <code>speaker_after_content_regex_replace</code> ' . esc_html__( 'to manipulate content for voicing', 'speaker' ),
			'default'           => '',
			'attr'              => [
				'spellcheck'    => 'false',
			]
		];

		$tabs[ 'content' ][ 'fields' ] = $fields;
		Plugin::set_tabs( $tabs );

	}

}
