<?php
/**
 * Speaker
 * Create an audio version of your posts, with a selection of more than 340 voices across more than 52 languages and variants.
 * Exclusively on https://1.envato.market/speaker
 *
 * @encoding        UTF-8
 * @version         4.0.0
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

namespace Merkulove\Speaker;

use Merkulove\Speaker\Unity\Plugin;

/** Exit if accessed directly. */
if ( ! defined( 'ABSPATH' ) ) {
	header( 'Status: 403 Forbidden' );
	header( 'HTTP/1.1 403 Forbidden' );
	exit;
}

/**
 * @package Merkulove\Speaker
 **/
final class TabRSS {

	/**
	 * Controls for Schema tab.
	 * @return void
	 */
	public static function controls() {

		$tabs = Plugin::get_tabs();
		$fields = array();

		$fields[ 'podcasts_rss' ] = [
			'type'              => 'switcher',
			'label'             => esc_html__( 'Podcasts feed', 'speaker' ),
			'description'       => esc_html__( 'Create RSS feed for the Google Podcasts and Apple Podcasts. After configuring feed will be available by link', 'speaker' ) .
			' <a href="' . get_bloginfo( 'url' ) . '/?feed=speaker-podcast" target="_blank">' . get_bloginfo( 'url' ) . '/?feed=speaker-podcast</a>',
			'default'           => 'off',
		];

		$fields[ 'podcast_header' ] = [
			'type'              => 'textarea',
			'label'             => esc_html__( 'Header template', 'speaker' ),
			'description'       => esc_html__( 'The following variables are available: ', 'speaker' ) .
			'<br><strong>[site-title]</strong>' . ' — ' . esc_html__( 'Website title', 'speaker' ) .
			'<br><strong>[site-email]</strong>' . ' — ' . esc_html__( 'Website(administrator) e-mail', 'speaker' ) .
			'<br><strong>[site-tagline]</strong>' . ' — ' . esc_html__( 'Website tagline', 'speaker' ) .
			'<br><strong>[site-logo]</strong>' . ' — ' . esc_html__( 'Website logo from the theme customizer', 'speaker' ) .
			'<br><strong>[site-lang]</strong>' . ' — ' . esc_html__( 'Website main language', 'speaker' ) .
			'<br><strong>[site-url]</strong>' . ' — ' . esc_html__( 'Website URL', 'speaker' ),
			'default'           => '
<title>[site-title]</title>
<description>[site-tagline]</description>
<language>[site-lang]</language>
<link>[site-url]</link>
<copyright>&#169; 2022 [site-title]</copyright>
<itunes:owner>
    <itunes:name>[site-title]</itunes:name>
    <itunes:email>[site-email]</itunes:email>
</itunes:owner>
<itunes:author>[site-title]</itunes:author>
<itunes:image href="[site-logo]"/>
<itunes:category text="" />
<itunes:explicit>false</itunes:explicit>
<atom:link href="'. get_bloginfo( 'url' ) . '/?feed=speaker-podcast" rel="self" type="application/rss+xml" />
',
			'attr'              => [
				'spellcheck'    => 'false',
				'maxlength'     => '4500'
			]
		];

		$fields[ 'podcast_item' ] = [
			'type'              => 'textarea',
			'label'             => esc_html__( 'Item template', 'speaker' ),
			'description'       => esc_html__( 'The following variables are available: ', 'speaker' ) .
			'<br><strong>[item_id]</strong>' . ' — ' . esc_html__( 'Post ID', 'speaker' ) .
			'<br><strong>[item_title]</strong>' . ' — ' . esc_html__( 'Post title', 'speaker' ) .
			'<br><strong>[item_excerpt]</strong>' . ' — ' . esc_html__( 'Post excerpt', 'speaker' ) .
			'<br><strong>[item_date]</strong>' . ' — ' . esc_html__( 'Publication date of the episode, in RFC 822 (section 5.1) format', 'speaker' ) .
			'<br><strong>[item_url]</strong>' . ' — ' . esc_html__( 'Audio file URL', 'speaker' ) .
			'<br><strong>[item_type]</strong>' . ' — ' . esc_html__( 'Audio file format', 'speaker' ) .
			'<br><strong>[item_length]</strong>' . ' — ' . esc_html__( 'Audio file size in bytes', 'speaker' ) .
			'<br><strong>[item_duration]</strong>' . ' — ' . esc_html__( 'Formatted audio duration', 'speaker' ) .
			'<br><strong>[item_thumbnail]</strong>' . ' — ' . esc_html__( 'Post thumbnail', 'speaker' ) .
			'<br><strong>[item_guid]</strong>' . ' — ' . esc_html__( 'Unique ID of the podcast episode', 'speaker' ),
			'default'           => '
<title>[item_title]</title>
<description>[item_excerpt]</description>
<pubDate>[item_date]</pubDate>
<enclosure url="[item_url]" type="[item_type]" length="[item_length]"></enclosure>
<itunes:duration>[item_duration]</itunes:duration>
<itunes:image href="[item_thumbnail]"/>
<guid>[item_guid]</guid>
',
			'attr'              => [
				'spellcheck'    => 'false',
				'maxlength'     => '4500'
			]
		];

		$rss_base_name = apply_filters( 'speaker_rss_file_base_name', 'podcast' );
		$fields[ 'podcast_root_file' ] = [
			'type'              => 'switcher',
			'label'             => esc_html__( 'Create root file', 'speaker' ),
			'description'       => esc_html__( 'Create RSS file in website root', 'speaker' ) .
			                       ' <a href="' . get_bloginfo( 'url' ) . '/' . esc_attr( $rss_base_name ) .  '.xml" target="_blank">' . get_bloginfo( 'url' ) . '/' . esc_attr( $rss_base_name ) . '.xml</a> ' .
                                    esc_html__('every time after audio created or updated', 'speaker'),
			'default'           => 'off',
		];

		$tabs[ 'rss' ][ 'fields' ] = $fields;
		Plugin::set_tabs( $tabs );

	}

}
