<?php
/**
 * Template Name: Speaker Template
 * File: speaker-template.php
 **/

/**
 * Speaker
 * Create an audio version of your posts, with a selection of more than 340 voices across more than 52 languages and variants.
 * Exclusively on https://1.envato.market/speaker
 *
 * @encoding        UTF-8
 * @version         4.1.10
 * @copyright       (C) 2018 - 2023 Merkulove ( https://merkulov.design/ ). All rights reserved.
 * @license         Envato License https://1.envato.market/KYbje
 * @contributors    Dmitry Merkulov (dmitry@merkulov.design)
 * @support         help@merkulov.design
 **/

/** Exit if accessed directly. */

namespace Merkulove\Speaker;

use Merkulove\Speaker\Unity\Settings;

if ( ! defined( 'ABSPATH' ) ) {
    header( 'Status: 403 Forbidden' );
    header( 'HTTP/1.1 403 Forbidden' );
    exit;
}

// Is WordPress debug mode is enabled?
$is_debug = defined( 'WP_DEBUG' ) && WP_DEBUG;

// Verify if the request is from WordPress.
if ( ! $is_debug && strpos(
        $_SERVER['HTTP_USER_AGENT'] ?? '',
        'WordPress/' . get_bloginfo( 'version' ) . ';'
    ) !== 0 ) {
    wp_die( 'Security check failed' );
}
?>

<!doctype html>
<html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo( 'charset' ); ?>" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <?php wp_head(); ?>
    </head>

<body <?php body_class(); ?>>
    <?php wp_body_open(); ?>

<div class="mdp-speaker-content-start"></div>
<?php if ( have_posts() ) {

    while ( have_posts() ) {

        the_post();

        /** Include title in audio version? */
        $options = Settings::get_instance()->options;
        if ( isset( $options['read_title'] ) && 'on' === $options['read_title'] ) {
            ?><h1><?php the_title(); ?></h1><break time="1s"></break><?php
        }

        the_content();

    }

}
?>
<div class="mdp-speaker-content-end"></div>
<?php wp_footer(); ?>
</body>
</html>
