<?php

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Ajax handlers for the user design library.
 */

if ( ! function_exists( 'stackable_update_user_designs_library' ) ) {

	/**
	 * Updates the user designs of a block.
	 */
	function stackable_update_user_designs_library() {
		$nonce = isset( $_POST['nonce'] ) ? sanitize_key( $_POST['nonce'] ) : '';

		if ( ! wp_verify_nonce( $nonce, 'stackable' ) ) {
			wp_send_json_error( __( 'Security error, please refresh the page and try again.', STACKABLE_I18N ) );
		}

		$designs = isset( $_POST['designs'] ) ? $_POST['designs'] : array();
		$block = isset( $_POST['block'] ) ? $_POST['block'] : '';

		if ( empty( $block ) ) {
			wp_send_json_error( __( 'Invalid arguments.', STACKABLE_I18N ) );
		}

		update_option( 'stackable_saved_designs_' . $block, json_decode( stripslashes( $designs ) ) );
		wp_send_json_success();
	}

	add_action( 'wp_ajax_stackable_update_user_designs_library', 'stackable_update_user_designs_library' );
}

if ( ! function_exists( 'stackable_get_user_designs_library' ) ) {

	/**
	 * Gets all the saved designs of a block.
	 */
	function stackable_get_user_designs_library() {
		$nonce = isset( $_POST['nonce'] ) ? sanitize_key( $_POST['nonce'] ) : '';

		if ( ! wp_verify_nonce( $nonce, 'stackable' ) ) {
			wp_send_json_error( __( 'Security error, please refresh the page and try again.', STACKABLE_I18N ) );
		}

		$block = isset( $_POST['block'] ) ? $_POST['block'] : '';

		if ( empty( $block ) ) {
			wp_send_json_error( __( 'Invalid arguments.', STACKABLE_I18N ) );
		}

		$designs = get_option( 'stackable_saved_designs_' . $block );
		if ( empty( $designs ) ) {
			$designs = array();
		}

		wp_send_json_success( json_encode( $designs ) );
	}

	add_action( 'wp_ajax_stackable_get_user_designs_library', 'stackable_get_user_designs_library' );
}
