<?php

namespace SpringDevs\SubscriptionPro\Admin\Product;

/**
 * Class Simple
 *
 * @package SpringDevs\SubscriptionPro\Admin\Product
 */
class Simple {

	/**
	 * Initialize the class
	 */
	public function __construct() {
		add_action( 'subscrpt_simple_pro_fields', array( $this, 'add_subscription_forms' ) );
		add_action( 'save_post_product', array( $this, 'save_data' ) );
	}

	/**
	 * Display fields which available for premium users
	 *
	 * @param int $product_id product ID.
	 */
	public function add_subscription_forms( int $product_id ) {
		wp_enqueue_script( 'subscrpt_admin_product_js' );
		$timing_types                           = wps_subscription_get_timing_types();
		$subscrpt_time                          = 1;
		$subscrpt_timing                        = null;
		$subscrpt_trial_time                    = null;
		$subscrpt_trial_timing                  = null;
		$subscrpt_cart_txt                      = 'subscribe';
		$subscrpt_user_cancel                   = 'yes';
		$subscrpt_signup_fee                    = null;
		$subscrpt_limit                         = 'one';
		$subscrpt_renewal_limit                 = 0;
		$subscrpt_delivery_timing_per           = null;
		$subscrpt_delivery_timing_option        = null;
		$subscrpt_synchronize_delivery_schedule = 'no';
		$subscrpt_synchronize_delivery_day      = null;

		// New split payment fields
		$subscrpt_payment_type                = 'recurring';
		$subscrpt_access_ends_timing          = 'after_full_duration';
		$subscrpt_custom_access_duration_time = 1;
		$subscrpt_custom_access_duration_type = 'months';

		$screen = get_current_screen();
		if ( 'edit' === $screen->parent_base ) {
			$product = wc_get_product( $product_id );
			if ( $product ) {
				$subscrpt_time         = $product->get_meta( '_subscrpt_timing_per' );
				$subscrpt_timing       = $product->get_meta( '_subscrpt_timing_option' );
				$subscrpt_trial_time   = $product->get_meta( '_subscrpt_trial_timing_per' );
				$subscrpt_trial_timing = $product->get_meta( '_subscrpt_trial_timing_option' );
				$subscrpt_cart_txt     = $product->get_meta( '_subscrpt_cart_btn_label' );
				$subscrpt_user_cancel  = $product->get_meta( '_subscrpt_user_cancel' );
				$subscrpt_signup_fee   = $product->get_meta( '_subscrpt_signup_fee' );
				$subscrpt_limit        = $product->get_meta( '_subscrpt_limit' );

				// Migration: Get max_no_payment, fallback to old renewal_limit if needed
				$subscrpt_max_no_payment = $product->get_meta( '_subscrpt_max_no_payment' ) ?: 0;

				$subscrpt_delivery_timing_per           = $product->get_meta( '_subscrpt_delivery_timing_per' );
				$subscrpt_delivery_timing_option        = $product->get_meta( '_subscrpt_delivery_timing_option' );
				$subscrpt_synchronize_delivery_schedule = $product->get_meta( '_subscrpt_synchronize_delivery_schedule' );
				$subscrpt_synchronize_delivery_day      = $product->get_meta( '_subscrpt_synchronize_delivery_day' );

				// New split payment fields
				$subscrpt_payment_type                = $product->get_meta( '_subscrpt_payment_type' ) ?: 'recurring';
				$subscrpt_access_ends_timing          = $product->get_meta( '_subscrpt_access_ends_timing' ) ?: 'after_full_duration';
				$subscrpt_custom_access_duration_time = $product->get_meta( '_subscrpt_custom_access_duration_time' ) ?: 1;
				$subscrpt_custom_access_duration_type = $product->get_meta( '_subscrpt_custom_access_duration_type' ) ?: 'months';
			}
		}
		?>
		<div id="sdevs_subscription_options"
			class="panel woocommerce_options_panel option_group sdevs-form sdevs_panel show_if_simple"
			style="padding: 10px;">
			<div class="show_if_subscription">
				<strong
					style="margin: 10px;"><?php esc_html_e( 'Subscription Settings', 'wp_subscription_pro' ); ?></strong>
				<input name="_subscript_nonce" type="hidden"
					value="<?php echo esc_attr( wp_create_nonce( '_subscript_edit_product_nonce' ) ); ?>" />
				
				<?php
				// Payment Type dropdown
				woocommerce_wp_select(
					array(
						'id'          => 'subscrpt_payment_type',
						'label'       => __( 'Payment Type', 'wp_subscription_pro' ),
						'options'     => array(
							'recurring'     => __( 'Recurring', 'wp_subscription_pro' ),
							'split_payment' => __( 'Split Payment', 'wp_subscription_pro' ),
						),
						'value'       => $subscrpt_payment_type,
						'description' => __( 'Choose between recurring payments or split payment installments.', 'wp_subscription_pro' ),
						'desc_tip'    => true,
					)
				);

				sdevs_subscrpt_recurring_field(
					array(
						'time' => array(
							'label' => __( 'Repeat payment every', 'wp_subscription_pro' ),
							'name'  => 'subscrpt_time',
							'value' => $subscrpt_time,
							'attrs' => array(
								'min' => 1,
							),
						),
						'type' => array(
							'name'    => 'subscrpt_timing',
							'value'   => $subscrpt_timing,
							'options' => $timing_types,
						),
						'desc' => __( 'Set how often the user will be charged (e.g. every week, month, or year).', 'wp_subscription_pro' ),
					)
				);

				sdevs_subscrpt_recurring_field(
					array(
						'time' => array(
							'label' => __( 'Free Trial Duration', 'wp_subscription_pro' ),
							'name'  => 'subscrpt_trial_time',
							'value' => $subscrpt_trial_time,
							'attrs' => array(),
						),
						'type' => array(
							'name'    => 'subscrpt_trial_timing',
							'value'   => $subscrpt_trial_timing,
							'options' => $timing_types,
						),
						'desc' => __( 'Let users try the subscription for free before the first payment is collected.', 'wp_subscription_pro' ),
					)
				);

				woocommerce_wp_text_input(
					array(
						'id'          => 'subscrpt_signup_fee',
						'label'       => 'Sign-Up Fee (' . get_woocommerce_currency_symbol() . ')',
						'type'        => 'text',
						'value'       => $subscrpt_signup_fee,
						'description' => __( 'Signup fee will be additional charged when the subscription is purchased.', 'wp_subscription_pro' ),
						'desc_tip'    => true,
					)
				);

				?>
				
				<!-- Split Payment fields (conditional) -->
				<div id="split_payment_fields" style="<?php echo ( $subscrpt_payment_type !== 'split_payment' ) ? 'display: none;' : ''; ?>">
					<br />
					<strong style="margin: 10px;"><?php esc_html_e( 'Split Payment', 'wp_subscription_pro' ); ?></strong>
					<p class="description" style="margin: 10px 10px 20px 10px;"><?php esc_html_e( 'Control the split payment settings for this product.', 'wp_subscription_pro' ); ?></p>
					<?php
					woocommerce_wp_text_input(
						array(
							'id'                => 'subscrpt_max_no_payment_split',
							'label'             => __( 'Number of Payments', 'wp_subscription_pro' ),
							'type'              => 'number',
							'value'             => ( $subscrpt_payment_type === 'split_payment' ) ? $subscrpt_max_no_payment : 2,
							'description'       => __( 'Set how many installments this split payment will have. Must be greater than 1.', 'wp_subscription_pro' ),
							'desc_tip'          => true,
							'custom_attributes' => array(
								'min'  => '2',
								'step' => '1',
							),
						)
					);
					?>
					<?php
					// Access Ends Timing dropdown
					woocommerce_wp_select(
						array(
							'id'          => 'subscrpt_access_ends_timing',
							'label'       => __( 'Access Ends Timing', 'wp_subscription_pro' ),
							'options'     => array(
								'lifetime'            => __( 'Lifetime access after completion', 'wp_subscription_pro' ),
								'after_full_duration' => __( 'After full access duration (default)', 'wp_subscription_pro' ),
								'custom_duration'     => __( 'Custom access duration', 'wp_subscription_pro' ),
							),
							'value'       => $subscrpt_access_ends_timing,
							'description' => __( 'Choose when access should end for split payment subscriptions.', 'wp_subscription_pro' ),
							'desc_tip'    => true,
						)
					);
					?>
					
					<!-- Custom Access Duration fields (conditional) -->
					<div id="custom_duration_fields" style="<?php echo ( $subscrpt_access_ends_timing !== 'custom_duration' ) ? 'display: none;' : ''; ?>">
						<?php
						sdevs_subscrpt_recurring_field(
							array(
								'time' => array(
									'label' => __( 'Custom Access Duration', 'wp_subscription_pro' ),
									'name'  => 'subscrpt_custom_access_duration_time',
									'value' => $subscrpt_custom_access_duration_time,
									'attrs' => array(
										'min' => 1,
									),
								),
								'type' => array(
									'name'    => 'subscrpt_custom_access_duration_type',
									'value'   => $subscrpt_custom_access_duration_type,
									'options' => $timing_types,
								),
								'desc' => __( 'Define how long access should continue after the first payment is completed.', 'wp_subscription_pro' ),
							)
						);
						?>
					</div>
					

				</div>
				
				<script type="text/javascript">
				jQuery(document).ready(function($) {
					// Add CSS to ensure proper visibility control
					if (!$('#subscrpt_simple_styles').length) {
						$('<style id="subscrpt_simple_styles">' +
							'.subscrpt-hidden { display: none !important; }' +
							'.subscrpt-visible { display: block !important; }' +
						'</style>').appendTo('head');
					}
					
					// Payment Type conditional logic
					function togglePaymentTypeFields() {
						var paymentType = $('#subscrpt_payment_type').val();
						console.log('Toggling payment type fields for simple product, type: ' + paymentType);
						var splitFieldsElement = $('#split_payment_fields');
						
						if (paymentType === 'split_payment') {
							splitFieldsElement.removeClass('subscrpt-hidden').addClass('subscrpt-visible').show();
							console.log('Showing split payment fields for simple product');
						} else {
							splitFieldsElement.removeClass('subscrpt-visible').addClass('subscrpt-hidden').hide();
							console.log('Hiding split payment fields for simple product');
						}
					}
					
					// Access Ends Timing conditional logic
					function toggleCustomDurationFields() {
						var accessTiming = $('#subscrpt_access_ends_timing').val();
						console.log('Toggling custom duration fields for simple product, timing: ' + accessTiming);
						var customFieldsElement = $('#custom_duration_fields');
						
						if (accessTiming === 'custom_duration') {
							customFieldsElement.removeClass('subscrpt-hidden').addClass('subscrpt-visible').show();
							console.log('Showing custom duration fields for simple product');
						} else {
							customFieldsElement.removeClass('subscrpt-visible').addClass('subscrpt-hidden').hide();
							console.log('Hiding custom duration fields for simple product');
						}
					}
					
					// Initialize fields function
					function initializeFields() {
						console.log('Initializing simple product fields');
						togglePaymentTypeFields();
						toggleCustomDurationFields();
					}
					
					// Initial toggle
					initializeFields();
					
					// Also initialize after a short delay
					setTimeout(initializeFields, 100);
					
					// Event handlers with better error handling
					$(document).on('change', '#subscrpt_payment_type', function() {
						console.log('Payment type changed for simple product:', $(this).val());
						togglePaymentTypeFields();
					});
					
					$(document).on('change', '#subscrpt_access_ends_timing', function() {
						console.log('Access timing changed for simple product:', $(this).val());
						toggleCustomDurationFields();
					});
					
					// Debug function - can be called from browser console
					window.debugSimpleProduct = function() {
						console.log('=== Debug Info for Simple Product ===');
						console.log('Payment Type Element:', $('#subscrpt_payment_type').length > 0 ? 'Found' : 'NOT FOUND');
						console.log('Current Payment Type:', $('#subscrpt_payment_type').val());
						console.log('Split Fields Element:', $('#split_payment_fields').length > 0 ? 'Found' : 'NOT FOUND');
						console.log('Split Fields Visible:', $('#split_payment_fields').is(':visible'));
						console.log('Access Timing Element:', $('#subscrpt_access_ends_timing').length > 0 ? 'Found' : 'NOT FOUND');
						console.log('Current Access Timing:', $('#subscrpt_access_ends_timing').val());
						console.log('Custom Duration Fields Element:', $('#custom_duration_fields').length > 0 ? 'Found' : 'NOT FOUND');
						console.log('Custom Duration Fields Visible:', $('#custom_duration_fields').is(':visible'));
						console.log('=== End Debug Info ===');
						
						// Test the functions
						console.log('Testing toggle functions...');
						togglePaymentTypeFields();
						toggleCustomDurationFields();
					};
					
					console.log('Debug function available: debugSimpleProduct()');
				});
				</script>

				<!-- More settings hook -->
				<?php do_action( 'subscrpt_simple_pro_after_subs_fields', $product_id ); ?>
				<!-- More settings hook -->
				
				<br />
				<div class="hide_if_virtual">
				<strong style="margin: 10px;">Delivery Settings</strong>
				<?php
				sdevs_subscrpt_recurring_field(
					array(
						'time' => array(
							'label' => __( 'Delivery Schedule', 'wp_subscription_pro' ),
							'name'  => 'subscrpt_delivery_timing_per',
							'value' => $subscrpt_delivery_timing_per,
							'attrs' => array(),
						),
						'type' => array(
							'name'    => 'subscrpt_delivery_timing_option',
							'value'   => $subscrpt_delivery_timing_option,
							'options' => $timing_types,
						),
						'desc' => __( 'Set a delivery schedule for this product.', 'wp_subscription_pro' ),
					)
				);
				woocommerce_wp_checkbox(
					array(
						'id'          => 'subscrpt_synchronize_delivery_schedule',
						'label'       => __( 'Synchronize Schedule', 'wp_subscription_pro' ),
						'description' => __( 'Enable if you want to ship the product on a specific day.', 'wp_subscription_pro' ),
						'value'       => $subscrpt_synchronize_delivery_schedule,
					)
				);
				$week_days = array(
					'Mon' => 'Monday',
					'Tue' => 'Tuesday',
					'Wed' => 'Wednesday',
					'Thu' => 'Thursday',
					'Fri' => 'Friday',
					'Sat' => 'Saturday',
					'Sun' => 'Sunday',
				);
				woocommerce_wp_select(
					array(
						'id'      => 'subscrpt_synchronize_delivery_day',
						'options' => $week_days,
						'value'   => $subscrpt_synchronize_delivery_day,
						'label'   => __( 'Synchronize delivery on', 'wp_subscription_pro' ),
					)
				);
				?>
				</div>

				<br />
				<strong style="margin: 10px;"><?php esc_html_e( 'Advanced Settings', 'wp_subscription_pro' ); ?></strong>
				<p class="description"><?php esc_html_e( 'These settings are for advanced users only.', 'wp_subscription_pro' ); ?></p>	

				<?php
				woocommerce_wp_text_input(
					array(
						'id'          => 'subscrpt_cart_txt',
						'label'       => __( 'Button Text (Custom)', 'wp_subscription_pro' ),
						'type'        => 'text',
						'value'       => $subscrpt_cart_txt,
						'description' => __( 'Customize the button label shown on the product or shop page. Default is "subscribe"', 'wp_subscription_pro' ),
						'desc_tip'    => true,
					)
				);

				woocommerce_wp_select(
					array(
						'id'          => 'subscrpt_user_cancel',
						'label'       => __( 'Allow User Cancellation?', 'wp_subscription_pro' ),
						'value'       => $subscrpt_user_cancel,
						'options'     => array(
							'yes' => __( 'Yes', 'wp_subscription_pro' ),
							'no'  => __( 'No', 'wp_subscription_pro' ),
						),
						'description' => __( 'Allow subscribers to cancel their subscription manually from their account dashboard.', 'wp_subscription_pro' ),
						'desc_tip'    => true,
					)
				);

				woocommerce_wp_select(
					array(
						'id'          => 'subscrpt_limit',
						'label'       => __( 'Activation Limit', 'wp_subscription_pro' ),
						'options'     => array(
							'unlimited' => __( 'Do not limit', 'wp_subscription_pro' ),
							'one'       => __( 'Allow only one active subscription', 'wp_subscription_pro' ),
							'only_one'  => __( 'Allow only one subscription of any status', 'wp_subscription_pro' ),
						),
						'value'       => $subscrpt_limit,
						'description' => __( 'Controls how many times a customer can buy or re-subscribe to this product.', 'wp_subscription_pro' ),
						'desc_tip'    => true,
					)
				);
				?>
			</div>
		</div>
		<?php
	}

	/**
	 * Save Simple Product data
	 *
	 * @param int $product_id product ID.
	 */
	public function save_data( int $product_id ) {
		// nonce verify.
		if ( ! isset( $_POST['_subscript_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['_subscript_nonce'] ) ), '_subscript_edit_product_nonce' ) ) {
			return;
		}

		// check if some fields value exists.
		if ( ! isset( $_POST['subscrpt_time'] ) || ! isset( $_POST['subscrpt_timing'] ) || ! isset( $_POST['subscrpt_trial_time'] ) || ! isset( $_POST['subscrpt_trial_timing'] ) ) {
			return;
		}

		remove_action( 'save_post_product', array( $this, 'save_data' ) );

		$subscrpt_enable                        = isset( $_POST['subscrpt_enable'] ) && sanitize_text_field( wp_unslash( $_POST['subscrpt_enable'] ) );
		$subscrpt_time                          = ! empty( $_POST['subscrpt_time'] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_time'] ) ) : 1;
		$subscrpt_timing                        = sanitize_text_field( wp_unslash( $_POST['subscrpt_timing'] ) );
		$subscrpt_trial_time                    = sanitize_text_field( wp_unslash( $_POST['subscrpt_trial_time'] ) );
		$subscrpt_trial_timing                  = sanitize_text_field( wp_unslash( $_POST['subscrpt_trial_timing'] ) );
		$subscrpt_cart_txt                      = isset( $_POST['subscrpt_cart_txt'] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_cart_txt'] ) ) : null;
		$subscrpt_user_cancel                   = isset( $_POST['subscrpt_user_cancel'] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_user_cancel'] ) ) : null;
		$subscrpt_signup_fee                    = isset( $_POST['subscrpt_signup_fee'] ) && ! empty( $_POST['subscrpt_signup_fee'] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_signup_fee'] ) ) : null;
		$subscrpt_limit                         = isset( $_POST['subscrpt_limit'] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_limit'] ) ) : 'unlimited';
		$subscrpt_delivery_timing_per           = isset( $_POST['subscrpt_delivery_timing_per'] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_delivery_timing_per'] ) ) : null;
		$subscrpt_delivery_timing_option        = isset( $_POST['subscrpt_delivery_timing_option'] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_delivery_timing_option'] ) ) : null;
		$subscrpt_synchronize_delivery_schedule = isset( $_POST['subscrpt_synchronize_delivery_schedule'] ) ? 'yes' : 'no';
		$subscrpt_synchronize_delivery_day      = isset( $_POST['subscrpt_synchronize_delivery_day'] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_synchronize_delivery_day'] ) ) : null;

		// New split payment fields
		$subscrpt_payment_type                = isset( $_POST['subscrpt_payment_type'] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_payment_type'] ) ) : 'recurring';
		$subscrpt_access_ends_timing          = isset( $_POST['subscrpt_access_ends_timing'] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_access_ends_timing'] ) ) : 'after_full_duration';
		$subscrpt_custom_access_duration_time = isset( $_POST['subscrpt_custom_access_duration_time'] ) ? (int) sanitize_text_field( wp_unslash( $_POST['subscrpt_custom_access_duration_time'] ) ) : 1;
		$subscrpt_custom_access_duration_type = isset( $_POST['subscrpt_custom_access_duration_type'] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_custom_access_duration_type'] ) ) : 'months';

		// Determine max_no_payment based on payment type
		if ( 'split_payment' === $subscrpt_payment_type ) {
			$subscrpt_max_no_payment = isset( $_POST['subscrpt_max_no_payment_split'] ) ? (int) sanitize_text_field( wp_unslash( $_POST['subscrpt_max_no_payment_split'] ) ) : 2;
		} else {
			// For recurring payments, set to 0 (unlimited) by default
			$subscrpt_max_no_payment = 0;
		}

		if ( 'yes' === $subscrpt_synchronize_delivery_schedule && ! $subscrpt_synchronize_delivery_day ) {
			return;
		}

		$product         = wc_get_product( $product_id );
		$already_enabled = $product->get_meta( '_subscrpt_enabled' ) ? 'yes' : 'no';
		if ( 'yes' === $already_enabled ) {
			$this->handle_type_changes( $product );
		}

		$product->update_meta_data( '_subscrpt_enabled', $subscrpt_enable );
		$product->update_meta_data( '_subscrpt_timing_per', $subscrpt_time );
		$product->update_meta_data( '_subscrpt_timing_option', $subscrpt_timing );
		$product->update_meta_data( '_subscrpt_trial_timing_per', $subscrpt_trial_time );
		$product->update_meta_data( '_subscrpt_trial_timing_option', $subscrpt_trial_timing );
		$product->update_meta_data( '_subscrpt_cart_btn_label', $subscrpt_cart_txt );
		$product->update_meta_data( '_subscrpt_user_cancel', $subscrpt_user_cancel );
		$product->update_meta_data( '_subscrpt_signup_fee', $subscrpt_signup_fee );
		$product->update_meta_data( '_subscrpt_limit', $subscrpt_limit );
		$product->update_meta_data( '_subscrpt_max_no_payment', $subscrpt_max_no_payment );
		$product->update_meta_data( '_subscrpt_delivery_timing_per', $subscrpt_delivery_timing_per );
		$product->update_meta_data( '_subscrpt_delivery_timing_option', $subscrpt_delivery_timing_option );
		$product->update_meta_data( '_subscrpt_synchronize_delivery_schedule', $subscrpt_synchronize_delivery_schedule );
		$product->update_meta_data( '_subscrpt_synchronize_delivery_day', $subscrpt_synchronize_delivery_day );

		// Save new split payment fields
		$product->update_meta_data( '_subscrpt_payment_type', $subscrpt_payment_type );
		$product->update_meta_data( '_subscrpt_access_ends_timing', $subscrpt_access_ends_timing );
		$product->update_meta_data( '_subscrpt_custom_access_duration_time', $subscrpt_custom_access_duration_time );
		$product->update_meta_data( '_subscrpt_custom_access_duration_type', $subscrpt_custom_access_duration_type );

		$product->save();

		add_action( 'save_post_product', array( $this, 'save_data' ) );
	}

	/**
	 * Handle product Type change's
	 *
	 * @param \WC_Product $product Product Object.
	 *
	 * @return void
	 */
	public function handle_type_changes( $product ) {
        // phpcs:ignore WordPress.Security.NonceVerification.Missing
		if ( ! isset( $_POST['product-type'] ) ) {
			return;
		}
        // phpcs:ignore WordPress.Security.NonceVerification.Missing
		if ( $product && $product->is_type( 'simple' ) && 'variable' === $_POST['product-type'] ) {
			$product->update_meta_data( '_subscrpt_product_covertation', 'simple_to_variable' );
		}
	}
}
