<?php

namespace SpringDevs\SubscriptionPro\Admin\Product;

/**
 * Class Variable
 *
 * @package SpringDevs\SubscriptionPro\Admin\Product
 */
class Variable {

	/**
	 * Initialize the class.
	 */
	public function __construct() {
		add_action( 'woocommerce_variation_options', array( $this, 'add_subscription_checkbox' ), 10, 3 );
		add_action( 'woocommerce_variation_options_pricing', array( $this, 'add_custom_field_to_variations' ), 10, 3 );
		add_action( 'woocommerce_save_product_variation', array( $this, 'save_variable_data' ), 10, 2 );
		add_action( 'edit_form_top', array( $this, 'display_convertation_notice' ) );
		add_action( 'add_meta_boxes', array( $this, 'add_meta_boxes' ) );
		add_action( 'save_post_product', array( $this, 'save_data' ) );
		add_action( 'woocommerce_product_after_variable_attributes', array( $this, 'add_delivery_fields' ), 10, 3 );
	}

	/**
	 * Save Simple Product data
	 *
	 * @param int $post_id post ID.
	 */
	public function save_data( $post_id ) {
		if ( ! isset( $_POST['_subscript_nonce'] ) || ! wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['_subscript_nonce'] ) ), '_subscript_edit_product_nonce' ) ) {
			return;
		}

		if ( ! isset( $_POST['sdevs_variation_convertation'] ) ) {
			return false;
		}

		update_post_meta( $post_id, '_subscrpt_convertation_default_variation_for_renewal', (int) sanitize_text_field( wp_unslash( $_POST['sdevs_variation_convertation'] ) ) );
		delete_post_meta( $post_id, '_subscrpt_product_covertation' );
	}

	/**
	 * Related Subscriptions meta box on Orders.
	 */
	public function add_meta_boxes() {
		if ( 'product' === get_post_type() ) {
			$product = wc_get_product( get_the_ID() );
			if ( $product->get_meta( '_subscrpt_product_covertation' ) && 'simple_to_variable' === $product->get_meta( '_subscrpt_product_covertation' ) ) {
				add_meta_box(
					'subscrpt_simple_to_variable_convertation',
					__( 'Set default variation for subscribed users renewal !', 'wp_subscription_pro' ),
					array( $this, 'subscrpt_simple_to_variable_convertation' ),
					'product',
					'normal',
					'high',
					array(
						'variations' => $product->get_available_variations(),
					)
				);
			}
		}
	}

	/**
	 * Subscription product simple to variable convertation.
	 *
	 * @param \WC_Product $product Product object.
	 * @param array       $args Arguments.
	 *
	 * @return void
	 */
	public function subscrpt_simple_to_variable_convertation( $product, $args ) {
		$variations = $args['args']['variations'];
		$variations = array_filter(
			$variations,
			function ( $variation ) {
				$enabled = get_post_meta( $variation['variation_id'], '_subscrpt_enabled', true );
				if ( $enabled ) {
					return true;
				}
				return false;
			}
		);
		?>
		<label for="sdevs_variation_convertation"><strong><?php esc_attr_e( 'Select Variation ID :', 'wp_subscription_pro' ); ?></strong></label>
		<br>
			<select style="margin-top: 4px;" name="sdevs_variation_convertation" id="sdevs_variation_convertation">
		<?php foreach ( $variations as $variation ) : ?>
					<option value="<?php echo esc_html( $variation['variation_id'] ); ?>"><?php echo esc_html( $variation['variation_id'] ); ?></option>
		<?php endforeach; ?>
			</select>
			<?php if ( count( $variations ) === 0 ) : ?>
				<p><?php esc_html_e( 'No variations found! Please create a variation with enable subscription and refresh the page.', 'wp_subscription_pro' ); ?></p>
			<?php endif; ?>
		<?php
	}

	/**
	 * Checkbox in variation
	 *
	 * @param mixed    $loop           loop.
	 * @param mixed    $variation_data variation_data.
	 * @param \WP_Post $variation      variation object.
	 */
	public function add_subscription_checkbox( $loop, $variation_data, $variation ) {
		$checked = (bool) get_post_meta( $variation->ID, '_subscrpt_enabled', true );
		?>
		<label class="tips" data-tip="<?php esc_attr_e( 'Enable Subscriptions', 'wp_subscription_pro' ); ?>">
		<?php esc_html_e( 'Subscription', 'wp_subscription_pro' ); ?>
			<input type="checkbox" class="checkbox subscrpt_variable_enable" onchange="hellochange('<?php echo esc_attr( $loop ); ?>')" id="subscrpt_enable[<?php echo esc_attr( $loop ); ?>]" name="subscrpt_enable[<?php echo esc_attr( $loop ); ?>]" value="yes" <?php echo esc_attr( $checked ? 'checked' : null ); ?>
			/>
		</label>
		<?php
	}

	/**
	 * Fields for variation
	 *
	 * @param mixed    $loop           loop.
	 * @param mixed    $variation_data variation_data.
	 * @param \WP_Post $variation      variation object.
	 */
	public function add_custom_field_to_variations( $loop, $variation_data, $variation ) {
		$timing_types = wps_subscription_get_timing_types();
		$variation_id = $variation->ID;

		$subscrpt_time        = get_post_meta( $variation_id, '_subscrpt_timing_per', true );
		$subscrpt_timing      = get_post_meta( $variation_id, '_subscrpt_timing_option', true );
		$subscrpt_trial_time  = get_post_meta( $variation_id, '_subscrpt_trial_timing_per', true );
		$subscrpt_trial_type  = get_post_meta( $variation_id, '_subscrpt_trial_timing_option', true );
		$subscrpt_user_cancel = get_post_meta( $variation_id, '_subscrpt_user_cancel', true );
		$subscrpt_signup_fee  = get_post_meta( $variation_id, '_subscrpt_signup_fee', true );
		$subscrpt_limit       = get_post_meta( $variation_id, '_subscrpt_limit', true );

		// Migration: Get max_no_payment, fallback to old renewal_limit if needed
		$subscrpt_max_no_payment = get_post_meta( $variation_id, '_subscrpt_max_no_payment', true ) ?: 0;

		// New split payment fields
		$subscrpt_payment_type                = get_post_meta( $variation_id, '_subscrpt_payment_type', true ) ?: 'recurring';
		$subscrpt_access_ends_timing          = get_post_meta( $variation_id, '_subscrpt_access_ends_timing', true ) ?: 'after_full_duration';
		$subscrpt_custom_access_duration_time = get_post_meta( $variation_id, '_subscrpt_custom_access_duration_time', true ) ?: 1;
		$subscrpt_custom_access_duration_type = get_post_meta( $variation_id, '_subscrpt_custom_access_duration_type', true ) ?: 'months';

		?>
		<div class="sdevs-form show_if_subscription_<?php echo esc_attr( $loop ); ?>">
			<!-- Payment Type dropdown -->
			<p class="form-field subscrpt_payment_type_field form-row form-row-full">
				<label for="subscrpt_payment_type[<?php echo esc_attr( $loop ); ?>]"><?php esc_html_e( 'Payment Type', 'wp_subscription_pro' ); ?></label>
				<select id="subscrpt_payment_type[<?php echo esc_attr( $loop ); ?>]" name="subscrpt_payment_type[<?php echo esc_attr( $loop ); ?>]" class="select short">
					<option value="recurring" <?php selected( $subscrpt_payment_type, 'recurring' ); ?>><?php esc_html_e( 'Recurring', 'wp_subscription_pro' ); ?></option>
					<option value="split_payment" <?php selected( $subscrpt_payment_type, 'split_payment' ); ?>><?php esc_html_e( 'Split Payment', 'wp_subscription_pro' ); ?></option>
				</select>
				<span class="description"><?php esc_html_e( 'Choose between recurring payments or split payment installments.', 'wp_subscription_pro' ); ?></span>
			</p>
			
			<p class="form-field subscrpt_time_field form-row form-row-first">
				<label for="subscrpt_time[<?php echo esc_attr( $loop ); ?>]">Users will pay every</label>
				<input type="number" class="short" name="subscrpt_time[<?php echo esc_attr( $loop ); ?>]" id="subscrpt_time[<?php echo esc_attr( $loop ); ?>]" value="<?php echo esc_html( $subscrpt_time ); ?>" min="1" />
			</p>
			<p class="form-field subscrpt_timing_field form-row form-row-last">
				<label for="subscrpt_timing[<?php echo esc_attr( $loop ); ?>]">Type</label>
				<select id="subscrpt_timing[<?php echo esc_attr( $loop ); ?>]" name="subscrpt_timing[<?php echo esc_attr( $loop ); ?>]" class="postform">
		<?php foreach ( $timing_types as $timing_type ) : ?>
						<option value="<?php echo esc_attr( $timing_type['value'] ); ?>" <?php echo esc_attr( $timing_type['value'] === $subscrpt_timing ? 'selected' : null ); ?>
						><?php echo esc_html( $timing_type['label'] ); ?></option>
		<?php endforeach; ?>
				</select>
			</p>
			<p class="form-field subscrpt_trial_time_field form-row form-row-first">
				<label for="subscrpt_trial_time[<?php echo esc_attr( $loop ); ?>]"><?php esc_html_e( 'Free Trial Duration', 'wp_subscription_pro' ); ?></label>
				<input type="number" class="short" name="subscrpt_trial_time[<?php echo esc_attr( $loop ); ?>]" id="subscrpt_trial_time[<?php echo esc_attr( $loop ); ?>]" value="<?php echo esc_attr( $subscrpt_trial_time ); ?>" min="1" />
			</p>
			<p class="form-field subscrpt_trial_timing_field form-row form-row-last">
				<label for="subscrpt_trial_timing[<?php echo esc_attr( $loop ); ?>]">Type</label>
				<select id="subscrpt_trial_timing[<?php echo esc_attr( $loop ); ?>]" name="subscrpt_trial_timing[<?php echo esc_attr( $loop ); ?>]" class="postform">
		<?php foreach ( $timing_types as $timing_type ) : ?>
						<option value="<?php echo esc_attr( $timing_type['value'] ); ?>" <?php echo esc_attr( $timing_type['value'] === $subscrpt_trial_type ? 'selected' : null ); ?>
						><?php echo esc_html( $timing_type['label'] ); ?></option>
		<?php endforeach; ?>
				</select>
			</p>

			<p class="form-field subscrpt_signup_fee_field form-row form-row-full">
				<label for="subscrpt_signup_fee[<?php echo esc_attr( $loop ); ?>]">Sign-Up Fee (<?php echo esc_html( get_woocommerce_currency_symbol() ); ?>)</label>
				<input type="text" class="short" name="subscrpt_signup_fee[<?php echo esc_attr( $loop ); ?>]" id="subscrpt_signup_fee[<?php echo esc_attr( $loop ); ?>]" value="<?php echo esc_attr( $subscrpt_signup_fee ); ?>" />
			</p>
			
			
			<!-- Split Payment Fields (conditional) -->
			<div id="split_payment_fields_<?php echo esc_attr( $loop ); ?>" style="<?php echo ( $subscrpt_payment_type !== 'split_payment' ) ? 'display: none;' : ''; ?>">
				
				<div>
					<strong><?php esc_html_e( 'Split Payment', 'wp_subscription_pro' ); ?></strong>
					<p class="description"><?php esc_html_e( 'Control the split payment settings for this product.', 'wp_subscription_pro' ); ?></p>
				</div>
				<p class="form-field subscrpt_max_no_payment_split_field form-row form-row-full">
					<label for="subscrpt_max_no_payment_split[<?php echo esc_attr( $loop ); ?>]"><?php esc_html_e( 'Number of Payments', 'wp_subscription_pro' ); ?></label>
					<input type="number" class="short" name="subscrpt_max_no_payment_split[<?php echo esc_attr( $loop ); ?>]" id="subscrpt_max_no_payment_split[<?php echo esc_attr( $loop ); ?>]" value="<?php echo esc_attr( $subscrpt_payment_type === 'split_payment' ? $subscrpt_max_no_payment : 2 ); ?>" min="2" step="1" />
					<span class="description"><?php esc_html_e( 'Set how many installments this split payment will have. Must be greater than 1.', 'wp_subscription_pro' ); ?></span>
				</p>
				
				<p class="form-field subscrpt_access_ends_timing_field form-row form-row-full">
					<label for="subscrpt_access_ends_timing[<?php echo esc_attr( $loop ); ?>]"><?php esc_html_e( 'Access Ends Timing', 'wp_subscription_pro' ); ?></label>
					<select id="subscrpt_access_ends_timing[<?php echo esc_attr( $loop ); ?>]" name="subscrpt_access_ends_timing[<?php echo esc_attr( $loop ); ?>]" class="select short">
						<option value="lifetime" <?php selected( $subscrpt_access_ends_timing, 'lifetime' ); ?>><?php esc_html_e( 'Lifetime access after completion', 'wp_subscription_pro' ); ?></option>
						<option value="after_full_duration" <?php selected( $subscrpt_access_ends_timing, 'after_full_duration' ); ?>><?php esc_html_e( 'After full access duration (default)', 'wp_subscription_pro' ); ?></option>
						<option value="custom_duration" <?php selected( $subscrpt_access_ends_timing, 'custom_duration' ); ?>><?php esc_html_e( 'Custom access duration', 'wp_subscription_pro' ); ?></option>
					</select>
					<span class="description"><?php esc_html_e( 'Choose when access should end for split payment subscriptions.', 'wp_subscription_pro' ); ?></span>
				</p>
				
				<!-- Custom Access Duration fields (conditional) -->
				<div id="custom_duration_fields_<?php echo esc_attr( $loop ); ?>" style="<?php echo ( $subscrpt_access_ends_timing !== 'custom_duration' ) ? 'display: none;' : ''; ?>">
					<p class="form-field subscrpt_custom_access_duration_time_field form-row form-row-first">
						<label for="subscrpt_custom_access_duration_time[<?php echo esc_attr( $loop ); ?>]"><?php esc_html_e( 'Custom Access Duration', 'wp_subscription_pro' ); ?></label>
						<input type="number" class="short" name="subscrpt_custom_access_duration_time[<?php echo esc_attr( $loop ); ?>]" id="subscrpt_custom_access_duration_time[<?php echo esc_attr( $loop ); ?>]" value="<?php echo esc_attr( $subscrpt_custom_access_duration_time ); ?>" min="1" />
					</p>
					<p class="form-field subscrpt_custom_access_duration_type_field form-row form-row-last">
						<label for="subscrpt_custom_access_duration_type[<?php echo esc_attr( $loop ); ?>]">Type</label>
						<select id="subscrpt_custom_access_duration_type[<?php echo esc_attr( $loop ); ?>]" name="subscrpt_custom_access_duration_type[<?php echo esc_attr( $loop ); ?>]" class="postform">
				<?php foreach ( $timing_types as $timing_type ) : ?>
							<option value="<?php echo esc_attr( $timing_type['value'] ); ?>" <?php echo esc_attr( $timing_type['value'] === $subscrpt_custom_access_duration_type ? 'selected' : null ); ?>
							><?php echo esc_html( $timing_type['label'] ); ?></option>
				<?php endforeach; ?>
						</select>
					</p>
					<p class="form-field form-row form-row-full">
						<span class="description"><?php esc_html_e( 'Define how long access should continue after the first payment is completed.', 'wp_subscription_pro' ); ?></span>
					</p>
				</div>
			</div>
			

			
			<div>
				<strong><?php esc_html_e( 'Advanced Settings', 'wp_subscription_pro' ); ?></strong>
				<p class="description"><?php esc_html_e( 'These settings are for advanced users only.', 'wp_subscription_pro' ); ?></p>
			</div>
			
			<p class="form-field subscrpt_limit_field form-row form-row-full">
				<label for="subscrpt_limit[<?php echo esc_attr( $loop ); ?>]"><?php esc_html_e( 'Purchase Limit', 'wp_subscription_pro' ); ?></label>
				<select id="subscrpt_limit[<?php echo esc_attr( $loop ); ?>]" name="subscrpt_limit[<?php echo esc_attr( $loop ); ?>]" class="postform">
					<option value="unlimited"><?php esc_html_e( 'Do not limit', 'wp_subscription_pro' ); ?></option>
					<option value="one" <?php echo esc_attr( 'one' === $subscrpt_limit ? 'selected' : null ); ?>><?php esc_html_e( 'allow only one active subscription', 'wp_subscription_pro' ); ?></option>
					<option value="only_one" <?php echo esc_attr( 'only_one' === $subscrpt_limit ? 'selected' : null ); ?>><?php esc_html_e( 'allow only one subscription of any status', 'wp_subscription_pro' ); ?></option>
				</select>
			</p>

			<p class="form-field subscrpt_user_cancell_field form-row form-row-full">
				<label for="subscrpt_user_cancel[<?php echo esc_attr( $loop ); ?>]">Allow User Cancellation?</label>
				<select id="subscrpt_user_cancel[<?php echo esc_attr( $loop ); ?>]" name="subscrpt_user_cancel[<?php echo esc_attr( $loop ); ?>]" class="select short">
					<option value="yes">Yes</option>
					<option value="no" 
		<?php
		if ( 'no' === $subscrpt_user_cancel ) {
			echo 'selected';
		}
		?>
					>No</option>
				</select>
			</p>
		</div>
		
		<script type="text/javascript">
		jQuery(document).ready(function($) {
			// Add CSS to ensure proper visibility control
			if (!$('#subscrpt_variation_styles').length) {
				$('<style id="subscrpt_variation_styles">' +
					'.subscrpt-hidden { display: none !important; }' +
					'.subscrpt-visible { display: block !important; }' +
				'</style>').appendTo('head');
			}
			
			// Payment Type conditional logic for variation <?php echo esc_js( $loop ); ?>
			function togglePaymentTypeFields_<?php echo esc_js( $loop ); ?>(paymentType) {
				console.log('Toggling payment type fields for variation <?php echo esc_js( $loop ); ?>, type: ' + paymentType);
				var splitFieldsElement = $('#split_payment_fields_<?php echo esc_js( $loop ); ?>');
				console.log('Split fields element found:', splitFieldsElement.length > 0);
				console.log('Current payment type from PHP:', '<?php echo esc_js( $subscrpt_payment_type ); ?>');
				console.log('Max no payment from PHP:', '<?php echo esc_js( $subscrpt_max_no_payment ); ?>');
				
				if (paymentType === 'split_payment') {
					splitFieldsElement.removeClass('subscrpt-hidden').addClass('subscrpt-visible').show();
					console.log('Showing split payment fields for variation <?php echo esc_js( $loop ); ?>');
				} else {
					splitFieldsElement.removeClass('subscrpt-visible').addClass('subscrpt-hidden').hide();
					console.log('Hiding split payment fields for variation <?php echo esc_js( $loop ); ?>');
				}
			}
			
			// Access Ends Timing conditional logic for variation <?php echo esc_js( $loop ); ?>
			function toggleCustomDurationFields_<?php echo esc_js( $loop ); ?>(accessTiming) {
				console.log('Toggling custom duration fields for variation <?php echo esc_js( $loop ); ?>, timing: ' + accessTiming);
				var customFieldsElement = $('#custom_duration_fields_<?php echo esc_js( $loop ); ?>');
				
				if (accessTiming === 'custom_duration') {
					customFieldsElement.removeClass('subscrpt-hidden').addClass('subscrpt-visible').show();
					console.log('Showing custom duration fields for variation <?php echo esc_js( $loop ); ?>');
				} else {
					customFieldsElement.removeClass('subscrpt-visible').addClass('subscrpt-hidden').hide();
					console.log('Hiding custom duration fields for variation <?php echo esc_js( $loop ); ?>');
				}
			}
			
			// Make functions globally available
			window.togglePaymentTypeFields_<?php echo esc_js( $loop ); ?> = togglePaymentTypeFields_<?php echo esc_js( $loop ); ?>;
			window.toggleCustomDurationFields_<?php echo esc_js( $loop ); ?> = toggleCustomDurationFields_<?php echo esc_js( $loop ); ?>;
			
			// Event handlers with direct binding
			$(document).on('change', '#subscrpt_payment_type\\[<?php echo esc_js( $loop ); ?>\\]', function() {
				console.log('Payment type changed for variation <?php echo esc_js( $loop ); ?>:', $(this).val());
				togglePaymentTypeFields_<?php echo esc_js( $loop ); ?>($(this).val());
			});
			
			$(document).on('change', '#subscrpt_access_ends_timing\\[<?php echo esc_js( $loop ); ?>\\]', function() {
				console.log('Access timing changed for variation <?php echo esc_js( $loop ); ?>:', $(this).val());
				toggleCustomDurationFields_<?php echo esc_js( $loop ); ?>($(this).val());
			});
			
			// Initial toggle - run immediately and after a short delay for dynamic content
			function initializeFields() {
				var paymentTypeElement = $('#subscrpt_payment_type\\[<?php echo esc_js( $loop ); ?>\\]');
				var accessTimingElement = $('#subscrpt_access_ends_timing\\[<?php echo esc_js( $loop ); ?>\\]');
				
				var paymentType = paymentTypeElement.val() || '<?php echo esc_js( $subscrpt_payment_type ); ?>';
				var accessTiming = accessTimingElement.val() || '<?php echo esc_js( $subscrpt_access_ends_timing ); ?>';
				
				console.log('Initializing fields for variation <?php echo esc_js( $loop ); ?> - Payment Type:', paymentType, 'Access Timing:', accessTiming);
				console.log('Payment type element found:', paymentTypeElement.length > 0);
				console.log('Access timing element found:', accessTimingElement.length > 0);
				
				togglePaymentTypeFields_<?php echo esc_js( $loop ); ?>(paymentType);
				toggleCustomDurationFields_<?php echo esc_js( $loop ); ?>(accessTiming);
			}
			
			// Initialize immediately
			initializeFields();
			
			// Also initialize after a short delay for dynamic content
			setTimeout(initializeFields, 100);
			setTimeout(initializeFields, 500);
			
			// Re-initialize when WooCommerce reloads variation forms
			$(document).on('woocommerce_variations_loaded woocommerce_variations_added', function() {
				console.log('WooCommerce variations reloaded, reinitializing variation <?php echo esc_js( $loop ); ?>');
				setTimeout(initializeFields, 100);
			});
			
			// Debug function - can be called from browser console
			window.debugVariation<?php echo esc_js( $loop ); ?> = function() {
				console.log('=== Debug Info for Variation <?php echo esc_js( $loop ); ?> ===');
				console.log('Payment Type Element:', $('#subscrpt_payment_type\\[<?php echo esc_js( $loop ); ?>\\]').length > 0 ? 'Found' : 'NOT FOUND');
				console.log('Current Payment Type:', $('#subscrpt_payment_type\\[<?php echo esc_js( $loop ); ?>\\]').val());
				console.log('Split Fields Element:', $('#split_payment_fields_<?php echo esc_js( $loop ); ?>').length > 0 ? 'Found' : 'NOT FOUND');
				console.log('Split Fields Visible:', $('#split_payment_fields_<?php echo esc_js( $loop ); ?>').is(':visible'));
				console.log('Access Timing Element:', $('#subscrpt_access_ends_timing\\[<?php echo esc_js( $loop ); ?>\\]').length > 0 ? 'Found' : 'NOT FOUND');
				console.log('Current Access Timing:', $('#subscrpt_access_ends_timing\\[<?php echo esc_js( $loop ); ?>\\]').val());
				console.log('Custom Duration Fields Element:', $('#custom_duration_fields_<?php echo esc_js( $loop ); ?>').length > 0 ? 'Found' : 'NOT FOUND');
				console.log('Custom Duration Fields Visible:', $('#custom_duration_fields_<?php echo esc_js( $loop ); ?>').is(':visible'));
				console.log('=== End Debug Info ===');
				
				// Test the functions
				console.log('Testing toggle functions...');
				var currentPaymentType = $('#subscrpt_payment_type\\[<?php echo esc_js( $loop ); ?>\\]').val();
				togglePaymentTypeFields_<?php echo esc_js( $loop ); ?>(currentPaymentType);
				
				var currentAccessTiming = $('#subscrpt_access_ends_timing\\[<?php echo esc_js( $loop ); ?>\\]').val();
				toggleCustomDurationFields_<?php echo esc_js( $loop ); ?>(currentAccessTiming);
			};
			
			console.log('Debug function available: debugVariation<?php echo esc_js( $loop ); ?>()');
		});
		</script>
		<?php
	}

	/**
	 * Save variation form data
	 *
	 * @param int   $variation_id variation ID.
	 * @param mixed $i            Index.
	 */
	public function save_variable_data( $variation_id, $i ) {
		$subscrpt_enable       = isset( $_POST['subscrpt_enable'][ $i ] );
		$subscrpt_time         = sanitize_text_field( wp_unslash( $_POST['subscrpt_time'][ $i ] ) );
		$subscrpt_timing       = sanitize_text_field( wp_unslash( $_POST['subscrpt_timing'][ $i ] ) );
		$subscrpt_trial_time   = sanitize_text_field( wp_unslash( $_POST['subscrpt_trial_time'][ $i ] ) );
		$subscrpt_trial_timing = sanitize_text_field( wp_unslash( $_POST['subscrpt_trial_timing'][ $i ] ) );
		$subscrpt_cart_txt     = null;
		$subscrpt_user_cancel  = sanitize_text_field( wp_unslash( $_POST['subscrpt_user_cancel'][ $i ] ) );
		$subscrpt_signup_fee   = sanitize_text_field( wp_unslash( $_POST['subscrpt_signup_fee'][ $i ] ) );
		$subscrpt_limit        = sanitize_text_field( wp_unslash( $_POST['subscrpt_limit'][ $i ] ) );

		// New split payment fields
		$subscrpt_payment_type                = isset( $_POST['subscrpt_payment_type'][ $i ] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_payment_type'][ $i ] ) ) : 'recurring';
		$subscrpt_access_ends_timing          = isset( $_POST['subscrpt_access_ends_timing'][ $i ] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_access_ends_timing'][ $i ] ) ) : 'after_full_duration';
		$subscrpt_custom_access_duration_time = isset( $_POST['subscrpt_custom_access_duration_time'][ $i ] ) ? (int) sanitize_text_field( wp_unslash( $_POST['subscrpt_custom_access_duration_time'][ $i ] ) ) : 1;
		$subscrpt_custom_access_duration_type = isset( $_POST['subscrpt_custom_access_duration_type'][ $i ] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_custom_access_duration_type'][ $i ] ) ) : 'months';

		// Determine max_no_payment based on payment type
		if ( 'split_payment' === $subscrpt_payment_type ) {
			$subscrpt_max_no_payment = isset( $_POST['subscrpt_max_no_payment_split'][ $i ] ) ? (int) sanitize_text_field( wp_unslash( $_POST['subscrpt_max_no_payment_split'][ $i ] ) ) : 2;
		} else {
			// For recurring payments, set to 0 (unlimited) by default
			$subscrpt_max_no_payment = 0;
		}

		// Delivery fields.
		$subscrpt_delivery_timing_per           = isset( $_POST['subscrpt_delivery_timing_per'][ $i ] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_delivery_timing_per'][ $i ] ) ) : null;
		$subscrpt_delivery_timing_option        = isset( $_POST['subscrpt_delivery_timing_option'][ $i ] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_delivery_timing_option'][ $i ] ) ) : null;
		$subscrpt_synchronize_delivery_schedule = isset( $_POST['subscrpt_synchronize_delivery_schedule'][ $i ] ) ? 'yes' : 'no';
		$subscrpt_synchronize_delivery_day      = isset( $_POST['subscrpt_synchronize_delivery_day'][ $i ] ) ? sanitize_text_field( wp_unslash( $_POST['subscrpt_synchronize_delivery_day'][ $i ] ) ) : null;

		update_post_meta( $variation_id, '_subscrpt_enabled', $subscrpt_enable );
		update_post_meta( $variation_id, '_subscrpt_timing_per', $subscrpt_time );
		update_post_meta( $variation_id, '_subscrpt_timing_option', $subscrpt_timing );
		update_post_meta( $variation_id, '_subscrpt_trial_timing_per', $subscrpt_trial_time );
		update_post_meta( $variation_id, '_subscrpt_trial_timing_option', $subscrpt_trial_timing );
		update_post_meta( $variation_id, '_subscrpt_cart_btn_label', $subscrpt_cart_txt );
		update_post_meta( $variation_id, '_subscrpt_user_cancel', $subscrpt_user_cancel );
		update_post_meta( $variation_id, '_subscrpt_signup_fee', $subscrpt_signup_fee );
		update_post_meta( $variation_id, '_subscrpt_limit', $subscrpt_limit );
		update_post_meta( $variation_id, '_subscrpt_max_no_payment', $subscrpt_max_no_payment );

		// Save new split payment fields
		update_post_meta( $variation_id, '_subscrpt_payment_type', $subscrpt_payment_type );
		update_post_meta( $variation_id, '_subscrpt_access_ends_timing', $subscrpt_access_ends_timing );
		update_post_meta( $variation_id, '_subscrpt_custom_access_duration_time', $subscrpt_custom_access_duration_time );
		update_post_meta( $variation_id, '_subscrpt_custom_access_duration_type', $subscrpt_custom_access_duration_type );

		update_post_meta( $variation_id, '_subscrpt_delivery_timing_per', $subscrpt_delivery_timing_per );
		update_post_meta( $variation_id, '_subscrpt_delivery_timing_option', $subscrpt_delivery_timing_option );
		update_post_meta( $variation_id, '_subscrpt_synchronize_delivery_schedule', $subscrpt_synchronize_delivery_schedule );
		update_post_meta( $variation_id, '_subscrpt_synchronize_delivery_day', $subscrpt_synchronize_delivery_day );
	}

	/**
	 * Display convertation notice.
	 */
	public function display_convertation_notice() {
		if ( 'product' === get_post_type() ) :
			$product = wc_get_product( get_the_ID() );
			if ( $product->get_meta( '_subscrpt_product_covertation' ) && 'simple_to_variable' === $product->get_meta( '_subscrpt_product_covertation' ) ) :
				?>
					<div class="notice notice-warning">
						<p>Please set default variation for already subscribed users !</p>
					</div>
				<?php
			endif;
		endif;
	}

	/**
	 * Add delivery fields to variable product variations.
	 *
	 * @param mixed    $loop           loop.
	 * @param mixed    $variation_data variation_data.
	 * @param \WP_Post $variation      variation object.
	 */
	public function add_delivery_fields( $loop, $variation_data, $variation ) {
		$variation_id = $variation->ID;

		$subscrpt_delivery_timing_per           = get_post_meta( $variation_id, '_subscrpt_delivery_timing_per', true );
		$subscrpt_delivery_timing_option        = get_post_meta( $variation_id, '_subscrpt_delivery_timing_option', true );
		$subscrpt_synchronize_delivery_schedule = get_post_meta( $variation_id, '_subscrpt_synchronize_delivery_schedule', true );
		$subscrpt_synchronize_delivery_day      = get_post_meta( $variation_id, '_subscrpt_synchronize_delivery_day', true );
		?>
		<br>
		<div class="subscrpt_delivery_fields show_if_subscription_<?php echo esc_attr( $loop ); ?>">
			<div class="hide_if_variation_virtual">
			<div>
				<strong>Delivery Settings</strong>
			</div>
			<p class="form-field subscrpt_delivery_timing_per_field form-row form-row-first">
				<label for="subscrpt_delivery_timing_per[<?php echo esc_attr( $loop ); ?>]">Delivery schedule will every</label>
				<input type="number" class="short" name="subscrpt_delivery_timing_per[<?php echo esc_attr( $loop ); ?>]" id="subscrpt_delivery_timing_per[<?php echo esc_attr( $loop ); ?>]" value="<?php echo esc_html( $subscrpt_delivery_timing_per ); ?>" min="1" />
			</p>
			<p class="form-field subscrpt_delivery_timing_option_field form-row form-row-last">
				<label for="subscrpt_delivery_timing_option[<?php echo esc_attr( $loop ); ?>]">Type</label>
				<select id="subscrpt_delivery_timing_option[<?php echo esc_attr( $loop ); ?>]" name="subscrpt_delivery_timing_option[<?php echo esc_attr( $loop ); ?>]" class="postform">
				<?php foreach ( wps_subscription_get_timing_types() as $timing_type ) : ?>
					<option value="<?php echo esc_attr( $timing_type['value'] ); ?>" <?php echo esc_attr( $timing_type['value'] === $subscrpt_delivery_timing_option ? 'selected' : null ); ?>
					><?php echo esc_html( $timing_type['label'] ); ?></option>
				<?php endforeach; ?>
				</select>
			</p>
			<p class="form-field subscrpt_synchronize_delivery_schedule_field form-row form-row-full">
				<label for="subscrpt_synchronize_delivery_schedule[<?php echo esc_attr( $loop ); ?>]">
					<span style="margin-left: 2px;"><?php esc_html_e( 'Synchronize Schedule', 'wp_subscription_pro' ); ?></span>
					<input type="checkbox" class="checkbox" name="subscrpt_synchronize_delivery_schedule[<?php echo esc_attr( $loop ); ?>]" id="subscrpt_synchronize_delivery_schedule[<?php echo esc_attr( $loop ); ?>]" value="yes" <?php checked( $subscrpt_synchronize_delivery_schedule, 'yes' ); ?> />
				</label>
			</p>
			<p class="form-field subscrpt_synchronize_delivery_day_field form-row form-row-full" id="subscrpt_synchronize_delivery_day_field_<?php echo esc_attr( $loop ); ?>" style="display: <?php echo 'yes' === $subscrpt_synchronize_delivery_schedule ? 'block' : 'none'; ?>;">
				<label for="subscrpt_synchronize_delivery_day[<?php echo esc_attr( $loop ); ?>]"><?php esc_html_e( 'Sync Day', 'wp_subscription_pro' ); ?></label>
				<select id="subscrpt_synchronize_delivery_day[<?php echo esc_attr( $loop ); ?>]" name="subscrpt_synchronize_delivery_day[<?php echo esc_attr( $loop ); ?>]" class="select short">
					<?php
					$week_days = array(
						'Mon' => 'Monday',
						'Tue' => 'Tuesday',
						'Wed' => 'Wednesday',
						'Thu' => 'Thursday',
						'Fri' => 'Friday',
						'Sat' => 'Saturday',
						'Sun' => 'Sunday',
					);
					foreach ( $week_days as $key => $value ) {
						echo '<option value="' . esc_attr( $key ) . '"' . selected( $subscrpt_synchronize_delivery_day, $key, false ) . '>' . esc_html( $value ) . '</option>';
					}
					?>
				</select>
			</p>
			</div>
		</div>
		<script type="text/javascript">
			jQuery(function($) {
				$('#subscrpt_synchronize_delivery_schedule\\[<?php echo esc_js( $loop ); ?>\\]').change(function() {
					if ($(this).is(':checked')) {
						$('#subscrpt_synchronize_delivery_day_field_<?php echo esc_js( $loop ); ?>').show();
					} else {
						$('#subscrpt_synchronize_delivery_day_field_<?php echo esc_js( $loop ); ?>').hide();
					}
				});
			});
		</script>
		<?php
	}
}
