<?php

namespace SpringDevs\SubscriptionPro;

/**
 * Ajax class.
 */
class Ajax {

	/**
	 * Initialize the class.
	 */
	public function __construct() {
		add_action( 'wp_ajax_subscrpt_pro_handle_ajax', array( $this, 'handle_ajax' ) );
	}

	/**
	 * Handle AJAX requests
	 */
	public function handle_ajax() {
		$action_type = isset( $_POST['action_type'] ) ? sanitize_text_field( wp_unslash( $_POST['action_type'] ) ) : '';
		$nonce       = isset( $_POST['nonce'] ) ? sanitize_text_field( wp_unslash( $_POST['nonce'] ) ) : '';

		if ( ! wp_verify_nonce( $nonce, 'subscrpt_pro_ajax_nonce' ) ) {
			wp_send_json_error( __( 'Invalid nonce', 'wp_subscription_pro' ) );
		}

		switch ( $action_type ) {
			case 'regenerate_api_key':
				$this->regenerate_api_key();
				break;
			default:
				wp_send_json_error( __( 'Invalid action type', 'wp_subscription_pro' ) );
		}
	}

	/**
	 * Regenerate API key
	 */
	private function regenerate_api_key() {
		$api_key = wp_generate_password( 32, false );
		update_option( 'wpsubscription_api_key', $api_key );
		wp_send_json_success( array( 'api_key' => $api_key ) );
	}
}
