<?php

namespace SpringDevs\SubscriptionPro\Illuminate;

use SpringDevs\SubscriptionPro\Illuminate\Emails\PaymentFailure;
use SpringDevs\SubscriptionPro\Illuminate\Emails\RenewReminder;

/**
 * Class Email
 *
 * @package SpringDevs\SubscriptionPro\Illuminate
 */
class Email {

	/**
	 * The constructor method.
	 */
	public function __construct() {
		add_filter( 'woocommerce_email_classes', array( $this, 'register_pro_emails' ) );
	}

	/**
	 * Register pro emails.
	 *
	 * @param array $emails Email classes.
	 *
	 * @return array
	 */
	public function register_pro_emails( array $emails ): array {
		$emails['subscrpt_payment_failure'] = new PaymentFailure();
		$emails['subscrpt_renew_reminder']  = new RenewReminder();
		return $emails;
	}
}
