<?php
/**
 * Live QR Metabox View
 *
 * @package SubscriptionPro\Illuminate\LiveQR\views
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// Add Tailwind CSS
subscrpt_pro_include_tailwind_css();

?>

<div class="wpsubs-pro-tw-root">
	<img id="wpsubs_qr_image" src="<?php echo esc_attr( $qr_image ); ?>" alt="Subscription Live QR Code" />

	<div class="divider">Actions</div>

	<div class="flex flex-wrap gap-3">
		<button class="grow button button-primary" id="wpsubs_download_qr">Download QR</button>

		<div 
			class="tooltip tooltip-warning tooltip-left" 
			data-tip="<?php echo esc_attr_e( 'Clean cache and regenerate the QR code', 'wp_subscription_pro' ); ?>"
		>
			<button class="grow button button-primary" id="wpsubs_regenerate_qr">Regenerate QR</button>
		</div>

		<button class="grow button button-primary" id="wpsubs_send_qr">Send in Email</button>
	</div> 
</div>

<!-- Download Script -->
<script>
document.getElementById('wpsubs_download_qr').addEventListener('click', function (e) {
	e.preventDefault();

	const img = document.getElementById('wpsubs_qr_image');
	const canvas = document.createElement('canvas');
	const ctx = canvas.getContext('2d');
	const image = new Image();

	image.onload = function() {
		const scale = 4; // increase this for higher resolution
		const canvas = document.createElement('canvas');
		const ctx = canvas.getContext('2d');

		// Use natural size from SVG if available, else fallback
		const width = image.naturalWidth || 200;
		const height = image.naturalHeight || 200;

		canvas.width = width * scale;
		canvas.height = height * scale;

		ctx.drawImage(image, 0, 0, canvas.width, canvas.height);

		// Generate a PNG data URL from the canvas
		const pngData = canvas.toDataURL('image/png');

		const link = document.createElement('a');
		link.href = pngData;
		link.download = 'Subscription_<?php echo esc_js( $subscription_id ); ?>_QR.png';
		link.click();
	};

	// Important: ensure cross-origin safe
	image.src = img.src;
});

document.getElementById('wpsubs_regenerate_qr').addEventListener('click', function (e) {
	e.preventDefault();

	jQuery.ajax({
		url: ajaxurl,
		method: 'POST',
		data: {
			action: 'wpsubs_regenerate_qr',
			nonce: '<?php echo esc_js( wp_create_nonce( 'wpsubs_live_qr' ) ); ?>',
			subscription_id: <?php echo esc_js( $subscription_id ); ?>,
		},
		success: function (response) {
			if (response.success && response.data.qr_image) {
				alert('QR code regenerated successfully!');
				
				document.getElementById('wpsubs_qr_image').src = response.data.qr_image;
			} else {
				alert('Failed to regenerate QR code.');
			}
		},
		error: function (xhr, status, error) {
			console.error('AJAX request failed:', status, error);
			alert('Failed to regenerate QR code. Server Error!');
		}
	});
});

document.getElementById('wpsubs_send_qr').addEventListener('click', function (e) {
	e.preventDefault();

	alert('We are working on this feature and it will be available soon!');
});
</script>
