<?php
/**
 * Live QR Settings View
 *
 * @package SubscriptionPro\Illuminate\LiveQR\views
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<tr>
	<th scope="row" colspan="2">
		<h2><?php esc_html_e( 'Quick Details QR Settings', 'wp_subscription_pro' ); ?></h2>
	</th>
</tr>

<tr valign="top">
	<th scope="row" class="titledesc"><?php echo esc_html_e( 'Product Details', 'wp_subscription_pro' ); ?></th>
	<td class="forminp forminp-checkbox">
		<fieldset>
			<legend class="screen-reader-text"><span><?php echo esc_html_e( 'Product Details', 'wp_subscription_pro' ); ?></span></legend>
			<label for="subscrpt_live_qr_show_product">
				<input 
					class="wp-subscription-toggle" 
					name="subscrpt_live_qr_show_product" 
					id="subscrpt_live_qr_show_product" 
					type="checkbox" 
					value="1" 
					<?php checked( get_option( 'subscrpt_live_qr_show_product', '1' ), '1' ); ?>
				>
				<span class="wp-subscription-toggle-ui" aria-hidden="true"></span>

				<?php echo esc_html_e( 'Show product details in the subscription quick view', 'wp_subscription_pro' ); ?>
			</label>
		</fieldset>
	</td>
</tr>

<tr valign="top">
	<th scope="row" class="titledesc"><?php echo esc_html_e( 'Billing Details', 'wp_subscription_pro' ); ?></th>
	<td class="forminp forminp-checkbox">
		<fieldset>
			<legend class="screen-reader-text"><span><?php echo esc_html_e( 'Billing Details', 'wp_subscription_pro' ); ?></span></legend>
			<label for="subscrpt_live_qr_show_billing">
				<input 
					class="wp-subscription-toggle" 
					name="subscrpt_live_qr_show_billing" 
					id="subscrpt_live_qr_show_billing" 
					type="checkbox" 
					value="1" 
					<?php checked( get_option( 'subscrpt_live_qr_show_billing', '0' ), '1' ); ?>
				>
				<span class="wp-subscription-toggle-ui" aria-hidden="true"></span>

				<?php echo esc_html_e( 'Show billing details in the subscription quick view', 'wp_subscription_pro' ); ?>
			</label>
		</fieldset>
	</td>
</tr>

<tr valign="top">
	<th scope="row" class="titledesc"><?php echo esc_html_e( 'Timeline', 'wp_subscription_pro' ); ?></th>
	<td class="forminp forminp-checkbox">
		<fieldset>
			<legend class="screen-reader-text"><span><?php echo esc_html_e( 'Timeline', 'wp_subscription_pro' ); ?></span></legend>
			<label for="subscrpt_live_qr_show_timeline">
				<input 
					class="wp-subscription-toggle" 
					name="subscrpt_live_qr_show_timeline" 
					id="subscrpt_live_qr_show_timeline" 
					type="checkbox" 
					value="1" 
					<?php checked( get_option( 'subscrpt_live_qr_show_timeline', '0' ), '1' ); ?>
				>
				<span class="wp-subscription-toggle-ui" aria-hidden="true"></span>

				<?php echo esc_html_e( 'Show subscription timeline in the subscription quick view', 'wp_subscription_pro' ); ?>
			</label>
		</fieldset>
	</td>
</tr>
