<?php

namespace SpringDevs\SubscriptionPro\Illuminate;

/**
 * Class Subscription
 *
 * @package SpringDevs\SubscriptionPro\Illuminate
 */
class Subscription {

	/**
	 * Initialize the class
	 */
	public function __construct() {
		add_filter( 'subscrpt_order_relational_types', array( $this, 'filter_relational_types' ) );
	}

	/**
	 * Register new key-value for cast.
	 *
	 * @param array $types - Types with key value.
	 *
	 * @return array
	 */
	public function filter_relational_types( array $types ) {
		$types['early-renew'] = __( 'Early Renewal Order', 'wp_subscription_pro' );

		$types['upgrade']   = __( 'Subscription Upgrade Order', 'wp_subscription_pro' );
		$types['downgrade'] = __( 'Subscription Downgrade Order', 'wp_subscription_pro' );
		return $types;
	}
}
