<?php

namespace SpringDevs\SubscriptionPro\Utils;

use SpringDevs\Subscription\Utils\Product;
use SpringDevs\SubscriptionPro\Illuminate\Helper;

class VariableProduct extends Product {

	public function get_timing_per(): int {
		return max( (int) $this->product->get_meta( '_subscrpt_timing_per' ), 1 );
	}

	public function has_trial(): bool {
		$trial_timing_per = $this->get_trial_timing_per();
		$product_id       = $this->product->get_id();

		return ( $trial_timing_per > 0 ) && Helper::check_trial( $product_id );
	}

	public function get_signup_fee(): int {
		return (int) $this->product->get_meta( '_subscrpt_signup_fee' );
	}
}
