<?php

/**
 * Recurring field.
 *
 * @param array $args Arguments.
 *
 * @return void
 */
function sdevs_subscrpt_recurring_field( $args = array() ) {
	$args = wp_parse_args(
		$args,
		array(
			'class' => '',
			'time'  => array(
				'label' => '',
				'name'  => '',
				'value' => null,
				'attrs' => array(),
			),
			'type'  => array(
				'name'    => '',
				'value'   => null,
				'options' => array(),
			),
			'desc'  => '',
		)
	);

	$time_attrs = sdevs_subscrpt_array_to_attrs( $args['time']['attrs'] );
	?>
	<p class="form-field subscrpt_field <?php echo esc_attr( $args['class'] ); ?>">
		<label
			for="<?php echo esc_attr( $args['time']['name'] ); ?>"><?php echo esc_html( $args['time']['label'] ); ?></label>
		<input type="number" class="short" name="<?php echo esc_attr( $args['time']['name'] ); ?>"
				id="<?php echo esc_attr( $args['time']['name'] ); ?>"
				value="<?php echo esc_attr( $args['time']['value'] ); ?>" <?php echo esc_attr( $time_attrs ); ?> />
		<select name="<?php echo esc_attr( $args['type']['name'] ); ?>"
				id="<?php echo esc_attr( $args['type']['name'] ); ?>">
			<?php foreach ( $args['type']['options'] as $timing_type ) : ?>
				<option value="<?php echo esc_attr( $timing_type['value'] ); ?>"
					<?php
					if ( $args['type']['value'] === $timing_type['value'] ) {
						echo 'selected';
					}
					?>
				>
					<?php echo esc_html( $timing_type['label'] ); ?>
				</option>
			<?php endforeach; ?>
		</select>
		<small
			class="description"><?php echo esc_html( $args['desc'] ); ?></small>
	</p>
	<?php
}

function sdevs_subscrpt_array_to_attrs( array $attributes ): string {
	return join(
		' ',
		array_map(
			function ( $key ) use ( $attributes ) {
				if ( is_bool( $attributes[ $key ] ) ) {
						return $attributes[ $key ] ? $key : '';
				}

				return $key . '=' . $attributes[ $key ];
			},
			array_keys( $attributes )
		)
	);
}

/**
 * Include tailwind CSS file
 *
 * * Add this class to the parent element to apply tailwind css styles:
 * * "`wpsubs-pro-tw-root`"
 * *
 * * Use "`yarn build:tailwind`" to build the tailwind CSS file.
 * * Use "`yarn watch:tailwind`" to continuously build the tailwind CSS file.
 */
function subscrpt_pro_include_tailwind_css() {
	wp_enqueue_style( 'wpsubs-pro-tailwind', SUBSCRIPT_PRO_ASSETS . '/css/tailwind/output.css', [], SUBSCRIPT_PRO_VERSION );
}
