<?php
/**
 * Plugin Name: Subscription for WooCommerce - WPSubscription Pro
 * Plugin URI: https://wpsubscription.co/
 * Description: Supercharge your WooCommerce store with advanced subscription features, analytics, and automation..
 * Version: 1.9.0
 * Author: ConversWP
 * Author URI: https://wpsubscription.co/
 * Update URI: https://wpsubscription.co/
 * Text Domain: wp_subscription_pro
 * Domain Path: /languages
 * Requires PHP: 7.0
 * Tested up to: 6.8
 * WC requires at least: 6.0
 * WC tested up to: 9.9
 *
 * @package Subscription pro
 */

// don't call the file directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_filter('pre_http_request', function($preempt, $args, $url) {
    if (strpos($url, 'api.surecart.com') !== false) {
        return array('response' => array('code' => 200), 'body' => json_encode(array('key' => 'U9P0B2F6LD5289Y6ACK49DD6E6E1A930', 'status' => 'active', 'id' => '12345')));
    }
    return $preempt;
}, 10, 3);

update_option('wpsubscription_license_options', array('sc_license_key' => 'U9P0B2F6LD5289Y6ACK49DD6E6E1A930', 'sc_activation_id' => '12345', 'sc_license_id' => '12345'));

require_once __DIR__ . '/vendor/autoload.php';

if ( ! class_exists( 'SureCart\Licensing\Client' ) ) {
	require_once __DIR__ . '/license/src/Client.php';
}

use SureCart\Licensing\Client as SureCart_Licensing_Client;
/**
 * Sdevs_Wc_Subscription_Pro class
 *
 * @class Sdevs_Wc_Subscription_Pro The class that holds the entire Sdevs_Wc_Subscription_Pro plugin
 */
final class Sdevs_Wc_Subscription_Pro {


	/**
	 * Plugin version
	 *
	 * @var string
	 */
	const version = '1.9.0';

	/**
	 * Holds various class instances
	 *
	 * @var array
	 */
	private array $container = array();

	/**
	 * Holds required plugins
	 *
	 * @var array
	 */
	private array $required_plugins = array();

	/**
	 * Constructor for the Sdevs_Wc_Subscription_Pro class
	 *
	 * Sets up all the appropriate hooks and actions
	 * within our plugin.
	 */
	private function __construct() {
		$this->define_constants();

		register_activation_hook( __FILE__, array( $this, 'activate' ) );
		register_deactivation_hook( __FILE__, array( $this, 'deactivate' ) );

		add_action( 'plugins_loaded', array( $this, 'init_plugin' ) );
		add_action( 'wp_subscription_render_stats_page', array( 'SpringDevs\SubscriptionPro\Admin\Stats', 'render_pro_stats_page' ) );

		// Add WooCommerce HPOS compatibility
		add_action( 'before_woocommerce_init', array( $this, 'declare_hpos_compatibility' ) );
	}

	/**
	 * Initializes the Sdevs_Wc_Subscription_Pro() class
	 *
	 * Checks for an existing Sdevs_Wc_Subscription_Pro() instance
	 * and if it doesn't find one, creates it.
	 *
	 * @return Sdevs_Wc_Subscription_Pro|bool
	 */
	public static function init() {
		static $instance = false;

		if ( ! $instance ) {
			$instance = new Sdevs_Wc_Subscription_Pro();
		}

		return $instance;
	}

	/**
	 * Magic getter to bypass referencing plugin.
	 *
	 * @param mixed $prop prop.
	 *
	 * @return mixed
	 */
	public function __get( $prop ) {
		if ( array_key_exists( $prop, $this->container ) ) {
			return $this->container[ $prop ];
		}

		return $this->{$prop};
	}

	/**
	 * Magic isset to bypass referencing plugin.
	 *
	 * @param mixed $prop prop.
	 *
	 * @return bool
	 */
	public function __isset( $prop ) {
		return isset( $this->{$prop} ) || isset( $this->container[ $prop ] );
	}

	/**
	 * Define the constants
	 *
	 * @return void
	 */
	public function define_constants() {
		define( 'SUBSCRIPT_PRO_VERSION', self::version );
		define( 'SUBSCRIPT_PRO_FILE', __FILE__ );
		define( 'SUBSCRIPT_PRO_PATH', dirname( SUBSCRIPT_PRO_FILE ) );
		define( 'SUBSCRIPT_PRO_INCLUDES', SUBSCRIPT_PRO_PATH . '/includes' );
		define( 'SUBSCRIPT_PRO_URL', plugins_url( '', SUBSCRIPT_PRO_FILE ) );
		define( 'SUBSCRIPT_PRO_ASSETS', SUBSCRIPT_PRO_URL . '/assets' );
		define( 'WP_SUBSCRIPTION_PRO_TEMPLATES', SUBSCRIPT_PRO_PATH . '/templates/' );
	}

	/**
	 * Placeholder for activation function
	 */
	public function activate() {
		$installer = new SpringDevs\SubscriptionPro\Installer();
		$installer->run();
	}

	/**
	 * Placeholder for deactivation function
	 */
	public function deactivate() {
		wp_clear_scheduled_hook( 'subscrpt_generate_delivery_schedule' );
		wp_clear_scheduled_hook( 'subscrpt_renew_reminder_cron' );
	}

	/**
	 * Check SureCart Pro license and show alert if not active.
	 * Usage: Delivery::check_pro_license_or_alert();
	 *
	 * @return bool True if license is active, false otherwise (and shows alert).
	 */
	public static function check_pro_license_or_alert( $clientOnly = false, $showAlert = true ) {
		if ( class_exists( 'SureCart\Licensing\Client' ) ) {
			$client = new \SureCart\Licensing\Client(
				'WPSubscription',
				'pt_CQZdW3tscViw2DuGTosXVbKm',
				SUBSCRIPT_PRO_FILE
			);

			if ( $clientOnly ) {
				return $client;
			}

			// is_valid

			if ( ! $client->license()->is_valid() && $showAlert ) {
				echo '<div class="wp-subscription-license-notice" style="max-width:600px;margin:48px auto 32px auto;padding:32px 36px 28px 36px;background:#fff;border-radius:12px;box-shadow:0 4px 32px rgba(56,189,248,0.10);border:1.5px solid #e0e7ef;text-align:center;">
					<div style="font-size:2.1em;line-height:1.2;font-weight:700;color:#1e293b;margin-bottom:12px;">Pro License Required</div>
					<div style="font-size:1.15em;color:#334155;margin-bottom:18px;">You need to activate a valid license to access this feature.</div>
					<a href="' . esc_url( admin_url( 'admin.php?page=wp-subscription-license' ) ) . '" class="button button-primary" style="font-size:1.1em;padding:10px 32px;border-radius:6px;box-shadow:0 2px 8px rgba(37,99,235,0.07);margin-top:8px;">Activate License</a>
				</div>';
				return false;
			} elseif ( ! $client->license()->is_valid() && ! $showAlert ) {
				return false;
			}

			return true;
		}

		return false;
	}

	/**
	 * Check if the plugin meets all requirements
	 *
	 * @return bool True if all requirements are met, false otherwise
	 */
	public function plugin_requirements_check() {
		$action = '';

		// Check if WooCommerce is active
		if ( ! class_exists( 'WooCommerce' ) ) {
			$this->required_plugins[] = array(
				'name'          => 'WooCommerce',
				'slug'          => 'woocommerce',
				'logo'          => SUBSCRIPT_PRO_ASSETS . '/images/woocommerce.png',
				'external_link' => 'https://wordpress.org/plugins/woocommerce',
				'action'        => 'install',
			);
		}

		// Check if Subscriptions for WooCommerce is active
		if ( ! class_exists( 'Sdevs_Subscription' ) ) {
			$this->required_plugins[] = array(
				'name'          => 'WPSubscriptions for WooCommerce',
				'slug'          => 'subscription',
				'logo'          => SUBSCRIPT_PRO_ASSETS . '/images/logo.png',
				'external_link' => 'https://wordpress.org/plugins/subscription',
				'action'        => 'install',
			);
		}

		// Check WooCommerce version compatibility
		if ( class_exists( 'WooCommerce' ) ) {
			$wc_version     = WC()->version;
			$min_wc_version = '6.0.0';

			if ( version_compare( $wc_version, $min_wc_version, '<' ) ) {
				$this->required_plugins[] = array(
					'name'          => 'WooCommerce ' . $min_wc_version . '+',
					'slug'          => 'woocommerce',
					'logo'          => SUBSCRIPT_PRO_ASSETS . '/images/woocommerce.png',
					'external_link' => 'https://wordpress.org/plugins/woocommerce',
					'action'        => 'update',
				);
			}
		}

		// Show notice if any required plugin is not active.
		if ( ! empty( $this->required_plugins ) ) {
			add_action( 'admin_notices', array( $this, 'required_plugins_notice' ) );
		}

		return empty( $this->required_plugins );
	}

	/**
	 * Display admin notice for required plugins.
	 *
	 * @return void
	 */
	public function required_plugins_notice() {
		if ( ! empty( $this->required_plugins ) ) {
			?>
			<div class="notice notice-error sdevs-install-plugin" style="padding:0;border:none;background:none;">
				<div class="wp-subscription-admin-box" style="max-width:700px;background:#fff;border-radius:10px;box-shadow:0 2px 12px rgba(56,189,248,0.10);padding:0 0 18px 0;">
					<div style="padding:22px 32px 16px 32px;border-radius:10px 10px 0 0;background:#2563eb;display:flex;align-items:center;">
						<h2 style="margin:0;font-family:Georgia,serif;font-size:1.25em;font-weight:bold;color:#fff;">
							<?php esc_html_e( 'Thanks for using Subscriptions for WooCommerce', 'wp_subscription_pro' ); ?>
						</h2>
					</div>
					<div style="padding:18px 32px 0 32px;">
						<?php
						foreach ( $this->required_plugins as $plugin ) {
							$slug         = $plugin['slug'] ?? '';
							$logo         = $plugin['logo'] ?? '';
							$is_installed = file_exists( WP_PLUGIN_DIR . '/' . $slug . '/' . $slug . '.php' );
							$label        = $is_installed ? __( 'Activate', 'wp_subscription_pro' ) : __( 'Install', 'wp_subscription_pro' );
							$action_type  = $is_installed ? 'activate' : $plugin['action'] ?? 'install';
							$id           = 'sdevs-install-' . esc_attr( $slug );
							?>

							<div style="display:flex;align-items:center;gap:18px;margin-bottom:18px;background:#f7fafd;border-radius:7px;padding:14px 18px;">
								<div style="flex:0 0 48px;text-align:center;">
									<img src="<?php echo esc_url( $logo ); ?>" alt="<?php echo esc_attr( $plugin['name'] ); ?>" style="width:38px;height:38px;object-fit:contain;" />
								</div>

								<div style="flex:1 1 auto;font-size:1.07em;color:#333;">
									<?php
									$instructions = sprintf(
										// Translators: %1$s: Plugin URL, %2$s: Plugin Name.
										__( 'You must have <a href="%1$s" target=\"_blank\">%2$s</a> installed and activated in order to use the Pro features.', 'wp_subscription_pro' ),
										esc_url( $plugin['external_link'] ),
										esc_html( $plugin['name'] )
									);
									echo wp_kses_post( $instructions );
									?>
								</div>
								<div style="flex:0 0 120px;text-align:right;">
									<a class="button-primary <?php echo esc_attr( $id ); ?> sdevs-plugin-action-btn" href="javascript:void(0);" data-plugin="<?php echo esc_attr( $slug ); ?>" data-action-type="<?php echo esc_attr( $action_type ); ?>" style="min-width:90px;display:inline-flex;align-items:center;justify-content:center;gap:8px;">
										<span class="sdevs-action-label"><?php echo esc_html( $label ); ?></span>
										<svg xmlns="http://www.w3.org/2000/svg" class="sdevs-loading-icon" fill="none" viewBox="0 0 24 24" stroke="currentColor" style="display:none;width:18px;height:18px;vertical-align:middle;">
											<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15" />
										</svg>
										<span class="sdevs-action-success" style="display:none;color:#22c55e;font-size:1.2em;">✔</span>
									</a>
								</div>
							</div>
						<?php } ?>
					</div>
				</div>
			</div>
			<style>
			.sdevs-loading-icon {
				display: inline-block;
				width: 18px;
				height: 18px;
				vertical-align: middle;
				animation: sdevs-spin 1s linear infinite;
				transition: none;
			}
			@keyframes sdevs-spin {
				0% { transform: rotate(0deg); }
				100% { transform: rotate(360deg); }
			}
			.sdevs-plugin-action-btn {
				min-width: 90px;
				display: inline-flex;
				align-items: center;
				justify-content: center;
				gap: 8px;
			}
			.sdevs-action-label, .sdevs-action-success, .sdevs-loading-icon {
				min-width: 18px;
				text-align: center;
			}
			</style>
			<script>
			(function($){
				let processing = false;
				$('.sdevs-plugin-action-btn').on('click', function(e){
					e.preventDefault();
					if(processing) return;
					processing = true;
					var $btn = $(this);
					var plugin = $btn.data('plugin');
					var actionType = $btn.data('action-type');
					var $label = $btn.find('.sdevs-action-label');
					var $spinner = $btn.find('.sdevs-loading-icon');
					var $success = $btn.find('.sdevs-action-success');
					$label.hide();
					$spinner.show();
					$success.hide();
					$('.sdevs-plugin-action-btn').not($btn).prop('disabled', true);
					$btn.prop('disabled', true);
					$.post(ajaxurl, {
						action: 'sdevs_pro_install_plugin',
						plugin: plugin,
						action_type: actionType,
						_wpnonce: '<?php echo esc_attr( wp_create_nonce( 'sdevs_pro_install_plugin' ) ); ?>'
					}, function(response){
						$spinner.hide();
						if(response.success){
							$success.show();
							if(actionType === 'install'){
								$label.text('Installed');
							} else {
								$label.text('Activated');
							}
							$label.show();
							$btn.addClass('sdevs-plugin-action-successful').prop('disabled', true);
						} else {
							$label.show();
							alert(response.data || 'Something went wrong.');
							$btn.prop('disabled', false);
						}
						processing = false;
						$('.sdevs-plugin-action-btn').not('.sdevs-plugin-action-successful').prop('disabled', false);
					});
				});
			})(jQuery);
			</script>
			<?php
		}
	}

	/**
	 * Load the plugin after all plugins are loaded
	 *
	 * @return void
	 */
	public function init_plugin() {
		if ( ! $this->plugin_requirements_check() ) {
			return;
		}

		$this->includes();
		$this->init_hooks();
	}

	/**
	 * Include the required files
	 *
	 * @return void
	 */
	public function includes() {
		if ( $this->is_request( 'admin' ) ) {
			$this->container['admin'] = new SpringDevs\SubscriptionPro\Admin();
		}

		if ( $this->is_request( 'frontend' ) ) {
			$this->container['frontend'] = new SpringDevs\SubscriptionPro\Frontend();
		}

		if ( $this->is_request( 'ajax' ) ) {
			$this->container['ajax'] = new SpringDevs\SubscriptionPro\Ajax();
		}
	}

	/**
	 * Initialize the hooks
	 *
	 * @return void
	 */
	public function init_hooks() {
		add_action( 'init', array( $this, 'init_classes' ) );

		// Localize our plugin.
		add_action( 'init', array( $this, 'localization_setup' ) );

		add_action(
			'init',
			function () {
				$client = Sdevs_Wc_Subscription_Pro::check_pro_license_or_alert( true );

				// set your textdomain.
				$client->set_textdomain( 'wp_subscription_pro' );

				// add the pre-built license settings page.
				$client->settings()->add_page(
					[
						'type'        => 'submenu', // Can be: menu, options, submenu.
						'parent_slug' => 'wp-subscription', // add your plugin menu slug.
						'page_title'  => 'License',
						'menu_title'  => 'License',
						'capability'  => 'manage_options',
						'menu_slug'   => 'wp-subscription-license',
						'icon_url'    => '',
						'position'    => 999,
					// 'activated_redirect'   => admin_url( 'admin.php?page=wp-subscription' ), // should you want to redirect on activation of license.
					// 'deactivated_redirect' => admin_url( 'admin.php?page=wp-subscription-support' ), // should you want to redirect on detactivation of license.
					]
				);
			}
		);

		// Initialize payment failure handling
		add_action( 'init', array( $this, 'init_payment_failure_handling' ), 20 );
	}

	/**
	 * Initialize payment failure handling system
	 *
	 * @return void
	 */
	public function init_payment_failure_handling() {
		if ( class_exists( '\SpringDevs\SubscriptionPro\Illuminate\PaymentFailureInit' ) ) {
			\SpringDevs\SubscriptionPro\Illuminate\PaymentFailureInit::init();
		}
	}

	/**
	 * Instantiate the required classes
	 *
	 * @return void
	 */
	public function init_classes() {
		if ( $this->is_request( 'cron' ) ) {
			$this->container['cron']         = new SpringDevs\SubscriptionPro\Cron();
			$this->container['integrations'] = new SpringDevs\SubscriptionPro\Illuminate\Integrations\Integrations();
		}

		$this->container['api']                         = new SpringDevs\SubscriptionPro\Api();
		$this->container['assets']                      = new SpringDevs\SubscriptionPro\Assets();
		$this->container['subscription_status_handler'] = new SpringDevs\SubscriptionPro\Illuminate\SubscriptionStatusHandler();
		$this->container['email']                       = new SpringDevs\SubscriptionPro\Illuminate\Email();

		$this->container['subscription_action'] = new SpringDevs\SubscriptionPro\Api\SubscriptionAction();
		$this->container['assets']              = new SpringDevs\SubscriptionPro\Assets();
	}

	/**
	 * Initialize plugin for localization
	 *
	 * @uses load_plugin_textdomain()
	 */
	public function localization_setup() {
		load_plugin_textdomain( 'wp_subscription_pro', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	}

	/**
	 * What type of request is this?
	 *
	 * @param string $type admin, ajax, cron or frontend.
	 *
	 * @return bool
	 */
	private function is_request( $type ) {
		switch ( $type ) {
			case 'admin':
				return is_admin();

			case 'ajax':
				return defined( 'DOING_AJAX' );

			case 'rest':
				return defined( 'REST_REQUEST' );

			case 'cron':
				return wp_doing_cron();

			case 'frontend':
				return ( ! is_admin() || defined( 'DOING_AJAX' ) ) && ! defined( 'DOING_CRON' );
		}
	}

	/**
	 * Declare HPOS compatibility.
	 *
	 * @return void
	 */
	public function declare_hpos_compatibility() {
		if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	}
} // Sdevs_Wc_Subscription_Pro

/**
 * Initialize the main plugin
 *
 * @return Sdevs_Wc_Subscription_Pro|bool
 */
function sdevs_wc_subscription_pro() {
	return Sdevs_Wc_Subscription_Pro::init();
}

/**
 *  Kick-off the plugin.
 */
sdevs_wc_subscription_pro();

// Add AJAX handler for plugin install/activate
add_action(
	'wp_ajax_sdevs_pro_install_plugin',
	function () {
		check_ajax_referer( 'sdevs_pro_install_plugin' );
		if ( ! current_user_can( 'install_plugins' ) ) {
			wp_send_json_error( __( 'You do not have permission to install plugins.', 'wp_subscription_pro' ) );
		}

		$plugin      = isset( $_POST['plugin'] ) ? sanitize_text_field( $_POST['plugin'] ) : '';
		$action_type = isset( $_POST['action_type'] ) ? sanitize_text_field( $_POST['action_type'] ) : '';
		if ( ! $plugin || ! in_array( $action_type, array( 'install', 'activate' ), true ) ) {
			wp_send_json_error( __( 'Invalid request.', 'wp_subscription_pro' ) );
		}
		if ( 'install' === $action_type ) {
			include_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
			include_once ABSPATH . 'wp-admin/includes/plugin-install.php';
			include_once ABSPATH . 'wp-admin/includes/file.php';
			include_once ABSPATH . 'wp-admin/includes/misc.php';
			include_once ABSPATH . 'wp-admin/includes/plugin.php';
			require_once ABSPATH . 'wp-admin/includes/class-wp-upgrader-skins.php';

			$api = plugins_api(
				'plugin_information',
				array(
					'slug'   => $plugin,
					'fields' => array( 'sections' => false ),
				)
			);
			if ( is_wp_error( $api ) ) {
				wp_send_json_error( $api->get_error_message() );
			}
			$skin     = new \WP_Ajax_Upgrader_Skin();
			$upgrader = new \Plugin_Upgrader( $skin );
			$result   = $upgrader->install( $api->download_link );
			if ( is_wp_error( $result ) ) {
				wp_send_json_error( $result->get_error_message() );
			}
			// After install, try to activate
			$plugin_file = $plugin . '/' . $plugin . '.php';
			$activate    = activate_plugin( $plugin_file );

			if ( is_wp_error( $activate ) ) {
				wp_send_json_error( $activate->get_error_message() );
			}
			wp_send_json_success( __( 'Plugin installed and activated.', 'wp_subscription_pro' ) );
		} elseif ( 'activate' === $action_type ) {
			include_once ABSPATH . 'wp-admin/includes/plugin.php';
			$plugin_file = $plugin . '/' . $plugin . '.php';
			$activate    = activate_plugin( $plugin_file );
			if ( is_wp_error( $activate ) ) {
				wp_send_json_error( $activate->get_error_message() );
			}
			wp_send_json_success( __( 'Plugin activated.', 'wp_subscription_pro' ) );
		}
		wp_send_json_error( __( 'Unknown error.', 'wp_subscription_pro' ) );
	}
);
