<?php
/**
 * Printable Delivery Schedule template
 *
 * Expects variables from caller:
 *
 * $store_info (array) Store informations
 * - $name (string) Store name
 * - $address (string) Store address + address line 2
 * - $city (string) Store city
 * - $postcode (string) Store postcode
 * - $country (string) Store country
 *
 * $deliveries (array) Delivery informations
 * $generated_at (string) Generated at date time string
 */
?>

<!DOCTYPE html>
<html>
<head>
	<meta charset="<?php echo esc_attr( get_option( 'blog_charset' ) ); ?>">
	<meta name="robots" content="noindex,nofollow">
	<title><?php esc_html_e( 'Printable Delivery Schedule', 'wp_subscription_pro' ); ?></title>
	<style>
		*{margin:0;padding:0;box-sizing:border-box}body{font-family:Arial,sans-serif;font-size:11px;line-height:1.3;color:#000;background:#fff;padding:15px}.header{margin-bottom:20px;border-bottom:1px dashed #333;padding-bottom:10px;display:flex;justify-content:space-between;align-items:flex-start}.company-info{text-align:left}.company-name{font-size:18px;font-weight:700;margin-bottom:3px}.company-details{font-size:10px;color:#666;line-height:1.2}.document-info{text-align:right}.document-title{font-size:16px;font-weight:700;margin-bottom:3px}.document-details{font-size:10px;color:#666;line-height:1.2}.address-group{border:1px solid #ccc;margin-bottom:15px;padding:10px;page-break-inside:avoid;border-radius:4px;background:#fefefe}.subscription-header{font-weight:700;margin-bottom:10px;padding-bottom:10px;border-bottom:1px dashed #666;color:#333}.address-content{display:grid;grid-template-columns:repeat(5,1fr)}.address-content>div{padding:5px 8px}.field.col-span-2{grid-column:span 2}.field.p-l-0{padding-left:0}.field.border{border:0 dashed #666}.field.border-top{border-top-width:1px}.field.border-bottom{border-bottom-width:1px}.field.border-left{border-left-width:1px}.field.border-right{border-right-width:1px}.field-label{font-weight:600;font-size:9px;color:#555;text-transform:uppercase;margin-bottom:2px;letter-spacing:.5px}.field-value{font-size:11px;padding:3px 0;color:#333}.address-section{display:grid;grid-template-columns:1fr 1fr;gap:8px;margin-top:4px}.address-line{grid-column:1/-1}@media print{body{padding:0}}@media screen{body{max-width:8.5in;margin:0 auto}}
	</style>
</head>

<body>
	<!-- Header -->
	<div class="header">
		<div class="company-info">
			<div class="company-name">
				<?php echo esc_html( $store_info['name'] ); ?>
			</div>

			<div class="company-details">
				<?php if ( ! empty( $store_info['address'] ) ) : ?>
					<span><?php echo esc_html( $store_info['address'] ); ?></span>
				<?php endif; ?>

				<?php if ( ! empty( $store_info['city'] ) ) : ?>
					<span> | </span>
					<span>
						<?php echo esc_html( $store_info['city'] ); ?>
					</span>
				<?php endif; ?>

				<?php if ( ! empty( $store_info['state'] ) ) : ?>
					<span> | </span>
					<span><?php echo esc_html( $store_info['state'] ); ?></span>
				<?php endif; ?>

				<?php if ( ! empty( $store_info['country'] ) ) : ?>
					<span> | </span>
					<span><?php echo esc_html( $store_info['country'] ); ?></span>
				<?php endif; ?>
			</div>
		</div>

		<div class="document-info">
			<div class="document-title">Delivery Addresses</div>
			<div class="document-details">
				<?php echo esc_html( $generated_at ); ?>
			</div>
		</div>
	</div>

	<!-- Delivery Schedules -->
	<?php foreach ( $deliveries as $delivery ) : ?>

		<?php
		// Get delivery data
		$subscription_id = get_post_meta( $delivery->ID, '_subscrpt_subscription_id', true );
		$order_item_id   = get_post_meta( $subscription_id, '_subscrpt_order_item_id', true );
		$order_id        = get_post_meta( $subscription_id, '_subscrpt_order_id', true );
		$order           = $order_id ? wc_get_order( $order_id ) : null;
		$order_item      = $order && $order_item_id ? $order->get_item( $order_item_id ) : null;

		// Customer data
		$customer       = $order ? $order->get_formatted_billing_full_name() : '-';
		$customer_id    = $order ? $order->get_customer_id() : 0;
		$customer_phone = $order ? $order->get_billing_phone() : '';
		$customer_email = $order ? $order->get_billing_email() : '';

		// Product data
		$product_name = $order_item ? $order_item->get_name() : '-';

		// Shipping data
		$shipping_address_1 = $order ? $order->get_shipping_address_1() : '';
		$shipping_address_2 = $order ? $order->get_shipping_address_2() : '';
		$shipping_address   = trim( $shipping_address_1 . ' ' . $shipping_address_2 );
		$shipping_city      = $order ? $order->get_shipping_city() : '';
		$shipping_postcode  = $order ? $order->get_shipping_postcode() : '';
		$shipping_state     = $order ? $order->get_shipping_state() : '';
		$shipping_country   = $order ? $order->get_shipping_country() : '';

		$country_name = $wc_countries->countries[ $shipping_country ] ?? $shipping_country;
		$state_name   = '';
		if ( $shipping_country && $shipping_state ) {
			$states     = $wc_countries->get_states( $shipping_country );
			$state_name = $states[ $shipping_state ] ?? $shipping_state;
		}
		?>
		
	<div class="address-group">
		<div class="subscription-header">
			<span>Order ID: #<?php echo esc_html( $order_id ); ?></span>
			<span> | </span>
			<span>Subscription ID: #<?php echo esc_html( $subscription_id ); ?></span>
			<span> | </span>
			<span>Product: <?php echo esc_html( $product_name ); ?></span>
		</div>

		<div class="address-content">
			<div class="field border border-right border-bottom p-l-0">
				<div class="field-label">Name</div>
				<div class="field-value">
					<?php echo esc_html( $customer ); ?>
				</div>
			</div>

			<div class="field border border-right border-bottom">
				<div class="field-label">Phone No.</div>
				<div class="field-value">
					<?php echo esc_html( $customer_phone ); ?>
				</div>
			</div>

			<div class="field border border-right border-bottom">
				<div class="field-label">Email</div>
				<div class="field-value">
					<?php echo esc_html( $customer_email ); ?>
				</div>
			</div>

			<div class="field border border-bottom col-span-2">
				<div class="field-label">Address</div>
				<div class="field-value">
					<?php echo esc_html( $shipping_address ); ?>
				</div>
			</div>

			<div class="field border border-right p-l-0">
				<div class="field-label">City</div>
				<div class="field-value">
					<?php echo esc_html( $shipping_city ); ?>
				</div>
			</div>

			<div class="field border border-right">
				<div class="field-label">Zip Code</div>
				<div class="field-value">
					<?php echo esc_html( $shipping_postcode ); ?>
				</div>
			</div>

			<div class="field border border-right">
				<div class="field-label">State</div>
				<div class="field-value">
					<?php echo esc_html( $state_name ); ?>
				</div>
			</div>

			<div class="field border border-right">
				<div class="field-label">Country</div>
				<div class="field-value">
					<?php echo esc_html( $country_name ); ?>
				</div>
			</div>

			<div class="field border">
				<div class="field-label">Remarks</div>
				<div class="field-value"></div>
			</div>
		</div>
	</div>

	<?php endforeach; ?>

	<!-- Trigger print -->
	<script>
		window.addEventListener('load', function() {
			setTimeout(function(){ window.print(); }, 150);
		});
	</script>
</body>
</html>

