<?php
/**
 * Renewal Reminder Email Template (Plain) (Pro)
 *
 * @package Subscription Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

echo "=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n";
echo esc_html( $email_heading );
echo "\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=\n\n";

// translators: %s: customer name
printf( esc_html__( 'Hello %s,', 'wp_subscription_pro' ), esc_html( $customer_name ) );
echo "\n\n";

esc_html_e( 'This is a friendly reminder that your subscription will renew soon.', 'wp_subscription_pro' );
echo "\n\n";

printf( esc_html__( 'Subscription ID: #%s', 'wp_subscription_pro' ), esc_html( $subscription_id ) );
echo "\n\n";

if ( isset( $num_of_days_before ) && $num_of_days_before > 0 ) {
	// translators: %d: number of days before
	printf( esc_html__( 'Your subscription will renew in %d days.', 'wp_subscription_pro' ), esc_html( $num_of_days_before ) );
	echo "\n\n";
}

if ( isset( $product_name ) ) {
	esc_html_e( 'Subscription Details:', 'wp_subscription_pro' );
	echo "\n";
	esc_html_e( 'Product: ', 'wp_subscription_pro' );
	echo esc_html( $product_name );
	echo "\n";
	esc_html_e( 'Quantity: ', 'wp_subscription_pro' );
	echo esc_html( $qty );
	echo "\n";
	esc_html_e( 'Amount: ', 'wp_subscription_pro' );
	echo wp_kses_post( $amount );
	echo "\n\n";
}

esc_html_e( 'If you need to update your payment method or have any questions, please contact our support team.', 'wp_subscription_pro' );
echo "\n\n";

echo "\n----------------------------------------\n\n";
