<?php
/**
 * Renewal Reminder Email Template (Pro)
 *
 * @package Subscription Pro
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_email_header', $email_heading, $email ); ?>

<p><?php printf( esc_html__( 'Hello %s,', 'wp_subscription_pro' ), esc_html( $customer_name ) ); ?></p>

<p><?php esc_html_e( 'This is a friendly reminder that your subscription will renew soon.', 'wp_subscription_pro' ); ?></p>

<p><?php printf( esc_html__( 'Subscription ID: #%s', 'wp_subscription_pro' ), esc_html( $subscription_id ) ); ?></p>

<?php if ( isset( $num_of_days_before ) && $num_of_days_before > 0 ) : ?>
	<p><?php printf( esc_html__( 'Your subscription will renew in %d days.', 'wp_subscription_pro' ), esc_html( $num_of_days_before ) ); ?></p>
<?php endif; ?>

<?php if ( isset( $product_name ) ) : ?>
	<h3><?php esc_html_e( 'Subscription Details', 'wp_subscription_pro' ); ?></h3>
	<table cellspacing="0" cellpadding="6" style="width: 100%; border: 1px solid #eee;" border="1">
		<thead>
			<tr>
				<th scope="col" style="text-align:left; border: 1px solid #eee;"><?php esc_html_e( 'Product', 'wp_subscription_pro' ); ?></th>
				<th scope="col" style="text-align:left; border: 1px solid #eee;"><?php esc_html_e( 'Quantity', 'wp_subscription_pro' ); ?></th>
				<th scope="col" style="text-align:left; border: 1px solid #eee;"><?php esc_html_e( 'Amount', 'wp_subscription_pro' ); ?></th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td style="text-align:left; border: 1px solid #eee;"><?php echo esc_html( $product_name ); ?></td>
				<td style="text-align:left; border: 1px solid #eee;"><?php echo esc_html( $qty ); ?></td>
				<td style="text-align:left; border: 1px solid #eee;"><?php echo wp_kses_post( $amount ); ?></td>
			</tr>
		</tbody>
	</table>
<?php endif; ?>

<p><?php esc_html_e( 'If you need to update your payment method or have any questions, please contact our support team.', 'wp_subscription_pro' ); ?></p>

<?php
do_action( 'woocommerce_email_footer', $email );
