jQuery(document).ready(function ($) {
  // Handle API key regeneration
  $("#regenerate_api_key").on("click", function (e) {
    e.preventDefault();

    if (!confirm("Are you sure you want to regenerate the API key? This will invalidate the current key.")) {
      return;
    }

    var $button = $(this);
    $button.prop("disabled", true);

    $.ajax({
      url: ajaxurl,
      type: "POST",
      data: {
        action: "subscrpt_pro_handle_ajax",
        action_type: "regenerate_api_key",
        nonce: subscrpt_pro_ajax.nonce,
      },
      success: function (response) {
        if (response.success) {
          $("#wpsubscription_api_key").val(response.data.api_key);
          alert("API key regenerated successfully!");
        } else {
          alert("Error: " + response.data);
        }
      },
      error: function () {
        alert("Error: Could not regenerate API key. Please try again.");
      },
      complete: function () {
        $button.prop("disabled", false);
      },
    });
  });
});
