<?php

namespace SpringDevs\SubscriptionPro\Admin;

/**
 * Class Update
 *
 * @package SpringDevs\SubscriptionPro\Admin
 */
class Update {



	/**
	 * Initialize the class
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'update_plugin' ) );
		add_action( 'admin_notices', array( $this, 'license_notice' ) );
		add_filter( 'sdevs_pro_plugins', array( $this, 'register_plugins' ) );
	}

	/**
	 * Initialize Update Package
	 */
	public function update_plugin() {
		// No-op: Updater is now handled by SureCart SDK.
	}

	/**
	 * Display license notice
	 */
	public function license_notice() {

		$is_active = \Sdevs_Wc_Subscription_Pro::check_pro_license_or_alert( false, false );
		if ( ! $is_active ) {
			?>
			<div class="notice notice-warning" style="border-left-color: #f0b849; padding: 12px 15px; margin: 15px 0; background: #fff; border-radius: 4px; box-shadow: 0 1px 3px rgba(0,0,0,0.05);">
				<div style="display: flex; align-items: center; gap: 12px;">
					<div style="flex: 1;">
						<h3 style="margin: 0; color: #1d2327; font-size: 14px; font-weight: 600; display: flex; align-items: center; gap: 8px;">
							<span style="color: #2271b1;">Subscriptions for WooCommerce - Pro</span>
							<?php esc_html_e( 'License Required to enable pro features and get updates.', 'wp_subscription_pro' ); ?>
						</h3>
					</div>
					<div>
						<a href="<?php echo esc_url( admin_url( 'admin.php?page=wp-subscription-license' ) ); ?>" 
							class="button button-primary" 
							style="background: #2271b1; border-color: #2271b1; color: #fff; padding: 4px 12px; height: auto; line-height: 1.4; text-decoration: none; border-radius: 3px; font-size: 13px; font-weight: 500;">
							<?php esc_html_e( 'Activate Now', 'wp_subscription_pro' ); ?>
						</a>
					</div>
				</div>
			</div>
			<?php
		}
	}

	/**
	 * Register plugin
	 *
	 * @param array $plugins plugin lists.
	 *
	 * @return array
	 */
	public function register_plugins( array $plugins ): array {
		$plugins['subscription'] = __( 'Subscription Pro', 'wp_subscription_pro' );

		return $plugins;
	}
}
