<?php

namespace SpringDevs\SubscriptionPro;

use SpringDevs\Subscription\Illuminate\Helper;

class Cron {

	/**
	 * Initialize the class.
	 */
	public function __construct() {
		add_action( 'subscrpt_generate_delivery_schedule', array( $this, 'generate_delivery_schedule' ) );
		add_action( 'subscrpt_renew_reminder_cron', array( $this, 'send_renew_reminder_mail' ) );
	}

	/**
	 * Generate Delivery Schedule for Subscriptions.
	 *
	 * @return void
	 */
	public function generate_delivery_schedule() {
		$batch_offset = get_option( 'subscrpt_delivery_schedule_batch_offset', 0 );
		$args         = array(
			'post_type'      => 'subscrpt_order',
			'post_status'    => array( 'active', 'pe_cancelled' ),
			'fields'         => 'ids',
			'posts_per_page' => 10,
			'offset'         => $batch_offset,
			'meta_query'     => array(
				'relation' => 'OR',
				array(
					'key'     => '_subscrpt_schedule_generated',
					'compare' => 'NOT EXISTS',
				),
				array(
					'key'     => '_subscrpt_schedule_generated',
					'value'   => time(),
					'compare' => '<=',
				),
			),
		);

		$subscriptions = get_posts( $args );

		foreach ( $subscriptions as $subscription_id ) {
			$order_id           = get_post_meta( $subscription_id, '_subscrpt_order_id', true );
			$order              = wc_get_order( $order_id );
			$order_item         = $order->get_item(
				get_post_meta( $subscription_id, '_subscrpt_order_item_id', true )
			);
			$order_item_meta    = $order_item->get_meta( '_subscrpt_meta' );
			$recurring          = $order_item_meta['time'] . ' ' . Helper::get_typos( $order_item_meta['time'], $order_item_meta['type'] );
			$product            = $order_item->get_product();
			$next_delivery_time = strtotime( $recurring );
		}

		update_option(
			'subscrpt_delivery_schedule_batch_offset',
			count( $subscriptions ) === 10 ? ( $batch_offset + 10 ) : 0
		);
	}

	/**
	 * Send renew reminder mail.
	 *
	 * @return void
	 */
	public function send_renew_reminder_mail() {
		// Get the number of days before renewal to send reminder
		$reminder_days = get_option( 'subscrpt_renewal_reminder_days', 7 );
		$time          = strtotime( $reminder_days . ' days' );

		$args = array(
			'post_type'   => 'subscrpt_order',
			'post_status' => array( 'active', 'pe_cancelled' ),
			'fields'      => 'ids',
			'meta_query'  => array(
				'relation' => 'AND',
				array(
					'key'     => '_subscrpt_next_date',
					'value'   => $time,
					'compare' => '<=',
				),
				// array(
				// 'key'   => '_subscrpt_trial',
				// 'compare' => 'NOT EXISTS',
				// ),
				array(
					'key'     => '_subscrpt_reminder_mail_sent',
					'compare' => 'NOT EXISTS',
				),
			),
		);

		$subscriptions = get_posts( $args );

		if ( 0 === count( $subscriptions ) ) {
			return;
		}

		// Initialize WooCommerce mailer
		if ( function_exists( 'WC' ) && WC()->mailer() ) {
			foreach ( $subscriptions as $subscription_id ) {
				do_action( 'subscrpt_renew_reminder_email_notification', $subscription_id );
			}
		}
	}
}
