<?php

namespace SpringDevs\SubscriptionPro;

/**
 * Class Installer
 *
 * @package SpringDevs\SubscriptionPro
 */
class Installer {

	/**
	 * Run the installer
	 *
	 * @return void
	 */
	public function run() {
		$this->add_version();
		$this->register_schedules();
		$this->create_tables();
	}

	/**
	 * Add time and version on DB
	 */
	public function add_version() {
		$installed = get_option( 'subscription_pro_installed' );

		if ( ! $installed ) {
			update_option( 'subscription_pro_installed', time() );
		}

		update_option( 'subscription_pro_version', SUBSCRIPT_PRO_VERSION );
	}

	/**
	 * Register schedules
	 *
	 * @return void
	 */
	public function register_schedules() {
		if ( ! wp_next_scheduled( 'subscrpt_generate_delivery_schedule' ) ) {
			wp_schedule_event( time(), 'hourly', 'subscrpt_generate_delivery_schedule' );
		}

		if ( ! wp_next_scheduled( 'subscrpt_renew_reminder_cron' ) ) {
			wp_schedule_event( time(), 'daily', 'subscrpt_renew_reminder_cron' );
		}
	}

	/**
	 * Create necessary database tables
	 *
	 * @return void
	 */
	public function create_tables() {
		if ( ! function_exists( 'dbDelta' ) ) {
			include_once ABSPATH . 'wp-admin/includes/upgrade.php';
		}
	}
}
