<?php
/**
 * LearnDash integration class file.
 *
 * @package SpringDevs\SubscriptionPro\Integrations
 */

namespace SpringDevs\SubscriptionPro\Integrations;

use Learndash_WooCommerce;
use SpringDevs\Subscription\Illuminate\Helper as FreeHelper;

/**
 * Class LearnDash
 */
class LearnDash {

	/**
	 * Constructor.
	 */
	public function __construct() {
		add_action( 'init', [ $this, 'init' ] );
	}

	/**
	 * Initialize the license manager.
	 */
	public function init() {
		if ( ! $this->check_plugin() ) {
			return;
		}

		add_action( 'subscrpt_subscription_activated', [ $this, 'maybe_enroll_courses' ] );

		add_action( 'subscrpt_subscription_cancelled', [ $this, 'maybe_unenroll_courses' ] );
		add_action( 'subscrpt_subscription_expired', [ $this, 'maybe_unenroll_courses' ] );
	}

	/**
	 * Check if License Manager plugin is active.
	 */
	public function check_plugin() {
		$is_ld_plugin_active = is_plugin_active( 'sfwd-lms/sfwd_lms.php' );
		$is_ld_class_exists  = class_exists( 'LearnDash\Core\App' );
		$is_ld_active        = $is_ld_plugin_active && $is_ld_class_exists;

		$is_ldw_plugin_active = is_plugin_active( 'learndash-woocommerce/learndash_woocommerce.php' );
		$is_ldw_class_exists  = class_exists( 'Learndash_WooCommerce' );
		$is_ldw_active        = $is_ldw_plugin_active && $is_ldw_class_exists;

		return $is_ld_active && $is_ldw_active;
	}

	/**
	 * Enroll Courses
	 *
	 * @param int $subscription_id Subscription ID.
	 */
	public function maybe_enroll_courses( $subscription_id ) {
		$parent_order = FreeHelper::get_parent_order( $subscription_id );
		$order_id     = $parent_order->get_id();

		Learndash_WooCommerce::add_course_access( $order_id );
	}

	/**
	 * Unenroll Courses
	 *
	 * @param int $subscription_id Subscription ID.
	 */
	public function maybe_unenroll_courses( $subscription_id ) {
		$parent_order = FreeHelper::get_parent_order( $subscription_id );
		$order_id     = $parent_order->get_id();

		Learndash_WooCommerce::remove_course_access( $order_id );
	}
}
