<?php
/**
 * Subscription Details View
 *
 * This template can be overridden by copying it to the following path
 * <your_theme>/subscription-pro/LiveQR/subscription-basic-details.php
 *
 * @package SubscriptionPro\Illuminate\LiveQR\views
 */

/**
 * Variables passed to this template:
 *
 * @var array $subscription_data
 * @var int $subscription_id
 * @var string $status
 * @var string $verbose_status
 * @var bool $is_grace_period
 * @var int $grace_remaining
 * @var string $grace_end_date
 * @var string $product_name
 * @var string $product_description
 * @var string $product_image_url
 * @var string $plan_price_formatted
 * @var string $start_date
 * @var string $next_date
 * @var string $recent_payment_date
 * @var string $payment_method
 * @var array $subscription_activities
 * @var array $settings
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Include Tailwind CSS
 *
 * This function includes the Tailwind CSS styles required for the template.
 * Remove this function and "wpsubs-pro-tw-root" class if you don't want to include Tailwind.
 */
subscrpt_pro_include_tailwind_css();

?>
<?php if ( ! empty( $subscription_data ) ) : ?>

<div class="wpsubs-pro-tw-root">
	<div class="card card-dash border-gray-300 bg-white">
		<div class="card-body">
			<div class="flex gap-4">
				<div class="text-3xl grow">
					Subscription <?php echo esc_html( $subscription_data['id'] ); ?>
				</div>

				<!-- Status Badges -->
				<?php if ( $is_grace_period && $grace_remaining > 0 ) : ?>
					<!-- Grace Period -->
					<?php
						$grace_remaining_text = sprintf(
							// translators: Number of days remaining in grace period.
							__( 'Grace Period: %d days remaining!', 'wp_subscription_pro' ),
							$grace_remaining
						);
					?>

					<div class="badge badge-lg badge-soft badge-outline badge-warning">
						<div class="status status-warning"></div>
						<div class="tooltip tooltip-warning" data-tip="<?php echo esc_attr( $grace_remaining_text ); ?>">
							Active
						</div>
					</div>
				<?php elseif ( $status === 'pending' ) : ?>
					<div class="badge badge-lg badge-soft badge-outline badge-secondary">
						<div class="status status-secondary"></div>
						<?php echo esc_html( $verbose_status ); ?>
					</div>
				<?php elseif ( $status === 'active' ) : ?>
					<div class="badge badge-lg badge-soft badge-outline badge-success">
						<div class="status status-success"></div>
						<?php echo esc_html( $verbose_status ); ?>
					</div>
				<?php elseif ( $status === 'expired' ) : ?>
					<div class="badge badge-lg badge-soft badge-outline badge-error">
						<div class="status status-error"></div>
						<?php echo esc_html( $verbose_status ); ?>
					</div>
				<?php elseif ( $status === 'cancelled' ) : ?>
					<div class="badge badge-lg badge-soft badge-outline badge-primary">
						<div class="status status-primary"></div>
						<?php echo esc_html( $verbose_status ); ?>
					</div>
				<?php elseif ( $status === 'pe_cancelled' ) : ?>
					<div class="badge badge-lg badge-soft badge-outline badge-warning">
						<div class="status status-warning"></div>
						<?php echo esc_html( $verbose_status ); ?>
					</div>
				<?php endif; ?>
			</div>

			<!-- Plan Summary -->
			<div class="divider mt-5">
				<span class="font-medium text-gray-400">
					<?php esc_html_e( 'Plan Summary', 'wp_subscription_pro' ); ?>
				</span>
			</div>

			<div>
				<div class="flex items-center gap-4 font-medium py-3 border-b border-gray-100">
					<div class="grow text-gray-500">
						<?php echo esc_html_e( 'Plan', 'wp_subscription_pro' ); ?>
					</div>
					<div><?php echo esc_html( $product_name ); ?></div>
				</div>

				<div class="flex items-center gap-4 font-medium py-3 border-b border-gray-100">
					<div class="grow text-gray-500">
						<?php echo esc_html_e( 'Price', 'wp_subscription_pro' ); ?>
					</div>
					<div><?php echo wp_kses_post( $plan_price_formatted ); ?></div>
				</div>

				<div class="flex items-center gap-4 font-medium py-3 border-b border-gray-100">
					<div class="grow text-gray-500">
						<?php echo esc_html_e( 'Subscriber Since', 'wp_subscription_pro' ); ?>
					</div>
					<div><?php echo wp_kses_post( $start_date ); ?></div>
				</div>

				<div class="flex items-center gap-4 font-medium py-3 border-b border-gray-100">
					<div class="grow text-gray-500">
						<?php echo esc_html_e( 'Expires On', 'wp_subscription_pro' ); ?>
					</div>
					<div><?php echo wp_kses_post( $next_date ); ?></div>
				</div>

				<div class="flex items-center gap-4 font-medium py-2">
					<div class="grow text-gray-500">
						<?php echo esc_html_e( 'Status', 'wp_subscription_pro' ); ?>
					</div>
					<div>
						<?php echo esc_html( ( $is_grace_period && $grace_remaining > 0 ) ? __( 'In Grace Period', 'wp_subscription_pro' ) : $verbose_status ); ?>
					</div>
				</div>
			</div>

			<!-- Grace Period -->
			<?php if ( $is_grace_period && $grace_remaining > 0 ) : ?>
			<div class="divider">
				<span class="font-medium text-gray-400">
					<?php esc_html_e( 'Grace Period', 'wp_subscription_pro' ); ?>
				</span>
			</div>

			<div>
				<div class="flex items-center gap-4 font-medium py-3 border-b border-gray-100">
					<div class="grow text-gray-500">
						<?php esc_html_e( 'Remaining', 'wp_subscription_pro' ); ?>
					</div>
					<div><?php echo esc_html( $grace_remaining ); ?> Days</div>
				</div>

				<div class="flex items-center gap-4 font-medium py-3">
					<div class="grow text-gray-500">
						<?php esc_html_e( 'Ends On', 'wp_subscription_pro' ); ?>
					</div>
					<div><?php echo esc_html( $grace_end_date ); ?></div>
				</div>
			</div>
			<?php endif; ?>

			<!-- Product Details -->
			<?php if ( $settings['show_product_details'] ) : ?>
			<div class="divider">
				<span class="font-medium text-gray-400">
					<?php esc_html_e( 'Product Details', 'wp_subscription_pro' ); ?>
				</span>
			</div>

			<div class="flex rounded overflow-hidden bg-gray-100 border border-gray-100">
				<div class="w-20">
					<img
						src="<?php echo esc_url( $product_image_url ); ?>"
						alt="<?php echo esc_attr( $product_name ); ?>"
						class="!w-20 !h-full object-cover"
					/>
				</div>
				<div class="p-4">
					<p class="mb-2"><?php echo esc_html( $product_name ); ?></p>
					<p class="text-xs"><?php echo esc_html( $product_description ); ?></p>
				</div>
			</div>
			<?php endif; ?>

			<!-- Billing Details -->
			<?php if ( $settings['show_billing_details'] ) : ?>
			<div class="divider">
				<span class="font-medium text-gray-400">
					<?php esc_html_e( 'Billing Details', 'wp_subscription_pro' ); ?>
				</span>
			</div>

			<div>
				<div class="flex items-center gap-4 font-medium py-3 border-b border-gray-100">
					<div class="grow text-gray-500">
						<?php echo esc_html_e( 'Next Payment', 'wp_subscription_pro' ); ?>
					</div>
					<div><?php echo wp_kses_post( $next_date ); ?></div>
				</div>

				<div class="flex items-center gap-4 font-medium py-3 border-b border-gray-100">
					<div class="grow text-gray-500">
						<?php echo esc_html_e( 'Last Payment', 'wp_subscription_pro' ); ?>
					</div>
					<div><?php echo wp_kses_post( $recent_payment_date ); ?></div>
				</div>

				<div class="flex items-center gap-4 font-medium py-2">
					<div class="grow text-gray-500">
						<?php echo esc_html_e( 'Billing Via', 'wp_subscription_pro' ); ?>
					</div>
					<div>
						<?php echo esc_html( $payment_method ); ?>
					</div>
				</div>
			</div>
			<?php endif; ?>

			<!-- Timeline -->
			<?php if ( $settings['show_timeline'] ) : ?>
			<div class="divider">
				<span class="font-medium text-gray-400">
					<?php esc_html_e( 'Timeline', 'wp_subscription_pro' ); ?>
				</span>
			</div>


			<div>
				<?php foreach ( $subscription_activities as $activity ) : ?>
					<?php
					$activity_title = ! empty( $activity['title'] ) ? $activity['title'] : '';

					switch ( $activity['type'] ) {
						case 'subs_created':
							$activity_title = __( 'Subscription Created', 'wp_subscription_pro' );
							break;
						case 'subs_activated':
							$activity_title = __( 'Subscription Activated', 'wp_subscription_pro' );
							break;
						case 'subs_cancelled':
							$activity_title = __( 'Subscription Cancelled', 'wp_subscription_pro' );
							break;
						case 'subs_expired':
							$activity_title = __( 'Subscription Expired', 'wp_subscription_pro' );
							break;
						case 'renewal_order':
							$activity_title = __( 'Renewal Order Created', 'wp_subscription_pro' );
							break;
						default:
							break;
					}

					$activity_date = ! empty( $activity['date'] ) ? gmdate( 'M j, Y', strtotime( $activity['date'] ) ) : '-';
					?>

					<!-- Timeline Item -->
					<div class="flex gap-x-3 relative group rounded-lg hover:bg-gray-100">
						<!-- Left: Icon -->
						<div class="relative after:absolute after:top-0 group-first:after:top-1/2 after:bottom-0 group-last:after:bottom-1/2 after:start-3.5 after:w-px after:-translate-x-[0.5px] after:bg-gray-200">
							<div class="relative z-10 size-7 flex justify-center items-center pt-2">
								<div class="size-3 rounded-full bg-white border-2 border-gray-300 group-hover:border-gray-600"></div>
							</div>
						</div>

						<!-- Right: Content -->
						<div class="grow p-2">
							<p class="text-sm text-gray-600">
								<?php echo esc_html( $activity_title ); ?>
								on
								<strong><?php echo esc_html( $activity_date ); ?></strong>
							</p>
						</div>
					</div>
				<?php endforeach; ?>
			</div>
			<?php endif; ?>
		</div>

		<!-- Footer -->
		<div class="text-xs text-gray-500 text-center p-3 border-t border-dashed border-gray-300">
			Powered by <span class="font-medium">WPSubscription</span>
		</div>
	</div>
</div>

<?php else : ?>

<div class="wpsubs-pro-tw-root">
	<div role="alert" class="alert alert-error alert-dash">
		<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" class="stroke-error h-6 w-6 shrink-0">
			<path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
		</svg>
		<div>
			<div class="font-semibold text-lg"><?php esc_html_e( 'Subscription not found!', 'wp_subscription_pro' ); ?></div>
			<div class="text-xs"><?php esc_html_e( 'This could be an issue. Please contact support.', 'wp_subscription_pro' ); ?></div>
		</div>
	</div>
</div>

<?php endif; ?>
