<?php
/**
 * Payment Failure Email Template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/payment-failure-html.php
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WP_Subscription_Pro
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/*
 * @hooked WC_Emails::email_header() Output the email header
 */
do_action( 'woocommerce_email_header', $email_heading, $email );
?>

<p><?php printf( esc_html__( 'Hi %s,', 'wp_subscription_pro' ), esc_html( $customer_name ) ); ?></p>

<?php if ( $is_delayed ) : ?>
	<p><?php esc_html_e( 'We wanted to follow up regarding your recent subscription payment failure.', 'wp_subscription_pro' ); ?></p>
<?php endif; ?>

<p>
	<?php
	if ( $remaining_attempts > 0 ) {
		printf(
			// translators: %d: number of attempts remaining
			esc_html__( 'Your subscription payment has failed. We will automatically retry the payment. You have %d attempts remaining.', 'wp_subscription_pro' ),
			esc_html( $remaining_attempts )
		);
	} else {
		esc_html_e( 'Your subscription payment has failed after multiple attempts.', 'wp_subscription_pro' );
	}
	?>
</p>

<?php if ( $remaining_attempts > 0 ) : ?>
	<p><?php esc_html_e( 'Please ensure your payment method is up to date to avoid service interruption.', 'wp_subscription_pro' ); ?></p>
<?php else : ?>
	<p><?php esc_html_e( 'Your access has been suspended. Please update your payment method and contact support to restore access.', 'wp_subscription_pro' ); ?></p>
<?php endif; ?>

<h2><?php esc_html_e( 'Subscription Details', 'wp_subscription_pro' ); ?></h2>

<ul>
	<li><strong><?php esc_html_e( 'Subscription ID:', 'wp_subscription_pro' ); ?></strong> #<?php echo esc_html( $subscription_id ); ?></li>
	<li><strong><?php esc_html_e( 'Product:', 'wp_subscription_pro' ); ?></strong> <?php echo esc_html( $product_name ); ?></li>
	<li><strong><?php esc_html_e( 'Amount:', 'wp_subscription_pro' ); ?></strong> <?php echo wp_kses_post( $amount ?: '0.00' ); ?></li>
	<li><strong><?php esc_html_e( 'Failure Count:', 'wp_subscription_pro' ); ?></strong> <?php echo esc_html( $failure_count ); ?> / <?php echo esc_html( $max_retries ); ?></li>
</ul>

<?php if ( $remaining_attempts > 0 ) : ?>
	<div style="background-color: #fff3cd; border: 1px solid #ffeaa7; padding: 15px; margin: 20px 0; border-radius: 4px;">
		<h3 style="margin-top: 0; color: #856404;"><?php esc_html_e( 'What Happens Next?', 'wp_subscription_pro' ); ?></h3>
		<p style="margin-bottom: 0;">
			<?php esc_html_e( 'We will automatically retry your payment. If you continue to experience issues, please contact our support team for assistance.', 'wp_subscription_pro' ); ?>
		</p>
	</div>
<?php else : ?>
	<div style="background-color: #f8d7da; border: 1px solid #f5c6cb; padding: 15px; margin: 20px 0; border-radius: 4px;">
		<h3 style="margin-top: 0; color: #721c24;"><?php esc_html_e( 'Action Required', 'wp_subscription_pro' ); ?></h3>
		<p style="margin-bottom: 0;">
			<?php esc_html_e( 'Your subscription access has been suspended. Please update your payment method and contact support to restore access.', 'wp_subscription_pro' ); ?>
		</p>
	</div>
<?php endif; ?>

<p>
	<?php esc_html_e( 'If you have any questions or need assistance, please don\'t hesitate to contact our support team.', 'wp_subscription_pro' ); ?>
</p>

<p>
	<?php esc_html_e( 'Best regards,', 'wp_subscription_pro' ); ?><br>
	<?php echo esc_html( get_bloginfo( 'name' ) ); ?>
</p>

<?php
/*
 * @hooked WC_Emails::email_footer() Output the email footer
 */
do_action( 'woocommerce_email_footer', $email );
?>
