jQuery(document).ready(($) => {
  // * -------------------------------------------------------------------------- * //
  // * ------------------ Status filter dropdown functionality ------------------ * //
  // * -------------------------------------------------------------------------- * //

  // Status filter dropdown functionality
  const $statusFilter = $(".wp-subscription-status-filter");
  const $statusLabel = $(".status-filter-label");
  const $statusDropdown = $(".status-filter-dropdown");
  const $statusCheckboxes = $('.status-filter-option input[type="checkbox"]');

  if ($statusFilter.length && $statusLabel.length && $statusDropdown.length) {
    // Toggle dropdown
    $statusLabel.on("click", function (e) {
      e.preventDefault();
      $statusDropdown.toggleClass("show");
    });

    // Close dropdown when clicking outside
    $(document).on("click", function (e) {
      if (!$statusFilter.has(e.target).length && !$statusFilter.is(e.target)) {
        $statusDropdown.removeClass("show");
      }
    });

    // Update label with count
    function updateStatusLabel() {
      const checkedCount = $statusCheckboxes.filter(":checked").length;
      const $filterCount = $statusLabel.find(".filter-count");

      if (checkedCount > 0) {
        if ($filterCount.length) {
          $filterCount.text("(" + checkedCount + ")");
        } else {
          $statusLabel.html('Status Filter<span class="filter-count">(' + checkedCount + ")</span>");
        }
      } else {
        $statusLabel.html("Status Filter");
      }
    }

    // Handle checkbox changes
    $statusCheckboxes.on("change", updateStatusLabel);

    updateStatusLabel();
  }

  // * -------------------------------------------------------------------------- * //
  // * ------------------ Status filter dropdown functionality ------------------ * //
  // * -------------------------------------------------------------------------- * //

  // * -------------------------------------------------------------------------- * //
  // * ------------------ Delivery status update functionality ------------------ * //
  // * -------------------------------------------------------------------------- * //

  // Delivery status update functionality
  $(".subscrpt-delivery-status-dropdown").on("change", function () {
    const deliveryId = $(this).data("delivery-id");
    const newStatus = $(this).val();

    const formData = new FormData();
    formData.append("action", "subscrpt_update_delivery_status");
    formData.append("delivery_id", deliveryId);
    formData.append("new_status", newStatus);
    formData.append("security", subscrpt_update_delivery_status.security);

    $.ajax({
      url: ajaxurl,
      type: "POST",
      data: formData,
      processData: false,
      contentType: false,
      dataType: "json",
      success: function (data) {
        if (data.success) {
          showDeliveryPopup(data.data.message, true);
        } else {
          showDeliveryPopup(data.data.message || "Error updating status", false);
        }
      },
      error: function (error) {
        showDeliveryPopup("Error updating status", false);
        console.error("Error:", error);
      },
    });
  });

  function showDeliveryPopup(message, isSuccess) {
    let $popup = $("#subscrpt-delivery-popup");
    if ($popup.length === 0) {
      $popup = $(
        `<div
          id="subscrpt-delivery-popup"
          style="
            position: fixed;
            left: 50%;
            bottom: 40px;
            transform: translateX(-50%);
            z-index: 99999;
            min-width: 240px;
            font-size: 0.875rem;
            padding: 1rem;
            border-radius: 8px;
            box-shadow: 0 4px 24px rgba(0, 0, 0, 0.13);
            display: flex;
            align-items: center;
          "
        >
          <svg
            aria-hidden="true"
            xmlns="http://www.w3.org/2000/svg"
            fill="currentColor"
            viewBox="0 0 20 20"
            style="flex-shrink: 0; display: inline; width: 1rem; height: 1rem; margin-right: 0.75rem"
          >
            <path
              d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 
                            1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 
                            1 1 0 1v4h1a1 1 0 0 1 0 2Z"
            />
          </svg>
        
          <span id="subscrpt-delivery-popup-message" style="vertical-align: middle"></span>
        </div>`,
      );
      $("body").append($popup);
    }

    $popup
      .stop(true, true)
      .css({
        background: isSuccess ? "#f0fdf4" : "#fef2f2",
        color: isSuccess ? "#166534" : "#991b1b",
        border: isSuccess ? "1.5px solid #86efac" : "1.5px solid #fca5a5",
      })
      .find("#subscrpt-delivery-popup-message")
      .text(message ?? (isSuccess ? "Status updated successfully!" : "Failed to update status."))
      .end()
      .fadeIn(250)
      .delay(1200)
      .fadeOut(500);
  }

  // * -------------------------------------------------------------------------- * //
  // * ------------------ Delivery status update functionality ------------------ * //
  // * -------------------------------------------------------------------------- * //

  // * -------------------------------------------------------------------------- * //
  // * ---------------- Select-all and per-row checkbox syncing ----------------- * //
  // * -------------------------------------------------------------------------- * //

  // Select-all and per-row checkbox syncing
  const $form = $("#deliveries-form");
  const $selectAll = $("#subscrpt-select-all");
  function getItems() {
    return $form.find(".subscrpt-select-item");
  }

  // Toggle between All vs Selected print buttons (declare before first use)
  const $btnPrintAll = $("#subscrpt-print-all");
  const $btnPrintSelected = $("#subscrpt-print-selected");
  function togglePrintButtons(selectedCount) {
    if (selectedCount > 0) {
      $btnPrintAll.hide();
      $btnPrintSelected.show();
    } else {
      $btnPrintSelected.hide();
      $btnPrintAll.show();
    }
  }

  function updateHeaderState() {
    const $items = getItems();
    const total = $items.length;
    if (total === 0) {
      $selectAll.prop("checked", false).prop("indeterminate", false);
      togglePrintButtons(0);
      return;
    }
    const checkedCount = $items.filter(":checked").length;
    $selectAll.prop("checked", checkedCount === total);
    $selectAll.prop("indeterminate", checkedCount > 0 && checkedCount < total);
    togglePrintButtons(checkedCount);
  }

  $selectAll.on("change", function () {
    const isChecked = $(this).is(":checked");
    getItems().prop("checked", isChecked);
    $selectAll.prop("indeterminate", false);
    updateHeaderState();
  });

  $form.on("change", ".subscrpt-select-item", function () {
    updateHeaderState();
  });

  // Initialize header checkbox state on load
  updateHeaderState();

  // * -------------------------------------------------------------------------- * //
  // * ---------------- Select-all and per-row checkbox syncing ----------------- * //
  // * -------------------------------------------------------------------------- * //

  // * -------------------------------------------------------------------------- * //
  // * ------------------------ Print Schedule Actions -------------------------- * //
  // * -------------------------------------------------------------------------- * //

  // Printable schedule actions
  function openPrintableSchedule(params) {
    const url = new URL(window.location.href);
    url.searchParams.set("page", "wp-subscription-delivery");
    url.searchParams.set("subscrpt_action", "print_schedule");
    Object.keys(params || {}).forEach((key) => {
      const value = params[key];
      if (Array.isArray(value)) {
        // Clear existing and append multiple
        url.searchParams.delete(key);
        value.forEach((v) => url.searchParams.append(key + "[]", v));
      } else if (value !== undefined && value !== null && value !== "") {
        url.searchParams.set(key, value);
      }
    });
    window.open(url.toString(), "_blank");
  }

  $("#subscrpt-print-all").on("click", function () {
    // Use current filters; server will render all matched
    openPrintableSchedule({ scope: "all" });
  });

  $("#subscrpt-print-selected").on("click", function () {
    const ids = getItems()
      .filter(":checked")
      .map(function () {
        return $(this).val();
      })
      .get();
    if (ids.length === 0) {
      showDeliveryPopup("Please select at least one delivery.", false);
      return;
    }
    openPrintableSchedule({ scope: "selected", delivery_ids: ids });
  });

  // * -------------------------------------------------------------------------- * //
  // * ------------------------ Print Schedule Actions -------------------------- * //
  // * -------------------------------------------------------------------------- * //
});
