<?php

namespace SpringDevs\SubscriptionPro\Admin;

use SpringDevs\SubscriptionPro\Illuminate\Helper;

/**
 * Class Subscriptions
 *
 * @package SpringDevs\SubscriptionPro\Admin
 */
class Subscriptions {

	/**
	 * Initialize the class
	 */
	public function __construct() {
		add_action( 'subscrpt_order_activities', array( $this, 'display_subscrpt_order_activities' ) );
		add_filter( 'subscrpt_admin_info_rows', array( $this, 'add_some_rows' ), 10, 3 );
	}

	/**
	 * Add some rows that display trial, signupfee and more ...
	 *
	 * @param array     $rows Rows.
	 * @param int       $subscription_id Subscription Id.
	 * @param \WC_Order $order Order Object.
	 *
	 * @return array
	 */
	public function add_some_rows( $rows, $subscription_id, $order ) {
		$start_date = get_post_meta( $subscription_id, '_subscrpt_start_date', true );
		$signup_fee = get_post_meta( $subscription_id, '_subscrpt_signup_fee', true );
		if ( ! empty( $trial ) ) {
			unset( $rows['start_date'] );
			$rows                       = array_slice( $rows, 0, 3, true ) +
			array(
				'signup_fee' => array(
					'label' => __( 'Signup Fee', 'wp_subscription_pro' ),
					'value' => wc_price(
						$signup_fee,
						array(
							'currency' => $order->get_currency(),
						)
					),
				),
			) +
			array_slice( $rows, 3, count( $rows ) - 1, true );
			$rows['next_date']['value'] = gmdate( 'F d, Y', $start_date );
		}

		if ( class_exists( 'WC_Stripe' ) && 'stripe' === $order->get_payment_method() ) {
			$is_auto_renew = get_post_meta( $subscription_id, '_subscrpt_auto_renew', true );
			$new_rows      = array();
			foreach ( $rows as $key => $value ) {
				$new_rows[ $key ] = $value;
				if ( 'payment_method' === $key ) {
					$new_rows['stripe_auto_renewal'] = array(
						'label' => __( 'Stripe Auto Renewal', 'wp_subscription_pro' ),
						'value' => '0' !== $is_auto_renew ? 'On' : 'Off',
					);
				}
			}

			return $new_rows;
		}

		return $rows;
	}

	/**
	 * Display Subscription Order Activities
	 *
	 * @param int $post_id Post ID.
	 */
	public function display_subscrpt_order_activities( $post_id ) {
		// Get Subscription Activities
		$comments = Helper::get_subscription_activities( $post_id );

		if ( \Sdevs_Wc_Subscription_Pro::check_pro_license_or_alert() ) {
			?>
		<table class="widefat striped">
			<thead>
				<tr>
					<th><?php echo esc_html_e( 'Activity', 'wp_subscription_pro' ); ?></th>
					<th><?php echo esc_html_e( 'Description', 'wp_subscription_pro' ); ?></th>
					<th><?php echo esc_html_e( 'Date', 'wp_subscription_pro' ); ?></th>
				</tr>
			</thead>
			<tbody>
			<?php foreach ( $comments as $comment ) : ?>
					<tr>
						<td><?php echo esc_html( $comment['title'] ); ?></td>
						<td><?php echo esc_html( $comment['description'] ); ?></td>
						<td><?php echo esc_html( gmdate( 'M j, Y - g:i A', strtotime( $comment['date'] ) ) ); ?></td>
					</tr>
		<?php endforeach; ?>
			</tbody>
		</table>
			<?php
		}
	}
}
