<?php

namespace SpringDevs\SubscriptionPro;

/**
 * Scripts and Styles Class
 */
class Assets {

	/**
	 * Assets constructor.
	 */
	public function __construct() {
		if ( is_admin() ) {
			add_action( 'admin_enqueue_scripts', array( $this, 'register' ), 5 );
			add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ), 5 );
		} else {
			add_action( 'wp_enqueue_scripts', array( $this, 'register' ), 5 );
		}
	}

	/**
	 * Register our app scripts and styles
	 *
	 * @return void
	 */
	public function register() {
		$this->register_scripts( $this->get_scripts() );
		$this->register_styles( $this->get_styles() );
	}

	/**
	 * Register scripts
	 *
	 * @param array $scripts scripts.
	 *
	 * @return void
	 */
	private function register_scripts( $scripts ) {
		foreach ( $scripts as $handle => $script ) {
			$deps      = isset( $script['deps'] ) ? $script['deps'] : false;
			$in_footer = isset( $script['in_footer'] ) ? $script['in_footer'] : false;
			$version   = isset( $script['version'] ) ? $script['version'] : SUBSCRIPT_PRO_VERSION;

			wp_register_script( $handle, $script['src'], $deps, $version, $in_footer );
		}
	}

	/**
	 * Register styles
	 *
	 * @param array $styles styles.
	 *
	 * @return void
	 */
	public function register_styles( $styles ) {
		foreach ( $styles as $handle => $style ) {
			$deps = isset( $style['deps'] ) ? $style['deps'] : false;

			wp_register_style( $handle, $style['src'], $deps, SUBSCRIPT_PRO_VERSION );
		}
	}

	/**
	 * Get all registered scripts
	 *
	 * @return array
	 */
	public function get_scripts(): array {
		$plugin_js_assets_path = SUBSCRIPT_PRO_ASSETS . '/js/';

		return array(
			'subscrpt_admin_product_js'  => array(
				'src'       => $plugin_js_assets_path . 'admin/product.js',
				'deps'      => array( 'jquery' ),
				'in_footer' => true,
			),
			'subscrpt_admin_delivery_js' => array(
				'src'       => $plugin_js_assets_path . 'admin/delivery.js',
				'deps'      => array( 'jquery' ),
				'in_footer' => true,
			),
		);
	}

	/**
	 * Get registered styles
	 *
	 * @return array
	 */
	public function get_styles() {
		$plugin_css_assets_path = SUBSCRIPT_PRO_ASSETS . '/css/';

		$styles = array(
			'subscrpt_pro_admin_css' => array(
				'src' => $plugin_css_assets_path . 'admin/admin.css',
			),
		);

		return $styles;
	}

	/**
	 * Enqueue scripts
	 */
	public function enqueue_scripts() {
		$screen = get_current_screen();
		if ( $screen->id === 'wp-subscription_page_wp-subscription-settings' ) {
			wp_enqueue_script(
				'subscrpt_admin_api_js',
				plugins_url( 'assets/js/admin/api.js', __DIR__ ),
				array( 'jquery' ),
				filemtime( plugin_dir_path( __DIR__ ) . 'assets/js/admin/api.js' ),
				true
			);

			wp_localize_script(
				'subscrpt_admin_api_js',
				'subscrpt_pro_ajax',
				array(
					'nonce' => wp_create_nonce( 'subscrpt_pro_ajax_nonce' ),
				)
			);
		}
	}
}
