<?php

namespace SpringDevs\SubscriptionPro;

use SpringDevs\SubscriptionPro\Illuminate\Delivery;
use SpringDevs\SubscriptionPro\Illuminate\Order;
use SpringDevs\SubscriptionPro\Illuminate\Product;
use SpringDevs\SubscriptionPro\Illuminate\SubscriptionSwitch;
use SpringDevs\SubscriptionPro\Illuminate\GatewayLimitEnforcer;
use SpringDevs\SubscriptionPro\Illuminate\Gateways\PaymentGateways;
use SpringDevs\SubscriptionPro\Illuminate\Helper;
use SpringDevs\SubscriptionPro\Illuminate\LiveQR\LiveQR;
use SpringDevs\SubscriptionPro\Illuminate\RoleManagement;
use SpringDevs\SubscriptionPro\Illuminate\SubscriptionStatusHandler;
use SpringDevs\SubscriptionPro\Illuminate\SplitPaymentHandler;
use SpringDevs\SubscriptionPro\Illuminate\Subscription\SubscriptionPro;
use SpringDevs\SubscriptionPro\Integrations\Integrations;

/**
 * Illuminate - Load classes in everywhere.
 */
class Illuminate {

	/**
	 * Singleton instance
	 *
	 * @var Illuminate|null
	 */
	private static $instance = null;

	/**
	 * Get singleton instance
	 *
	 * @return Illuminate
	 */
	public static function get_instance() {
		if ( null === self::$instance ) {
			self::$instance = new self();
		}
		return self::$instance;
	}

	/**
	 * Initialize the class.
	 */
	private function __construct() {
		new SubscriptionPro();
		new Helper();
		new Product();
		new Order();
		new Delivery();
		new SubscriptionSwitch();
		new GatewayLimitEnforcer();
		new SubscriptionStatusHandler();
		new Integrations();
		new LiveQR();
		new PaymentGateways();

		if ( class_exists( 'SpringDevs\Subscription\Illuminate\RoleManagement' ) ) {
			new RoleManagement();
		}

		// SplitPaymentHandler is a utility class with static methods only
		// No need to instantiate it, just ensure it's loaded
	}
}
