<?php

namespace SpringDevs\SubscriptionPro\Illuminate;

use SpringDevs\SubscriptionPro\Utils\SimpleProduct;
use SpringDevs\SubscriptionPro\Utils\VariableProduct;

class Product {

	public function __construct() {
		add_filter(
			'_subscrpt_product_data_class',
			function ( $class, $product ) {
				if ( $product->is_type( 'simple' ) ) {
					return SimpleProduct::class;
				}

				if ( $product->is_type( 'variation' ) ) {
					return VariableProduct::class;
				}

				return $class;
			},
			10,
			2
		);
	}
}
