<?php
/**
 * Main subscription class [Pro Version].
 *
 * @package Subscription
 */

namespace SpringDevs\SubscriptionPro\Illuminate\Subscription;

/**
 * Class Subscription
 *
 * @package Illuminate\Subscription
 */
class SubscriptionPro {
	/**
	 * Constructor.
	 */
	public function __construct() {
		// Custom subscription endpoints settings.
		add_filter( 'woocommerce_get_settings_advanced', [ $this, 'add_subscription_permalink_settings' ] );

		// Add order history relational types.
		add_filter( 'subscrpt_order_relational_types', [ $this, 'filter_relational_types' ] );
	}

	/**
	 * Add subscription permalink settings to WooCommerce settings.
	 *
	 * @param array $settings Existing WooCommerce advanced settings.
	 */
	public function add_subscription_permalink_settings( $settings ) {
		$subscription_settings = [
			[
				'title' => __( 'Subscription Endpoints', 'wp_subscription_pro' ),
				'type'  => 'title',
				'desc'  => __( 'Configure the permalinks for WPSubscription\'s subscription-related pages.', 'wp_subscription_pro' ),
				'id'    => 'wpsubs_permalinks_options',
			],
			[
				'title'    => __( 'Subscriptions', 'wp_subscription_pro' ),
				'id'       => 'wpsubs_custom_subscriptions_endpoint',
				'type'     => 'text',
				'default'  => 'subscriptions',
				'desc_tip' => __( 'Endpoint for the "my-account -> subscriptions" page.', 'wp_subscription_pro' ),
			],
			[
				'title'    => __( 'View Subscription', 'wp_subscription_pro' ),
				'id'       => 'wpsubs_custom_view_subscription_endpoint',
				'type'     => 'text',
				'default'  => 'subscription',
				'desc_tip' => __( 'Endpoint for the "my-account -> subscriptions -> view-subscription" page.', 'wp_subscription_pro' ),
			],
			[
				'type' => 'sectionend',
				'id'   => 'wpsubs_permalinks_options',
			],
		];

		return array_merge( $settings, $subscription_settings );
	}

	/**
	 * Register new key-value for cast.
	 *
	 * @param array $types - Types with key value.
	 * @return array
	 */
	public function filter_relational_types( array $types ) {
		$types['early-renew'] = __( 'Early Renewal Order', 'wp_subscription_pro' );

		$types['upgrade']   = __( 'Subscription Upgrade Order', 'wp_subscription_pro' );
		$types['downgrade'] = __( 'Subscription Downgrade Order', 'wp_subscription_pro' );
		return $types;
	}
}
