<?php
/**
 * Integrations Core Class
 *
 * @package SpringDevs\SubscriptionPro\Integrations
 */

namespace SpringDevs\SubscriptionPro\Integrations;

use SpringDevs\SubscriptionPro\Integrations\WPFusion\WPFusion;

/**
 * Class Integrations
 */
class Integrations {

	/**
	 * Constructor.
	 */
	public function __construct() {
		new LicenseManagerWoo();
		new WPSoftwareLicense();
		new TutorLMS();
		new LearnPress();
		new LearnDash();

		// Some integrations needs to initialize on later priority.
		add_action( 'init', [ $this, 'initialize_integrations' ], 10 );
	}

	/**
	 * Initialize integration hooks.
	 */
	public function initialize_integrations() {
		$this->init_wpf_integration();
	}

	/**
	 * Initialize WPF integration.
	 */
	public function init_wpf_integration() {
		if ( class_exists( 'WPF_Integrations_Base' ) ) {
			new WPFusion();
		}
	}
}
