<?php
/**
 * Product Settings View for WP Fusion Integration
 *
 * @package SpringDevs\SubscriptionPro\Integrations\WPFusion\views
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>
<div class="options_group">
	<!-- Subscription Fields -->
	<p class="form-field">
		<label>
			<strong>Subscription</strong>
		</label>

		<span>
			<?php
			echo wp_kses_post(
				sprintf(
					// translators: 1: Link start tag. 2: Link end tag.
					__( 'WPSubscription related actions. For more information, please visit our %1$s documentation %2$s.', 'wp_subscription_pro' ),
					'<a href="' . esc_url( $this->docs_url ) . '" target="_blank">',
					'</a>'
				)
			);
			?>
		</span>
	</p>

	<!-- Remove Tags Field -->
	<p class="form-field">
		<label><?php echo esc_html_e( 'Remove Tags', 'wp_subscription_pro' ); ?></label>

		<input 
			class="checkbox"
			type="checkbox"
			id="wpf_subscrpt_remove_tags" 
			name="wpf-settings-woo[wpf_subscrpt_remove_tags]" 
			value="1" 
			<?php checked( $settings['wpf_subscrpt_remove_tags'], '1', true ); ?> 
		/>

		<span class="description">
			<?php echo esc_html_e( 'Remove relevant tags. (E.g., when no subscription is active, remove the active tags.)', 'wp_subscription_pro' ); ?>
		</span>
	</p>

	<?php foreach ( $subs_fields as $subs_field ) : ?>
		<p class="form-field">
			<label><?php echo esc_html( $subs_field['label'] ); ?></label>

			<?php
			wpf_render_tag_multiselect(
				[
					'setting'   => $subs_field['setting'],
					'meta_name' => $subs_field['meta_name'],
					'field_id'  => $subs_field['field_id'],
				]
			);
			?>

			<span 
				class="dashicons dashicons-editor-help wpf-tip wpf-tip-bottom" 
				data-tip="<?php echo esc_html( $subs_field['description'] ); ?>"
				style="margin-left: 8px;"
			></span>
		</p>
	<?php endforeach; ?>
</div>



<?php return; ?> <!-- Remove this line when we add CRM fields. -->

<div class="options_group">
	<!-- Subscription CRM Fields -->
	<p class="form-field">
		<label>
			<strong>Subscription Fields</strong>
		</label>

		<span>
			<?php
			echo wp_kses_post(
				sprintf(
					// translators: 1: Link start tag. 2: Link end tag.
					__( 'Sync WPSubscription related fields with your CRM. For more information, please visit our %1$s documentation %2$s.', 'wp_subscription_pro' ),
					'<a href="' . esc_url( $this->docs_url ) . '" target="_blank">',
					'</a>'
				)
			);
			?>
		</span>
	</p>

	<?php foreach ( $crm_fields as $crm_field ) : ?>
		<p class="form-field">
			<label><?php echo esc_html( $crm_field['label'] ); ?></label>

			<?php
			wpf_render_crm_field_select(
				$crm_field['setting'],
				$crm_field['meta_name'],
				$crm_field['field_id']
			);
			?>
		</p>
	<?php endforeach; ?>
</div>
