<?php

namespace SpringDevs\SubscriptionPro\Traits;

use SpringDevs\Subscription\Traits\Email as BaseEmail;

/**
 * Extended Email trait for Subscription Pro
 * Adds payment failure email templates
 */
trait Email {
	use BaseEmail;

	/**
	 * Override templates to include pro-specific email templates
	 */
	private function get_pro_templates() {
		return array(
			'subscrpt_payment_failure' => array(
				'html'  => 'emails/payment-failure-html.php',
				'plain' => 'emails/plains/payment-failure-plain.php',
			),
		);
	}

	/**
	 * Get all templates including pro templates
	 */
	private function get_all_templates() {
		$base_templates = $this->templates;
		$pro_templates  = $this->get_pro_templates();

		return array_merge( $base_templates, $pro_templates );
	}

	/**
	 * Override the template property to include pro templates
	 */
	public function __construct() {
		// This will be called after the base trait constructor
		$this->templates = $this->get_all_templates();
	}
}
