<?php
/**
 * Payment Failure Email Template (Plain Text)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/emails/plain/payment-failure-plain.php
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WP_Subscription_Pro
 * @version 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

echo wp_kses_post( '= ' . $email_heading ) . " =\n\n";

// translators: %s: customer name
echo wp_kses_post( sprintf( __( 'Hi %s,', 'wp_subscription_pro' ), $customer_name ) ) . "\n\n";

if ( $is_delayed ) {
	// translators: %s: customer name
	echo esc_html_e( 'We wanted to follow up regarding your recent subscription payment failure.', 'wp_subscription_pro' ) . "\n\n";
}

if ( $remaining_attempts > 0 ) {
	echo wp_kses_post(
		printf(
		// translators: %d: number of attempts remaining
			__( 'Your subscription payment has failed. We will automatically retry the payment. You have %d attempts remaining.', 'wp_subscription_pro' ),
			$remaining_attempts
		)
	);
} else {
	echo esc_html_e( 'Your subscription payment has failed after multiple attempts.', 'wp_subscription_pro' );
}
echo "\n\n";

if ( $remaining_attempts > 0 ) {
	echo esc_html_e( 'Please ensure your payment method is up to date to avoid service interruption.', 'wp_subscription_pro' ) . "\n\n";
} else {
	echo esc_html_e( 'Your access has been suspended. Please update your payment method and contact support to restore access.', 'wp_subscription_pro' ) . "\n\n";
}

echo wp_kses_post( '= ' . __( 'Subscription Details', 'wp_subscription_pro' ) ) . " =\n\n";

// translators: %s: subscription ID
echo wp_kses_post( sprintf( __( 'Subscription ID: #%s', 'wp_subscription_pro' ), $subscription_id ) ) . "\n";
// translators: %s: product name
echo wp_kses_post( sprintf( __( 'Product: %s', 'wp_subscription_pro' ), $product_name ) ) . "\n";
// translators: %s: amount
echo wp_kses_post( sprintf( __( 'Amount: %s', 'wp_subscription_pro' ), $amount ) ) . "\n";
// translators: %d: failure count, %d: maximum retries
echo wp_kses_post( sprintf( __( 'Failure Count: %1$d / %2$d', 'wp_subscription_pro' ), $failure_count, $max_retries ) ) . "\n\n";

if ( $remaining_attempts > 0 ) {
	echo wp_kses_post( '= ' . __( 'What Happens Next?', 'wp_subscription_pro' ) ) . " =\n\n";
	echo esc_html_e( 'We will automatically retry your payment. If you continue to experience issues, please contact our support team for assistance.', 'wp_subscription_pro' ) . "\n\n";
} else {
	echo wp_kses_post( '= ' . __( 'Action Required', 'wp_subscription_pro' ) ) . " =\n\n";
	echo esc_html_e( 'Your subscription access has been suspended. Please update your payment method and contact support to restore access.', 'wp_subscription_pro' ) . "\n\n";
}

echo esc_html_e( 'If you have any questions or need assistance, please don\'t hesitate to contact our support team.', 'wp_subscription_pro' ) . "\n\n";

echo esc_html_e( 'Best regards,', 'wp_subscription_pro' ) . "\n";
echo wp_kses_post( get_bloginfo( 'name' ) ) . "\n\n";

echo wp_kses_post( apply_filters( 'woocommerce_email_footer_text', get_option( 'woocommerce_email_footer_text' ) ) );
