<?php
/**
 * HTML Admin Order Subscribe Form for meta box.
 *
 * @since 15.8.0
 */
defined( 'ABSPATH' ) || exit;
?>
<?php
$active_subscription = $subscription_id && 'Pending' !== $status && in_array( $order->get_status(), array( 'processing', 'completed' ) ) ? true : false;
?>
<div>
    <?php
    woocommerce_wp_checkbox(
            array(
                'id'                => 'sumosubs_manual_order_subscribed',
                'name'              => 'sumosubs_manual_order_subscribed',
                'wrapper_class'     => 'sumosubs_manual_order_subscribe_field',
                'class'             => 'sumosubs-manual-order-subscribed',
                'label'             => SUMOSubs_Admin_Options::get_option( 'order_subs_subscribe_label' ),
                'value'             => $is_subscribed,
                'custom_attributes' => $subscription_id && 'Pending' !== $status ? array( 'disabled' => 'disabled' ) : array(),
            )
    );
    ?>


    <?php
    if ( SUMOSubs_Order_Subscription::$get_option[ 'can_user_select_plan' ] ) {
        ?>									
        <p class="form-field sumosubs_manual_order_duration_value_field">		
            <label for="sumosubs_manual_order_duration_value"><?php esc_html_e( 'Renewal frequency', 'sumosubscriptions' ); ?></label>	
            <span class="sumosubs-manual-order-duration-every"><?php esc_html_e( 'every ', 'sumosubscriptions' ); ?></span>
            <select class="sumosubs-manual-order-duration-value" id="sumosubs_manual_order_duration_value" name="sumosubs_manual_order_duration_value" <?php echo $active_subscription ? 'disabled' : '' ?> >
                <?php foreach ( sumo_get_subscription_duration_options( $selected_duration_period, false ) as $each_key => $each_value ) { ?>
                    <option value="<?php echo esc_attr( $each_key ); ?>" <?php selected( $subperiodvalue == $each_key, true, true ); ?>><?php echo esc_html( $each_value ); ?></option>
                <?php } ?>
            </select>
            <select class="sumosubs-manual-order-duration" id="sumosubs_manual_order_duration" name="sumosubs_manual_order_duration" <?php echo $active_subscription ? 'disabled' : '' ?> >
                <?php foreach ( sumosubs_get_duration_period_selector() as $each_key => $each_value ) { ?>
                    <option value="<?php echo esc_attr( $each_key ); ?>" <?php selected( $selected_duration_period == $each_key, true, true ); ?>><?php echo esc_html( $each_value ); ?></option>
                <?php } ?>
            </select>
        </p>		
    <?php } ?>

    <?php
    if ( SUMOSubs_Order_Subscription::$get_option[ 'can_user_select_recurring_length' ] ) {
        woocommerce_wp_select(
                array(
                    'id'                => 'sumosubs_manual_order_recurring',
                    'name'              => 'sumosubs_manual_order_recurring',
                    'wrapper_class'     => 'sumosubs_manual_order_recurring_field',
                    'class'             => 'sumosubs-select sumosubs-manual-order-recurring',
                    'value'             => $instalment,
                    'label'             => SUMOSubs_Admin_Options::get_option( 'order_subs_subscription_length_label' ),
                    'options'           => sumo_get_subscription_recurring_options(),
                    'custom_attributes' => $active_subscription ? array( 'disabled' => 'disabled' ) : array(),
                )
        );
    }
    ?>
</div>
