<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

/**
 * Handle Subscription cron events helper.
 * 
 * @class SUMOSubs_Legacy_Schedulers
 */
class SUMOSubs_Legacy_Schedulers {

    /**
     * Init SUMOSubs_Legacy_Schedulers
     */
    public static function init() {
        add_action( 'cron_schedules', __CLASS__ . '::cron_schedules', 9999 );
        add_action( 'init', __CLASS__ . '::register_post_type', 11 );
        add_action( 'sumosubscriptions_init', 'SUMOSubs_Legacy_Background_Process::init', 10 );
    }

    /**
     * Cron healthcheck.
     *
     * @param mixed $schedules Schedules.
     * @return mixed
     */
    public static function cron_schedules( $schedules ) {
        $schedules[ 'sumosubscriptions_cron_interval' ] = array(
            'interval' => 300,
            /* translators: 1: cron interval */
            'display'  => sprintf( __( 'Every %d Minutes', 'sumosubscriptions' ), 300 / 60 ),
        );

        return $schedules;
    }

    /**
     * Register cron post type.
     */
    public static function register_post_type() {
        if ( ! post_type_exists( 'sumosubs_cron_events' ) ) {
            register_post_type( 'sumosubs_cron_events', array(
                'labels'              => array(
                    'name'         => __( 'Cron events', 'sumosubscriptions' ),
                    'menu_name'    => _x( 'Cron events', 'admin menu', 'sumosubscriptions' ),
                    'search_items' => __( 'Search cron events', 'sumosubscriptions' ),
                    'not_found'    => __( 'No cron event found.', 'sumosubscriptions' ),
                ),
                'description'         => __( 'This is where scheduled cron events are stored.', 'sumosubscriptions' ),
                'public'              => false,
                'capability_type'     => 'post',
                /**
                 * Need to show scheduled crons menu?
                 * 
                 * @since 1.0
                 */
                'show_ui'             => apply_filters( 'sumosubscriptions_show_cron_events_post_type_ui', false ),
                'publicly_queryable'  => false,
                'exclude_from_search' => true,
                'show_in_menu'        => 'sumosubscriptions',
                'hierarchical'        => false,
                'show_in_nav_menus'   => false,
                'rewrite'             => false,
                'query_var'           => false,
                'supports'            => false,
                'has_archive'         => false,
                'map_meta_cap'        => true,
                'capabilities'        => array(
                    'create_posts' => 'do_not_allow',
                ),
            ) );
        }
    }
}
