<?php

namespace SPC_Pro\Builders;

use SPC\Services\Settings_Store;
use SPC_Pro\Constants;
use SW_CLOUDFLARE_PAGECACHE;

class Transform_Rule {
	/**
	 * Build transform rule expression.
	 *
	 * @return string Cache rule expression.
	 */
	public function build(): string {
		$params = array_map(
			function ( $param ) {
				return sprintf( '(http.request.uri.query contains "%s")', $param );
			},
			$this->get_excluded_query_params()
		);

		return implode( ' or ', $params );
	}

	/**
	 * Get regex expression.
	 *
	 * @return string
	 */
	public function get_regex_expression(): string {
		$params = $this->get_excluded_query_params();

		// Removes any query params that are in the excluded list and rewrites the URL to hit the cache.
		return 'regex_replace(http.request.uri.query, "(?:(?:^|&)(?:' . implode( '|', $params ) . ')=[^&]*)+", "")';
	}


	/**
	 * Get excluded query params.
	 *
	 * @return array
	 */
	private function get_excluded_query_params() {
		return Settings_Store::get_instance()->get( Constants::SETTING_CACHE_EXCLUDED_URL_PARAMS, Constants::CACHE_EXCLUDED_URL_PARAMS_DEFAULT );
	}
}
