<?php
/**
 * Settings Manager for the Pro version
 */

namespace SPC_Pro\Modules;

use SPC\Modules\Module_Interface;
use SPC\Modules\Settings_Manager as Free_Settings_Manager;
use SPC_Pro\Constants;
use SPC\Constants as CoreConstants;

/**
 * Class Settings_Manager
 */
class Settings_Manager implements Module_Interface {

	private const BASE_FIELDS = [
		Constants::SETTING_DEFER_JS                      => [
			'type'       => Free_Settings_Manager::SETTING_TYPE_BOOLEAN,
			'bust_cache' => true,
			'default'    => 0,
		],
		Constants::SETTING_DELAY_JS                      => [
			'type'       => Free_Settings_Manager::SETTING_TYPE_BOOLEAN,
			'bust_cache' => true,
			'default'    => 0,
		],
		CoreConstants::SETTING_UNUSED_CSS                => [
			'type'       => Free_Settings_Manager::SETTING_TYPE_BOOLEAN,
			'bust_cache' => true,
			'default'    => 0,
		],
		CoreConstants::SETTING_UNUSED_CSS_EXCLUDED_PATHS => [
			'type'       => Free_Settings_Manager::SETTING_TYPE_TEXTAREA,
			'bust_cache' => true,
			'default'    => [],
		],
		CoreConstants::SETTING_UNUSED_CSS_EXCLUDED_CSS   => [
			'type'       => Free_Settings_Manager::SETTING_TYPE_TEXTAREA,
			'bust_cache' => true,
			'default'    => [],
		],
		Constants::SETTING_DELAY_JS_EXCLUDED_FILES       => [
			'type'       => Free_Settings_Manager::SETTING_TYPE_TEXTAREA,
			'bust_cache' => true,
			'default'    => [],
		],
		Constants::SETTING_DELAY_JS_EXCLUDED_PATHS       => [
			'type'       => Free_Settings_Manager::SETTING_TYPE_TEXTAREA,
			'bust_cache' => true,
			'default'    => [],
		],
		Constants::SETTING_CACHE_EXCLUDED_URL_PARAMS     => [
			'type'       => Free_Settings_Manager::SETTING_TYPE_TEXTAREA,
			'bust_cache' => true,
			'sync_rules' => true,
			'default'    => Constants::CACHE_EXCLUDED_URL_PARAMS_DEFAULT,
		],
	];


	/**
	 * Initialize the module.
	 *
	 * @return void
	 */
	public function init() {
		add_filter( 'spc_additional_settings_fields', [ $this, 'add_additional_fields' ] );
	}

	/**
	 * Add additional fields to the settings handler.
	 *
	 * @param array $fields Fields to add.
	 *
	 * @return array|array[]
	 */
	public function add_additional_fields( array $fields ) {
		return array_merge( $fields, self::BASE_FIELDS );
	}
}
