<?php
/**
 * Payload Transformer Interface
 *
 * Interface for payload transformation strategies.
 *
 * @package SureForms
 * @since 1.13.0
 */

namespace SRFM_Pro\Inc\Pro\Native_Integrations\Interfaces;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Payload Transformer Interface.
 *
 * @since 1.13.0
 */
interface Payload_Transformer {
	/**
	 * Transform payload for specific integration
	 *
	 * @param array $form_data Original form data.
	 * @param array $field_mappings Field mappings configuration.
	 * @param array $context Additional context data.
	 * @return array Transformed payload.
	 * @since 1.13.0
	 */
	public function transform( $form_data, $field_mappings = [], $context = [] );

	/**
	 * Prepare test payload with sample data
	 *
	 * @param array $workflow_fields Fields from the workflow configuration.
	 * @param array $field_definitions Field definitions from the action configuration.
	 * @return array Test payload.
	 * @since 1.13.0
	 */
	public function prepare_test_payload( $workflow_fields, $field_definitions );

	/**
	 * Get integration name this transformer handles
	 *
	 * @return string Integration name.
	 * @since 1.13.0
	 */
	public function get_integration_name();
}
