<?php
/**
 * SureForms Pro Database Tables Register Class.
 *
 * @link       https://sureforms.com
 * @since      1.13.0
 * @package    sureforms-pro
 * @author     SureForms <https://sureforms.com/>
 */

namespace SRFM_Pro\Inc\Pro\Database;

use SRFM\Inc\Database\Register as Register_Base;
use SRFM_Pro\Inc\Pro\Database\Tables\Integrations;
use SRFM_Pro\Inc\Pro\Database\Tables\Save_Resume;

// Exit if accessed directly.
defined( 'ABSPATH' ) || exit;

/**
 * SureForms Pro Database Tables Register Class
 *
 * @since 1.13.0
 */
class Register extends Register_Base {
	/**
	 * Returns an array of instances/objects of our custom tables.
	 * Extending the parent method to include Pro specific tables.
	 *
	 * @since 1.13.0
	 * @return array<string,\SRFM\Inc\Database\Base>
	 */
	public static function get_db_tables() {
		// Get the parent tables first.
		$tables = parent::get_db_tables();

		// Add Pro specific tables.
		$tables['draft_submissions'] = Save_Resume::get_instance();
		$tables['integrations']      = Integrations::get_instance();

		return $tables;
	}
}
