/*QuickView*/
(function ($) {
	"use strict";
	var ajaxQcw = new Map();
	var WidgetProQCWHandler = function($scope, $) {
		var qvwrap = $scope.find('.tp-quick-view-wrap');

		if(qvwrap.length){
            Quickview(qvwrap);
		}

        function Quickview(qvwrap){
            jQuery(qvwrap).off('click').on("click", function(event){
                event.preventDefault();

                var product_id = $(this).data('product-id'),
                    customtemplate = $scope.find('.product-list').data("customtemplateqcw"),
                    template = $scope.find('.product-list').data("templateqcw");

                    if( product_id !== undefined){
                        if ( !jQuery(this).find('i').hasClass('tpqvactive') ) {
                            jQuery(this).find('i').addClass('tpqvactive').css('display','none');
                        }

                        if ( !jQuery(this).find('svg').hasClass('tpqvactive') ) {
                            jQuery(this).find('svg').addClass('tpqvactive').css('display','none');
                        }

                        if ( !jQuery(this).find('.tp-pro-view-spinner').length > 0) {
                            jQuery(this).append('<div class="tp-pro-view-spinner"></div>');
                        }

                        jQuery.ajax({
                            type: 'POST',
                            url: theplus_ajax_url,							
                            data :{
                                'action': 'tp_get_product_ajax',
                                'product_id':  product_id,
                                'custom_template':  customtemplate,
                                'template_id' : template,
                                'status': 'publish',
                                'security' : theplus_nonce,			 
                            }, 
                            beforeSend: function(jqXHR) {
                                if( ajaxQcw != null && ajaxQcw.size != 0 && ajaxQcw.size != 'undefined' && typeof ajaxQcw.abort !== "undefined"  ) {
                                    ajaxQcw.abort();
                                }

                                ajaxQcw = jqXHR;
                            },
                            success:function(response){	
                                $.fancybox.open(response);
                                $('.tp-pro-view-spinner').remove();
                                $('.tpqvactive').css('display','block').removeClass('tpqvactive');								
                            },
                            complete: function() {
                            }
                        });
                    }
            });
        }

        var FindsearchFilter = document.querySelectorAll('.tp-search-filter,.tp-pro-l-type-recently_viewed');
        if( FindsearchFilter.length > 0 ){
            jQuery(document).ajaxComplete(function () {
                var qvwrap = $scope[0].querySelectorAll('.tp-quick-view-wrap');
                    Quickview(qvwrap);
            });
        }

	};
	
	$(window).on('elementor/frontend/init', function () {
		elementorFrontend.hooks.addAction('frontend/element_ready/tp-product-listout.default', WidgetProQCWHandler);
	});
})(jQuery);