<?php
/**
 * The file that defines the widget plugin for the free version.
 *
 * @link       https://posimyth.com/
 * @since      6.3.9
 *
 * @package    the-plus-addons-for-elementor-page-builder
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Define Tpaep_Patch_Main class for the free version.
 *
 * @since 6.3.9
 */
if ( ! class_exists( 'Tpaep_Patch_Main' ) ) {

	/**
	 * Define L_Tpaef_Extensions_Main class for the free version
	 *
	 * @since 6.3.9
	 */
	class Tpaep_Patch_Main {

		/**
		 * Call __construct.
		 */
		public function __construct() {

			$theplus_options = get_option( 'theplus_options' );

			$extras_elements = ! empty( $theplus_options['extras_elements'] ) ? $theplus_options['extras_elements'] : array();
			$get_widget      = ! empty( $theplus_options['check_elements'] ) ? $theplus_options['check_elements'] : array();

			if ( in_array( 'tp_table', $get_widget ) && in_array( 'tp_plus_form', $get_widget ) ) {
				include THEPLUS_PATH . 'modules/widget-patch/table/plus-table-form.php';
			}

		}
	}
}

new Tpaep_Patch_Main();
